/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal;

import javax.sql.DataSource;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.ClassHelper;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.ExceptionSqlLogType;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.RequiresNewController;
import org.seasar.doma.jdbc.SqlFileRepository;
import org.seasar.doma.jdbc.dialect.Dialect;

public class RuntimeConfig
implements Config {
    protected final Config config;
    protected final DataSource dataSource;

    public RuntimeConfig(Config originalConfig) {
        this(originalConfig, originalConfig.getDataSource());
    }

    public RuntimeConfig(Config config, DataSource dataSource) {
        AssertionUtil.assertNotNull(config);
        AssertionUtil.assertNotNull(dataSource);
        this.config = config;
        this.dataSource = dataSource;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public String getDataSourceName() {
        return this.config.getDataSourceName();
    }

    @Override
    public Dialect getDialect() {
        return this.config.getDialect();
    }

    @Override
    public SqlFileRepository getSqlFileRepository() {
        return this.config.getSqlFileRepository();
    }

    @Override
    public JdbcLogger getJdbcLogger() {
        return this.config.getJdbcLogger();
    }

    @Override
    public RequiresNewController getRequiresNewController() {
        return this.config.getRequiresNewController();
    }

    @Override
    public ClassHelper getClassHelper() {
        return this.config.getClassHelper();
    }

    @Override
    public ExceptionSqlLogType getExceptionSqlLogType() {
        return this.config.getExceptionSqlLogType();
    }

    @Override
    public int getFetchSize() {
        return this.config.getFetchSize();
    }

    @Override
    public int getMaxRows() {
        return this.config.getMaxRows();
    }

    @Override
    public int getQueryTimeout() {
        return this.config.getQueryTimeout();
    }

    @Override
    public int getBatchSize() {
        return this.config.getBatchSize();
    }

    @Override
    public boolean ignoreUnknownColumn() {
        return this.config.ignoreUnknownColumn();
    }
}

