/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.document;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.document.Header;
import option.io.pdfcommon.document.PdfDocumentInfo;
import option.io.pdfcommon.document.Trailer;
import option.io.pdfcommon.document.XrefReference;
import option.io.pdfcommon.document.XrefTable;
import option.io.pdfcommon.io.PdfOutFile;

public class PdfDocument {
    private Body body;
    private Header al;
    private XrefTable am;
    private Trailer an;
    private PdfDocumentInfo ao = new PdfDocumentInfo(this);
    private PdfOutFile ap;

    public PdfDocument() {
        this.body = new Body(this);
        this.ap = new PdfOutFile();
    }

    public Body getBody() {
        return this.body;
    }

    public XrefTable getXref() {
        return this.am;
    }

    protected void setOutput() {
        this.al = new Header();
        this.am = new XrefTable();
        this.an = new Trailer();
        this.body.add(this.ao);
        this.am.addElement(new XrefReference(0, 65535, false));
        this.al.write(this.ap);
        this.body.write(this.ap);
        this.an.setLocationOfXref(this.ap.size());
        this.an.setSize(this.am.size());
        this.an.setRoot(this.body.getCatalog());
        this.an.setInfo(this.ao);
        this.am.write(this.ap);
        this.an.write(this.ap);
    }

    public ByteArrayOutputStream getByteArrayOutputStream() {
        return this.ap.getByteStream();
    }

    public byte[] getData() {
        return this.ap.getData();
    }

    public void setData(byte[] byArray) {
        this.ap.setData(byArray);
    }

    public void flush() {
        this.body.flush();
        this.ap.flush();
    }

    public void close() {
        this.body.clear();
        this.ap.close();
    }

    public boolean writeToFile() {
        this.setOutput();
        try {
            this.ap.writeToFile();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void writeToStream(OutputStream outputStream) {
        this.setOutput();
        this.ap.writeToStream(outputStream);
    }

    public void writeToFile(String string) {
        this.setOutput();
        this.ap.writeToFile(string);
    }

    public PdfOutFile getOutputFile() {
        return this.ap;
    }

    public void setOutputFile(PdfOutFile pdfOutFile) {
        this.ap = pdfOutFile;
    }

    public PdfDocumentInfo getInfo() {
        return this.ao;
    }

    public void setInfo(PdfDocumentInfo pdfDocumentInfo) {
        pdfDocumentInfo.setDocument(this);
        this.ao = pdfDocumentInfo;
    }
}

