/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.searches.binarysort;

import java.util.Vector;
import jp.kitec.math.searches.NodeComparator;
import jp.kitec.math.searches.binarysort.BinarySortBuilder;
import jp.kitec.math.searches.binarysort.BinarySortNode;
import jp.kitec.math.searches.binarytree.BinaryTree;
import jp.kitec.math.searches.binarytree.BinaryTreeNode;

public class BinarySort
extends BinaryTree {
    public static final int DIMENSION = 30;
    BinarySortBuilder builder;
    BinaryTreeNode[] searchNodes;
    BinaryTreeNode[] tmpNodes;
    int searchNodesIndex;
    int tmpNodesIndex;
    int allNodes;

    public static void main(String[] stringArray) {
        BinarySort.Test1();
    }

    public static void Test1() {
        BinarySort binarySort;
        BinarySort binarySort2 = binarySort = new BinarySort(new Comp());
        binarySort2.getClass();
        Test test = binarySort2.new Test(1.0);
        binarySort.add(test);
        BinarySort binarySort3 = binarySort;
        binarySort3.getClass();
        test = binarySort3.new Test(2.0);
        binarySort.add(test);
        BinarySort binarySort4 = binarySort;
        binarySort4.getClass();
        test = binarySort4.new Test(3.0);
        binarySort.add(test);
        Vector vector = new Vector(10, 10);
        binarySort.getAllNode(vector);
    }

    public BinarySort(NodeComparator nodeComparator, BinarySortBuilder binarySortBuilder) {
        super(nodeComparator);
        this.builder = binarySortBuilder;
        this.searchNodes = new BinaryTreeNode[30];
        this.tmpNodes = new BinaryTreeNode[30];
        this.searchNodesIndex = 0;
        this.tmpNodesIndex = 0;
        this.allNodes = 0;
    }

    public BinarySort(NodeComparator nodeComparator) {
        this(nodeComparator, null);
    }

    public void clearNodes() {
        super.clearNodes();
        if (this.builder != null) {
            this.builder.reset();
        }
        this.allNodes = 0;
    }

    public int getNodeCount() {
        return this.allNodes;
    }

    public boolean search() {
        return false;
    }

    public BinaryTreeNode search(double d) {
        BinarySortNode binarySortNode = (BinarySortNode)this.root;
        boolean bl = false;
        while (binarySortNode != null) {
            int n = this.comparator.compare(binarySortNode.get(), d);
            if (n == 0) {
                return binarySortNode;
            }
            if (n > 0) {
                binarySortNode = (BinarySortNode)binarySortNode.getLeft();
                continue;
            }
            binarySortNode = (BinarySortNode)binarySortNode.getRight();
        }
        return binarySortNode;
    }

    private Object search(Object object) {
        boolean bl = false;
        this.tmpNodes[0] = this.root;
        this.tmpNodesIndex = 1;
        while (this.tmpNodes[this.tmpNodesIndex - 1] != null) {
            int n = this.comparator.compare(this.tmpNodes[this.tmpNodesIndex - 1].get(), object);
            if (n == 0) {
                return this.tmpNodes[this.tmpNodesIndex - 1].get();
            }
            this.tmpNodes[this.tmpNodesIndex] = n > 0 ? this.tmpNodes[this.tmpNodesIndex - 1].getLeft() : this.tmpNodes[this.tmpNodesIndex - 1].getRight();
            ++this.tmpNodesIndex;
        }
        return null;
    }

    public Object getFirst() {
        BinaryTreeNode binaryTreeNode;
        this.searchNodes[0] = binaryTreeNode = this.root;
        this.searchNodesIndex = 1;
        while (binaryTreeNode != null && binaryTreeNode.getLeft() != null) {
            this.searchNodes[this.searchNodesIndex] = binaryTreeNode = binaryTreeNode.getLeft();
            ++this.searchNodesIndex;
        }
        if (binaryTreeNode == null) {
            return null;
        }
        return binaryTreeNode.get();
    }

    public Object getNext() {
        if (this.searchNodesIndex <= 0 || this.searchNodes[this.searchNodesIndex - 1] == null) {
            return null;
        }
        if (this.searchNodes[this.searchNodesIndex - 1].getRight() != null) {
            this.searchNodes[this.searchNodesIndex] = this.searchNodes[this.searchNodesIndex - 1].getRight();
            ++this.searchNodesIndex;
            while (this.searchNodes[this.searchNodesIndex - 1] != null) {
                if (this.searchNodes[this.searchNodesIndex - 1].getLeft() == null) {
                    return this.searchNodes[this.searchNodesIndex - 1].get();
                }
                this.searchNodes[this.searchNodesIndex] = this.searchNodes[this.searchNodesIndex - 1].getLeft();
                ++this.searchNodesIndex;
            }
            return this.searchNodes[this.searchNodesIndex - 1].get();
        }
        --this.searchNodesIndex;
        while (this.searchNodesIndex > 0 && this.searchNodes[this.searchNodesIndex - 1] != null) {
            if (this.searchNodes[this.searchNodesIndex - 1].getLeft() == this.searchNodes[this.searchNodesIndex]) {
                return this.searchNodes[this.searchNodesIndex - 1].get();
            }
            --this.searchNodesIndex;
        }
        return null;
    }

    public Object getPrev(Object object) {
        this.search(object);
        if (this.tmpNodesIndex <= 0 || this.tmpNodes[this.tmpNodesIndex - 1] == null) {
            return null;
        }
        if (this.tmpNodes[this.tmpNodesIndex - 1].getLeft() != null) {
            this.tmpNodes[this.tmpNodesIndex] = this.tmpNodes[this.tmpNodesIndex - 1].getLeft();
            ++this.tmpNodesIndex;
            while (this.tmpNodes[this.tmpNodesIndex - 1] != null) {
                if (this.tmpNodes[this.tmpNodesIndex - 1].getRight() == null) {
                    return this.tmpNodes[this.tmpNodesIndex - 1].get();
                }
                this.tmpNodes[this.tmpNodesIndex] = this.tmpNodes[this.tmpNodesIndex - 1].getRight();
                ++this.tmpNodesIndex;
            }
            return this.tmpNodes[this.tmpNodesIndex - 1].get();
        }
        --this.tmpNodesIndex;
        while (this.tmpNodesIndex > 0 && this.tmpNodes[this.tmpNodesIndex - 1] != null) {
            if (this.tmpNodes[this.tmpNodesIndex - 1].getRight() == this.tmpNodes[this.tmpNodesIndex]) {
                return this.tmpNodes[this.tmpNodesIndex - 1].get();
            }
            --this.tmpNodesIndex;
        }
        return null;
    }

    public Object getNext(Object object) {
        this.search(object);
        if (this.tmpNodesIndex <= 0 || this.tmpNodes[this.tmpNodesIndex - 1] == null) {
            return null;
        }
        if (this.tmpNodes[this.tmpNodesIndex - 1].getRight() != null) {
            this.tmpNodes[this.tmpNodesIndex] = this.tmpNodes[this.tmpNodesIndex - 1].getRight();
            ++this.tmpNodesIndex;
            while (this.tmpNodes[this.tmpNodesIndex - 1] != null) {
                if (this.tmpNodes[this.tmpNodesIndex - 1].getLeft() == null) {
                    return this.tmpNodes[this.tmpNodesIndex - 1].get();
                }
                this.tmpNodes[this.tmpNodesIndex] = this.tmpNodes[this.tmpNodesIndex - 1].getLeft();
                ++this.tmpNodesIndex;
            }
            return this.tmpNodes[this.tmpNodesIndex - 1].get();
        }
        --this.tmpNodesIndex;
        while (this.tmpNodesIndex > 0 && this.tmpNodes[this.tmpNodesIndex - 1] != null) {
            if (this.tmpNodes[this.tmpNodesIndex - 1].getLeft() == this.tmpNodes[this.tmpNodesIndex]) {
                return this.tmpNodes[this.tmpNodesIndex - 1].get();
            }
            --this.tmpNodesIndex;
        }
        return null;
    }

    public void getAllNode(Vector vector) {
        Object object = this.getFirst();
        while (object != null) {
            vector.add(object);
            object = this.getNext();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void add(Object object) {
        BinarySortNode binarySortNode = (BinarySortNode)this.root;
        this.tmpNodes[0] = this.root;
        this.tmpNodesIndex = 1;
        if (this.root == null) {
            this.root = this.createNewNode(object);
            ++this.allNodes;
            return;
        }
        while (binarySortNode != null) {
            block8: {
                Object object2 = binarySortNode.get();
                int n = this.comparator.compare(object2, object);
                if (n == 0 && this.comparator.addSameValue(object2, object)) {
                    return;
                }
                if (n > 0) {
                    if (binarySortNode.getLeft() != null) {
                        binarySortNode = (BinarySortNode)binarySortNode.getLeft();
                        break block8;
                    } else {
                        BinarySortNode binarySortNode2 = this.createNewNode(object);
                        binarySortNode.setLeft(binarySortNode2);
                        break;
                    }
                }
                if (binarySortNode.getRight() != null) {
                    binarySortNode = (BinarySortNode)binarySortNode.getRight();
                } else {
                    BinarySortNode binarySortNode3 = this.createNewNode(object);
                    binarySortNode.setRight(binarySortNode3);
                    break;
                }
            }
            this.tmpNodes[this.tmpNodesIndex] = binarySortNode;
            ++this.tmpNodesIndex;
        }
        ++this.allNodes;
        this.balance();
    }

    BinarySortNode createNewNode(Object object) {
        BinarySortNode binarySortNode;
        BinarySortNode binarySortNode2 = binarySortNode = this.builder != null ? (BinarySortNode)this.builder.addNode(object) : null;
        if (binarySortNode == null) {
            binarySortNode = new BinarySortNode();
            binarySortNode.set(object);
        }
        return binarySortNode;
    }

    private void balance() {
        while (this.tmpNodesIndex > 0) {
            BinarySortNode binarySortNode;
            BinarySortNode binarySortNode2;
            int n;
            BinarySortNode binarySortNode3 = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex - 1].getLeft();
            int n2 = binarySortNode3 != null ? binarySortNode3.getDepth() + 1 : 0;
            int n3 = Math.abs(n2 - (n = (binarySortNode2 = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex - 1].getRight()) != null ? binarySortNode2.getDepth() + 1 : 0));
            if (n3 >= 2) {
                BinarySortNode binarySortNode4;
                BinarySortNode binarySortNode5;
                BinarySortNode binarySortNode6;
                if (n > n2) {
                    binarySortNode6 = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex - 1];
                    binarySortNode5 = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex - 1].getRight();
                    binarySortNode4 = (BinarySortNode)binarySortNode5.getLeft();
                    if (this.tmpNodesIndex > 1) {
                        if (this.tmpNodes[this.tmpNodesIndex - 2].getLeft() == this.tmpNodes[this.tmpNodesIndex - 1]) {
                            this.tmpNodes[this.tmpNodesIndex - 2].setLeft(binarySortNode5);
                        } else {
                            this.tmpNodes[this.tmpNodesIndex - 2].setRight(binarySortNode5);
                        }
                    } else {
                        this.root = binarySortNode5;
                    }
                    binarySortNode5.setLeft(binarySortNode6);
                    binarySortNode6.setRight(binarySortNode4);
                } else {
                    binarySortNode6 = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex - 1];
                    binarySortNode5 = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex - 1].getLeft();
                    binarySortNode4 = (BinarySortNode)binarySortNode5.getRight();
                    if (this.tmpNodesIndex > 1) {
                        if (this.tmpNodes[this.tmpNodesIndex - 2].getLeft() == this.tmpNodes[this.tmpNodesIndex - 1]) {
                            this.tmpNodes[this.tmpNodesIndex - 2].setLeft(binarySortNode5);
                        } else {
                            this.tmpNodes[this.tmpNodesIndex - 2].setRight(binarySortNode5);
                        }
                    } else {
                        this.root = binarySortNode5;
                    }
                    binarySortNode5.setRight(binarySortNode6);
                    binarySortNode6.setLeft(binarySortNode4);
                }
                this.tmpNodes[this.tmpNodesIndex - 1] = binarySortNode5;
                this.tmpNodes[this.tmpNodesIndex] = binarySortNode6;
                binarySortNode3 = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex].getLeft();
                binarySortNode2 = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex].getRight();
                n2 = binarySortNode3 != null ? binarySortNode3.getDepth() + 1 : 0;
                n = binarySortNode2 != null ? binarySortNode2.getDepth() + 1 : 0;
                binarySortNode = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex];
                binarySortNode.setDepth((byte)(n2 > n ? n2 : n));
                binarySortNode3 = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex - 1].getLeft();
                binarySortNode2 = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex - 1].getRight();
                n2 = binarySortNode3 != null ? binarySortNode3.getDepth() + 1 : 0;
                n = binarySortNode2 != null ? binarySortNode2.getDepth() + 1 : 0;
            }
            binarySortNode = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex - 1];
            binarySortNode.setDepth((byte)(n2 > n ? n2 : n));
            --this.tmpNodesIndex;
        }
    }

    public static class Comp
    implements NodeComparator {
        public synchronized int compare(Object object, Object object2) {
            Test test = (Test)object;
            Test test2 = (Test)object2;
            if (test.value == test2.value) {
                return 0;
            }
            if (test.value < test2.value) {
                return -1;
            }
            return 1;
        }

        public synchronized int compare(Object object, double d) {
            Test test = (Test)object;
            if (test.value == d) {
                return 0;
            }
            if (test.value < d) {
                return -1;
            }
            return 1;
        }

        public synchronized boolean addSameValue(Object object, Object object2) {
            return false;
        }
    }

    public class Test {
        public double value;

        public Test(double d) {
            this.value = d;
        }
    }
}

