/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.SystemColor;
import jp.kitec.kwt.KFont;

public class GroupBox2
extends Panel {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private final int MARGIN = 2;
    private String mTitle;
    private int mAlign = 0;
    private Insets mIns = new Insets(2, 2, 2, 2);
    private Color mTextColor;
    private Color mLineDark;
    private Color mLineLight;
    private Color mLineColor;
    private Color mLineShadow;

    public GroupBox2(Component component, String string) {
        this.mTitle = string;
        this.setLayout(new BorderLayout());
        this.add(component, "Center");
        this.mLineLight = SystemColor.controlLtHighlight;
        this.mLineDark = SystemColor.controlShadow;
        this.mLineColor = SystemColor.controlLtHighlight;
        this.mLineShadow = SystemColor.controlShadow;
    }

    public GroupBox2(Component component, String string, int n) {
        this(component, string);
        this.mAlign = n;
    }

    public void setColor(Color color, Color color2) {
        this.mTextColor = color;
        this.setForeground(this.mTextColor);
        this.mLineLight = color2.brighter();
        this.mLineDark = color2.darker();
    }

    public void setInsets(Insets insets) {
        if (insets != null) {
            this.mIns = insets;
        }
    }

    public Insets getInsets() {
        Graphics graphics = this.getGraphics();
        int n = graphics.getFont().getSize();
        if (n > this.mIns.top) {
            this.mIns.top = n;
        }
        graphics.dispose();
        return new Insets(this.mIns.top, this.mIns.left, this.mIns.bottom, this.mIns.right);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.drawBorder(graphics);
        this.drawTitle(graphics);
    }

    public void drawBorder(Graphics graphics) {
        graphics.setFont(this.getFont());
        Font font = graphics.getFont();
        int n = font.getSize();
        graphics.setColor(this.mLineColor);
        graphics.setColor(this.mLineLight);
        graphics.drawRect(1, n / 2 + 1, this.getWidth() - 2, this.getHeight() - 2 - n / 2);
        graphics.drawRect(0, n / 2, this.getWidth() - 2 + 1, this.getHeight() - 2 - n / 2 + 1);
        graphics.setColor(this.mLineShadow);
        graphics.setColor(this.mLineDark);
        graphics.drawRect(0, n / 2, this.getWidth() - 2, this.getHeight() - 2 - n / 2);
    }

    public void drawTitle(Graphics graphics) {
        int n;
        int n2;
        if (this.mTitle == null || this.mTitle.length() < 1) {
            return;
        }
        KFont kFont = KFont.getFont((Object)graphics.getFont());
        int n3 = kFont.stringWidth(this.mTitle);
        if (n3 + (n2 = kFont.stringWidth("\u3042") / 2) * 2 + 2 > this.getWidth()) {
            return;
        }
        int n4 = n3 + n2 * 2;
        switch (this.mAlign) {
            case 2: {
                n = this.getWidth() - n3 - n2 * 3;
                break;
            }
            case 1: {
                n = this.getWidth() / 2 - n3 / 2 - n2;
                break;
            }
            default: {
                n = n2;
            }
        }
        graphics.setColor(this.getBackground());
        graphics.clearRect(n, 0, n4, kFont.getHeight());
        graphics.setColor(this.getForeground());
        graphics.drawString(this.mTitle, n + n2, kFont.getAscent() - 2);
    }
}

