/*
 * Decompiled with CFR 0.152.
 */
package option.jsgroup.estimate;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import option.jsgroup.estimate.Estimate;
import option.jsgroup.estimate.EstimateFormatType;
import option.jsgroup.estimate.EstimateStringConverter;
import option.jsgroup.estimate.toex.ToexEstimateWriter;
import option.jsgroup.estimate.topics.TopicsEstimateWriter;

public class EstimateIO {
    private String mEncode = "MS932";
    private String mLineSeparator = "\r\n";

    public void write(Collection<Estimate> collection, OutputStream outputStream, EstimateFormatType estimateFormatType) throws IOException {
        EstimateStringConverter estimateStringConverter = null;
        switch (estimateFormatType) {
            case TIOS: {
                estimateStringConverter = new ToexEstimateWriter();
                break;
            }
            case TopicsPro: {
                estimateStringConverter = new TopicsEstimateWriter();
                break;
            }
            default: {
                throw new IOException("Unsupported format " + (Object)((Object)estimateFormatType));
            }
        }
        PrintStream printStream = new PrintStream(outputStream, false, this.mEncode);
        for (Estimate estimate : collection) {
            printStream.print(estimateStringConverter.toString(estimate));
            printStream.print(this.mLineSeparator);
        }
        printStream.flush();
    }

    public String getEncode() {
        return this.mEncode;
    }

    public void setEncode(String string) {
        this.mEncode = string;
    }

    public String getLineSeparator() {
        return this.mLineSeparator;
    }

    public void setLineSeparator(String string) {
        this.mLineSeparator = string;
    }
}

