/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.type;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import option.gad.core.type.GdMutableType;
import option.gad.core.type.GdMutableTypeFactory;
import option.gad.core.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GdAbstractMutableTypeFactory<T extends GdMutableType<?>>
implements GdMutableTypeFactory<T> {
    protected LinkedHashMap<String, T> mMutableTypeMap = new LinkedHashMap();

    protected GdAbstractMutableTypeFactory() {
    }

    @Override
    public T getTypeByName(String string) {
        GdMutableType gdMutableType = (GdMutableType)this.mMutableTypeMap.get(string);
        if (gdMutableType == null) {
            gdMutableType = this.createType(string);
        }
        return (T)gdMutableType;
    }

    @Override
    public T createType(String string) {
        Integer n = this.mMutableTypeMap.size();
        GdMutableType gdMutableType = (GdMutableType)ReflectUtil.newInstance(this.getTypeClass(), (Object[])new Object[]{n, string});
        this.mMutableTypeMap.put(string, gdMutableType);
        return (T)gdMutableType;
    }

    protected abstract Class<? extends T> getTypeClass();

    @Override
    public T getTypeById(Integer n) {
        for (GdMutableType gdMutableType : this.mMutableTypeMap.values()) {
            if (!n.equals(gdMutableType.id())) continue;
            return (T)gdMutableType;
        }
        return null;
    }

    public T getTypeByBitField(String string) {
        int n = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            ++n;
            if (c == '1') break;
        }
        if (n == 0) {
            return null;
        }
        return this.getTypeById(n);
    }

    public List<String> names() {
        return new ArrayList<String>(this.mMutableTypeMap.keySet());
    }

    public List<T> values() {
        return new ArrayList<T>(this.mMutableTypeMap.values());
    }
}

