/*
 * Decompiled with CFR 0.152.
 */
package sandbox.gui.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import sandbox.gui.basic.JGraphicsButton;

public class JGraphicsBorderButton
extends JGraphicsButton {
    private int ex = 2;
    private int ey = 3;
    private int ez = 3;
    private int eA = 2;
    private Color bK = new Color(189, 190, 189);
    private Color eB = Color.white;

    public JGraphicsBorderButton(String string, Image image) {
        super(string, image, null);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = dimension.width + (this.ez + this.ex) * 2 + this.ey + 1;
        dimension.height = dimension.height + (this.eA + this.ex) * 2 + this.ey + 1;
        return dimension;
    }

    public Color getBorderColor() {
        return new Color(this.bK.getRed(), this.bK.getGreen(), this.bK.getBlue());
    }

    public Color getInnerColor() {
        return new Color(this.eB.getRed(), this.eB.getGreen(), this.eB.getBlue());
    }

    public int getBorderWidth() {
        return this.ex;
    }

    public int getHgap() {
        return this.ez;
    }

    public int getVgap() {
        return this.eA;
    }

    public int getShadowWidth() {
        return this.ey;
    }

    public void setBorderColor(Color color) {
        if (color == null || this.bK.equals(color)) {
            return;
        }
        this.bK = color;
        this.repaint();
    }

    public void setInnerColor(Color color) {
        if (color == null || this.eB.equals(color)) {
            return;
        }
        this.eB = color;
        this.repaint();
    }

    public void setBorderWidth(int n) {
        if (n <= 0 || this.ex == n) {
            return;
        }
        this.ex = n;
        this.repaint();
    }

    public void setHgap(int n) {
        if (n < 0 || this.ez == n) {
            return;
        }
        this.ez = n;
        this.repaint();
    }

    public void setVgap(int n) {
        if (n < 0 || this.eA == n) {
            return;
        }
        this.eA = n;
        this.repaint();
    }

    public void setShadowWidth(int n) {
        if (n < 0 || this.ey == n) {
            return;
        }
        this.ey = n;
    }

    public void paintComponent(Graphics graphics) {
        if (this.mForeImage == null) {
            return;
        }
        Dimension dimension = this.mForeImage.getPreferredSize();
        int n = this.getState() == 1 ? 0 : 1;
        int n2 = this.getState() == 1 ? 0 : 1;
        this.a(graphics, n, n2, dimension.width, dimension.height);
        this.mForeImage.paintIcon(graphics, n + this.ex + this.ez, n2 + this.ex + this.eA);
    }

    protected void paintButtonNormal() {
        if (!this.isEnabled()) {
            return;
        }
        this.setState(1);
        this.repaint();
    }

    protected void paintButtonPressed() {
        if (!this.isEnabled()) {
            return;
        }
        this.setState(0);
        this.repaint();
    }

    private void a(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n3 + this.ex + this.ez * 2;
        int n6 = n4 + this.ex + this.eA * 2;
        Color color = graphics.getColor();
        graphics.setColor(Color.gray);
        graphics.fillRect(n + this.ey, n2 + this.ey, n5, n6);
        graphics.setColor(this.eB);
        graphics.fillRect(n, n2, n5, n6);
        graphics.setColor(this.bK);
        graphics.drawRect(n, n2, n5, n6);
        graphics.setColor(color);
    }
}

