/*
 * Decompiled with CFR 0.152.
 */
package option.pdf;

import com.kt.geom.K2DPathFigureArc;
import com.kt.geom.K2DPathFigureLine;
import com.kt.geom.KLocalAxis;
import com.kt.util.KCollection;
import com.kt.util.RefList;
import java.awt.Color;
import java.awt.Image;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.ImageObserver;
import java.text.DecimalFormat;
import java.util.Vector;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KFont;
import jp.kitec.kwt.KLineType;
import jp.kitec.kwt.RichGraphicsUtil;
import nethome.geom.primitive.GPoint2Df;
import nethome.ui.MainComponent;
import option.pdf.PdfCommandGraphics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfRichGraphicsAdapter
implements IRichGraphics {
    private static float[] en = new float[128];
    private static float[] eo = new float[128];
    private static final KLineType ep = new KLineType("", new float[]{0.0f, 0.0f}, 0.1f);
    private PdfCommandGraphics mGraphics;
    private float eq;
    private GeneralPath er = new GeneralPath();
    private boolean es = false;

    public PdfRichGraphicsAdapter(PdfCommandGraphics pdfCommandGraphics) {
        this.mGraphics = pdfCommandGraphics;
    }

    public void scale(float f) {
        this.eq = f;
    }

    public float getScale() {
        return this.eq;
    }

    public void setFontEmbed(boolean bl) {
        this.mGraphics.setFontEmbed(bl);
    }

    public void setClipArea(float f, float f2, float f3, float f4) {
        this.mGraphics.setClip(Math.min(f, f3), Math.max(f2, f4), Math.abs(f3 - f), Math.abs(f4 - f2));
    }

    public void releaseClipArea() {
        this.mGraphics.releaseClip();
    }

    public void setColor(Color color) {
        this.mGraphics.setColor(color);
    }

    public void drawLine(float f, float f2, float f3, float f4, KLineType kLineType) {
        this.setLineType(kLineType);
        this.mGraphics.drawLine(f, f2, f3, f4);
    }

    public void drawCircle(float f, float f2, float f3, float f4, float f5, KLineType kLineType) {
        this.setLineType(kLineType);
        if (Math.abs(f4 - f5) < 0.001f) {
            f4 = 0.0f;
            f5 = 360.0f;
        }
        this.mGraphics.drawArc(f - f3, f2 + f3, f3 * 2.0f, f3 * 2.0f, f4, f5, false);
    }

    public void drawFillCircle(float f, float f2, float f3, float f4, float f5, KLineType kLineType) {
        this.setLineType(kLineType);
        if (Math.abs(f4 - f5) < 0.001f) {
            f4 = 0.0f;
            f5 = 360.0f;
        }
        this.mGraphics.drawArc(f - f3, f2 + f3, f3 * 2.0f, f3 * 2.0f, f4, f5, true);
    }

    public void drawEllipse(float f, float f2, float f3, float f4, float f5, float f6, KLineType kLineType) {
        this.a(f, f2, f3, f4, f5, f6, kLineType, false);
    }

    public void drawFillEllipse(float f, float f2, float f3, float f4, float f5, float f6, KLineType kLineType) {
        this.a(f, f2, f3, f4, f5, f6, kLineType, true);
    }

    private void a(float f, float f2, float f3, float f4, float f5, float f6, KLineType kLineType, boolean bl) {
        this.setLineType(kLineType);
        if (Math.abs(f5 - f6) < 0.001f) {
            f5 = 0.0f;
            f6 = 360.0f;
        }
        this.mGraphics.drawArc(f - f4, f2 + f3, f4 * 2.0f, f3 * 2.0f, f5, f6, bl);
    }

    public void drawRect(float f, float f2, float f3, float f4, KLineType kLineType) {
        this.setLineType(kLineType);
        this.mGraphics.drawRect(Math.min(f, f3), Math.max(f2, f4), Math.abs(f3 - f), Math.abs(f4 - f2), false);
    }

    public void drawFillRect(float f, float f2, float f3, float f4, KLineType kLineType) {
        this.setLineType(kLineType);
        this.mGraphics.drawRect(Math.min(f, f3), Math.max(f2, f4), Math.abs(f3 - f), Math.abs(f4 - f2), true);
    }

    public void drawRoundRect(float f, float f2, float f3, float f4, float f5, KLineType kLineType) {
        this.setLineType(kLineType);
        this.mGraphics.drawRoundRect(Math.min(f, f3), Math.max(f2, f4), Math.abs(f3 - f), Math.abs(f4 - f2), f5 * 2.0f, f5 * 2.0f, false);
    }

    public void drawFillRoundRect(float f, float f2, float f3, float f4, float f5, KLineType kLineType) {
        this.setLineType(kLineType);
        this.mGraphics.drawRoundRect(Math.min(f, f3), Math.max(f2, f4), Math.abs(f3 - f), Math.abs(f4 - f2), f5 * 2.0f, f5 * 2.0f, true);
    }

    public void drawPolygon(KCollection kCollection, KLineType kLineType) {
        this.setLineType(kLineType);
        this.a(kCollection);
        this.mGraphics.drawPolygon(en, eo, kCollection.size(), false);
    }

    public void drawFillPolygon(KCollection kCollection, KLineType kLineType) {
        this.setLineType(kLineType);
        this.a(kCollection);
        this.mGraphics.drawPolygon(en, eo, kCollection.size(), true);
    }

    public void drawPolyLine(KCollection kCollection, KLineType kLineType) {
        this.setLineType(kLineType);
        this.a(kCollection);
        for (int i = 0; i < kCollection.size() - 1; ++i) {
            this.drawLine(en[i], eo[i], en[i + 1], eo[i + 1], kLineType);
        }
    }

    public void drawImage(Image image, String string, float f, float f2, float f3, float f4) {
        this.drawImage(image, f, f2, f3, f4);
    }

    public void drawImage(Image image, float f, float f2, float f3, float f4) {
        this.mGraphics.drawImage(image, Math.min(f, f3), Math.max(f2, f4), Math.abs(f3 - f), Math.abs(f4 - f2), (ImageObserver)MainComponent.getInstance().getApplication().getImageObserver());
    }

    public void drawText(String string, float f, float f2, String string2, int n, float f3, float f4) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.mGraphics.setFont(string2, n, f3);
        KFont kFont = KFont.getFont((String)string2, (int)n, (float)f3);
        this.mGraphics.drawString(string, f, f2, false, -f4, kFont.stringWidthf(string), "spaceX");
    }

    public void drawShadePolygon(Vector<RefList> vector, float f, float f2, float f3, float f4, Color color, Color color2) {
        Object object;
        Object object2;
        int n = 0;
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            object2 = vector.elementAt(i);
            n += object2.size();
        }
        float[] fArray = new float[n];
        object2 = new float[n];
        int n2 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            object = vector.elementAt(i);
            nArray[i] = object.size();
            for (int j = 0; j < object.size(); ++j) {
                float[] fArray2 = (float[])object.elementAt(j);
                fArray[n2] = fArray2[0];
                object2[n2] = (RefList)fArray2[1];
                ++n2;
            }
        }
        DecimalFormat decimalFormat = new DecimalFormat("000");
        object = new StringBuffer("TYPE2_");
        ((StringBuffer)object).append(decimalFormat.format(color.getRed()));
        ((StringBuffer)object).append(decimalFormat.format(color.getGreen()));
        ((StringBuffer)object).append(decimalFormat.format(color.getBlue()));
        ((StringBuffer)object).append(decimalFormat.format(color2.getRed()));
        ((StringBuffer)object).append(decimalFormat.format(color2.getGreen()));
        ((StringBuffer)object).append(decimalFormat.format(color2.getBlue()));
        this.mGraphics.drawShadingGroupPolygon(((StringBuffer)object).toString(), fArray, (float[])object2, nArray);
    }

    public void setLineType(KLineType kLineType) {
        if (kLineType != null) {
            this.mGraphics.setLineWidth(kLineType.mWidth);
            if (kLineType.mStroke != null) {
                this.mGraphics.setLinePattern(kLineType.mStroke);
            } else {
                this.mGraphics.setLinePattern(PdfRichGraphicsAdapter.ep.mStroke);
            }
        } else {
            this.mGraphics.setLineWidth(PdfRichGraphicsAdapter.ep.mWidth);
            this.mGraphics.setLinePattern(PdfRichGraphicsAdapter.ep.mStroke);
        }
    }

    private void a(KCollection kCollection) {
        if (kCollection.size() > en.length) {
            en = new float[kCollection.size()];
            eo = new float[kCollection.size()];
        }
        for (int i = 0; i < kCollection.size(); ++i) {
            PdfRichGraphicsAdapter.en[i] = ((GPoint2Df)kCollection.elementAt((int)i)).x;
            PdfRichGraphicsAdapter.eo[i] = ((GPoint2Df)kCollection.elementAt((int)i)).y;
        }
    }

    public void drawImage(Image image, String string, String string2, float f, float f2, float f3, float f4) {
    }

    public void pathInit(int n) {
        this.er.reset();
        this.er.setWindingRule(n);
        this.mGraphics.draw("[multiline]");
        this.mGraphics.draw("path,start");
        this.es = true;
    }

    public void pathClear() {
        this.er.reset();
        this.mGraphics.draw("path,end");
        this.mGraphics.draw("[multiline]");
        this.es = false;
    }

    public void pathMoveTo(double d, double d2, KLocalAxis kLocalAxis) {
        float f = (float)this.a(d, d2, kLocalAxis);
        float f2 = (float)this.b(d, d2, kLocalAxis);
        if (Double.isNaN(f) || Double.isNaN(f2)) {
            throw new IllegalArgumentException();
        }
        if (Double.isInfinite(f) || Double.isInfinite(f2)) {
            throw new IllegalArgumentException();
        }
        Point2D point2D = this.er.getCurrentPoint();
        if (point2D != null && RichGraphicsUtil.isSame2D((double)f, (double)f2, (double)point2D.getX(), (double)point2D.getY())) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("moveto");
        stringBuffer.append(",");
        this.er.moveTo(f, f2);
        this.a(stringBuffer, (double)f, f2);
        this.mGraphics.draw(stringBuffer.toString());
        if (!this.es) {
            System.out.println("pathmode error!");
        }
    }

    public void pathLineTo(double d, double d2, KLocalAxis kLocalAxis) {
        StringBuffer stringBuffer = new StringBuffer("lineto");
        stringBuffer.append(",");
        float f = (float)this.a(d, d2, kLocalAxis);
        float f2 = (float)this.b(d, d2, kLocalAxis);
        if (Double.isNaN(f) || Double.isNaN(f2)) {
            throw new IllegalArgumentException();
        }
        if (Double.isInfinite(f) || Double.isInfinite(f2)) {
            throw new IllegalArgumentException();
        }
        this.er.lineTo(f, f2);
        this.a(stringBuffer, (double)f, f2);
        this.mGraphics.draw(stringBuffer.toString());
        if (!this.es) {
            System.out.println("pathmode error!");
        }
    }

    public void pathQuadTo(float f, float f2, float f3, float f4, KLocalAxis kLocalAxis) {
    }

    public void pathCurveTo(float f, float f2, float f3, float f4, float f5, float f6, KLocalAxis kLocalAxis) {
        float f7 = (float)this.a(f, (double)f2, kLocalAxis);
        float f8 = (float)this.b(f, f2, kLocalAxis);
        float f9 = (float)this.a(f3, (double)f4, kLocalAxis);
        float f10 = (float)this.b(f3, f4, kLocalAxis);
        float f11 = (float)this.a(f5, (double)f6, kLocalAxis);
        float f12 = (float)this.b(f5, f6, kLocalAxis);
        if (Double.isNaN(f7) || Double.isNaN(f8)) {
            throw new IllegalArgumentException();
        }
        if (Double.isInfinite(f7) || Double.isInfinite(f8)) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(f9) || Double.isNaN(f10)) {
            throw new IllegalArgumentException();
        }
        if (Double.isInfinite(f9) || Double.isInfinite(f10)) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(f11) || Double.isNaN(f12)) {
            throw new IllegalArgumentException();
        }
        if (Double.isInfinite(f11) || Double.isInfinite(f12)) {
            throw new IllegalArgumentException();
        }
        this.er.curveTo(f7, f8, f9, f10, f11, f12);
        StringBuffer stringBuffer = new StringBuffer("bezier1");
        stringBuffer.append(",");
        this.a(stringBuffer, (double)f7, f8);
        stringBuffer.append(",");
        this.a(stringBuffer, (double)f9, f10);
        stringBuffer.append(",");
        this.a(stringBuffer, (double)f11, f12);
        this.mGraphics.draw(stringBuffer.toString());
        if (!this.es) {
            System.out.println("pathmode error!");
        }
    }

    private double a(double d, double d2, KLocalAxis kLocalAxis) {
        if (kLocalAxis == null) {
            return d;
        }
        return kLocalAxis.getGlobalX((float)d, (float)d2);
    }

    private double b(double d, double d2, KLocalAxis kLocalAxis) {
        if (kLocalAxis == null) {
            return d2;
        }
        return kLocalAxis.getGlobalY((float)d, (float)d2);
    }

    private void a(StringBuffer stringBuffer, double d, double d2) {
        this.mGraphics.appendPosition(stringBuffer, ",", (float)d, (float)d2);
    }

    public void pathClose() {
        this.er.closePath();
        this.mGraphics.draw("close");
    }

    public void pathAdd(KCollection kCollection, KLocalAxis kLocalAxis) {
        float f;
        float f2;
        if (kCollection.size() < 2) {
            return;
        }
        K2DPathFigureLine k2DPathFigureLine = (K2DPathFigureLine)kCollection.elementAt(0);
        K2DPathFigureLine k2DPathFigureLine2 = (K2DPathFigureLine)kCollection.elementAt(1);
        if (RichGraphicsUtil.isSame2D((double)k2DPathFigureLine.getX1(), (double)k2DPathFigureLine.getY1(), (double)k2DPathFigureLine2.getX1(), (double)k2DPathFigureLine2.getY1()) || RichGraphicsUtil.isSame2D((double)k2DPathFigureLine.getX1(), (double)k2DPathFigureLine.getY1(), (double)k2DPathFigureLine2.getX2(), (double)k2DPathFigureLine2.getY2())) {
            f2 = (float)k2DPathFigureLine.getX2();
            f = (float)k2DPathFigureLine.getY2();
        } else {
            f2 = (float)k2DPathFigureLine.getX1();
            f = (float)k2DPathFigureLine.getY1();
        }
        this.pathMoveTo(f2, f, kLocalAxis);
        for (int i = 0; i < kCollection.size(); ++i) {
            k2DPathFigureLine = (K2DPathFigureLine)kCollection.elementAt(i);
            k2DPathFigureLine2 = (K2DPathFigureLine)kCollection.elementAt(i + 1);
            boolean bl = false;
            if (RichGraphicsUtil.isSame2D((double)k2DPathFigureLine.getX1(), (double)k2DPathFigureLine.getY1(), (double)k2DPathFigureLine2.getX1(), (double)k2DPathFigureLine2.getY1()) || RichGraphicsUtil.isSame2D((double)k2DPathFigureLine.getX1(), (double)k2DPathFigureLine.getY1(), (double)k2DPathFigureLine2.getX2(), (double)k2DPathFigureLine2.getY2())) {
                bl = true;
            }
            if (k2DPathFigureLine instanceof K2DPathFigureArc) {
                float f3;
                K2DPathFigureArc k2DPathFigureArc = (K2DPathFigureArc)k2DPathFigureLine;
                float f4 = (float)k2DPathFigureArc.getRadius();
                float f5 = (float)k2DPathFigureArc.getCX();
                float f6 = (float)k2DPathFigureArc.getCY();
                float f7 = (float)RichGraphicsUtil.getAngle2D((double)f5, (double)f6, (double)k2DPathFigureArc.getX1(), (double)k2DPathFigureArc.getY1());
                float f8 = (float)RichGraphicsUtil.getAngle2D((double)f5, (double)f6, (double)k2DPathFigureArc.getX2(), (double)k2DPathFigureArc.getY2());
                for (f3 = f8 - f7; f3 < 0.0f; f3 += 360.0f) {
                }
                if (k2DPathFigureArc.isCw()) {
                    f3 = -(360.0f - f3);
                }
                if (bl) {
                    f3 = -f3;
                }
                this.a(f5, f6, f4, f4, bl ? f8 : f7, f3, kLocalAxis);
                continue;
            }
            if (bl) {
                this.pathLineTo((float)k2DPathFigureLine.getX1(), (float)k2DPathFigureLine.getY1(), kLocalAxis);
                continue;
            }
            this.pathLineTo((float)k2DPathFigureLine.getX2(), (float)k2DPathFigureLine.getY2(), kLocalAxis);
        }
    }

    private void a(float f, float f2, float f3, float f4, float f5, float f6, KLocalAxis kLocalAxis) {
        double d = 4.0;
        float f7 = f3 * 2.0f;
        float f8 = f4 * 2.0f;
        double d2 = (double)f6 * Math.PI / 180.0;
        double d3 = d2 / d;
        double d4 = Math.cos(d3);
        double d5 = Math.sin(d3);
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        dArray[1] = 1.0;
        dArray[0] = 1.0;
        dArray2[0] = 0.0;
        dArray[3] = d4;
        dArray2[3] = d5;
        dArray[2] = (8.0 * Math.cos(d3 / 2.0) - (dArray[0] + 3.0 * dArray[1] + dArray[3])) / 3.0;
        dArray2[2] = dArray2[3] - (-dArray[2] + dArray[3]) / -Math.tan(d3);
        dArray2[1] = (8.0 * Math.sin(d3 / 2.0) - (dArray2[0] + 3.0 * dArray2[2] + dArray2[3])) / 3.0;
        double d6 = (double)f5 * Math.PI / 180.0;
        double d7 = Math.cos(d6);
        double d8 = Math.sin(d6);
        double[] dArray3 = new double[4];
        double[] dArray4 = new double[4];
        for (int i = 0; i < 4; ++i) {
            dArray3[i] = dArray[i] * d7 - dArray2[i] * d8;
            dArray4[i] = dArray[i] * d8 + dArray2[i] * d7;
            dArray[i] = dArray3[i];
            dArray2[i] = dArray4[i];
        }
        float f9 = f8 / f7;
        if (Float.isNaN(f9)) {
            f9 = 1.0f;
        }
        this.pathMoveTo((float)((double)f3 * dArray[0]) + f, (float)((double)f3 * dArray2[0]) * f9 + f2, kLocalAxis);
        int n = 0;
        while ((double)n < d) {
            this.pathCurveTo((float)((double)f3 * dArray[1]) + f, (float)((double)f3 * dArray2[1]) * f9 + f2, (float)((double)f3 * dArray[2]) + f, (float)((double)f3 * dArray2[2]) * f9 + f2, (float)((double)f3 * dArray[3]) + f, (float)((double)f3 * dArray2[3]) * f9 + f2, kLocalAxis);
            for (int i = 1; i < 4; ++i) {
                dArray3[i] = dArray[i] * d4 - dArray2[i] * d5;
                dArray4[i] = dArray[i] * d5 + dArray2[i] * d4;
                dArray[i] = dArray3[i];
                dArray2[i] = dArray4[i];
            }
            ++n;
        }
    }

    public void fillPath(KLineType kLineType) {
        this.setLineType(kLineType);
        StringBuffer stringBuffer = new StringBuffer("fill");
        stringBuffer.append(",");
        stringBuffer.append(Integer.toString(this.er.getWindingRule()));
        stringBuffer.append(",");
        this.mGraphics.appendColor(stringBuffer, ",");
        this.mGraphics.draw(stringBuffer.toString());
    }

    public void drawPath(KLineType kLineType) {
        this.setLineType(kLineType);
        StringBuffer stringBuffer = new StringBuffer("stroke");
        stringBuffer.append(",");
        this.mGraphics.appendColor(stringBuffer, ",");
        stringBuffer.append(",");
        this.mGraphics.appendLineWidth(stringBuffer);
        stringBuffer.append(",");
        this.mGraphics.appendLinePattern(stringBuffer, ",");
        this.mGraphics.draw(stringBuffer.toString());
    }

    public void shadePath(KLineType kLineType, float f, float f2, float f3, float f4, Color color, Color color2, boolean bl) {
        DecimalFormat decimalFormat = new DecimalFormat("000");
        DecimalFormat decimalFormat2 = new DecimalFormat("00.00");
        StringBuffer stringBuffer = new StringBuffer("TYPE2");
        stringBuffer.append("_");
        stringBuffer.append(decimalFormat.format(color.getRed()));
        stringBuffer.append(decimalFormat.format(color.getGreen()));
        stringBuffer.append(decimalFormat.format(color.getBlue()));
        stringBuffer.append(decimalFormat.format(color2.getRed()));
        stringBuffer.append(decimalFormat.format(color2.getGreen()));
        stringBuffer.append(decimalFormat.format(color2.getBlue()));
        stringBuffer.append("_");
        stringBuffer.append(decimalFormat2.format(f));
        stringBuffer.append(":");
        stringBuffer.append(decimalFormat2.format(f2));
        stringBuffer.append(":");
        stringBuffer.append(decimalFormat2.format(f3));
        stringBuffer.append(":");
        stringBuffer.append(decimalFormat2.format(f4));
        stringBuffer.append("_");
        stringBuffer.append(bl ? "1" : "0");
        StringBuffer stringBuffer2 = new StringBuffer("shadestroke");
        stringBuffer2.append(",");
        stringBuffer2.append(stringBuffer.toString());
        stringBuffer2.append(",");
        this.mGraphics.appendLineWidth(stringBuffer2);
        stringBuffer2.append(",");
        this.mGraphics.appendLinePattern(stringBuffer2, ",");
        this.mGraphics.draw(stringBuffer2.toString());
    }

    public void pathArc(float f, float f2, float f3, float f4, float f5, KLocalAxis kLocalAxis) {
        this.a(f, f2, f3, f3, f4, f5, kLocalAxis);
    }
}

