/*
 * Decompiled with CFR 0.152.
 */
package option.misc.gui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import option.gui.RoundBorder;

public abstract class AbstractBorderService {
    protected boolean mRichUI = true;

    public void setRichUI(boolean bl) {
        this.mRichUI = bl;
    }

    public boolean isRichUI() {
        return this.mRichUI;
    }

    public Border createTitledBorder(String string) {
        return this.createTitledBorder(string, this.mRichUI);
    }

    public Border createTitledBorder(String string, boolean bl) {
        Border border = null;
        if (bl) {
            border = this.createRichTitledBorder(string);
        }
        if (border == null) {
            border = this.createDefaultTitledBorder(string);
        }
        return border;
    }

    public abstract Border createRichTitledBorder(String var1);

    public Border createDefaultTitledBorder(String string) {
        return BorderFactory.createTitledBorder(string);
    }

    public Border createSpacedTitledBorder(String string) {
        return this.createSpacedTitledBorder(string, this.mRichUI);
    }

    public Border createSpacedTitledBorder(String string, boolean bl) {
        Border border = null;
        if (bl) {
            border = this.createRichSpacedTitledBorder(string);
        }
        if (border == null) {
            border = this.createDefaultSpacedTitledBorder(string);
        }
        return border;
    }

    public abstract Border createRichSpacedTitledBorder(String var1);

    public Border createDefaultSpacedTitledBorder(String string) {
        return BorderFactory.createTitledBorder(string);
    }

    public Border createCornerBorder() {
        return this.createCornerBorder(this.mRichUI);
    }

    public Border createCornerBorder(boolean bl) {
        Border border = null;
        if (bl) {
            border = this.createRichCornerBorder();
        }
        if (border == null) {
            border = this.createDefaultCornerBorder();
        }
        return border;
    }

    public abstract Border createRichCornerBorder();

    public Border createDefaultCornerBorder() {
        return BorderFactory.createEtchedBorder();
    }

    public Dimension getTitledBorderMinimumSize(Component component, Border border) {
        if (border instanceof RoundBorder) {
            RoundBorder roundBorder = (RoundBorder)border;
            return roundBorder.getMinimumSize(component);
        }
        if (border instanceof TitledBorder) {
            TitledBorder titledBorder = (TitledBorder)border;
            return titledBorder.getMinimumSize(component);
        }
        return new Dimension();
    }
}

