/*
 * Decompiled with CFR 0.152.
 */
package option.gad.toex.client.gui.estimate;

import com.kt.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import jp.kitec.richui.table.CellGroup;
import jp.kitec.richui.table.ITableKeyListener;
import jp.kitec.richui.table.Table;
import option.gad.core.util.ObjectUtil;
import option.gad.core.util.Tuple;
import option.gad.estsys.common.entity.EstimateRow;
import option.gad.toex.client.gui.estimate.IMessageComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EstimateComponent<ER extends EstimateRow>
extends JPanel {
    protected static final String[] DEF_COLUMN_HEADERS = new String[]{"\u547c\u79f0", "\u30b3\u30fc\u30c9", "\u6570\u91cf", "\u30ab\u30bf\u30ed\u30b0\u4fa1\u683c", "\u91d1\u984d"};
    protected static final String ROW_TOTAL_NAME = "\u3000 \u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u5408\u3000\u3000\u3000\u3000\u3000\u3000\u8a08\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000\u3000";
    protected static final float[] DEF_COLUMN_WIDTHS = new float[]{0.87f, 0.1f, 0.04f, 0.1f, 0.1f};
    protected static final int DEF_WIDTH = 700;
    protected static final int DEF_HEIGHT = 500;
    protected static final int DEF_INDEX_NAME = 0;
    protected static final int DEF_INDEX_PRODUCT_CODE = 1;
    protected static final int DEF_INDEX_QUANTITY = 2;
    protected static final int DEF_INDEX_UNITPRICE = 3;
    protected static final int DEF_INDEX_AMOUNT = 4;
    private static Log mLog = LogFactory.getLog(EstimateComponent.class);
    protected Table mDetail;
    protected List<ER> mEstimateRow = new ArrayList<ER>();
    protected Container mButtonContainer;
    protected JButton mBtnAddDetail;
    protected JButton mBtnDelDetail;
    protected JButton mBtnCalc;
    protected String[] mMessage;
    protected int mWidth;
    protected int mHeight;
    protected IMessageComponent mMsgComp;

    public EstimateComponent() {
        this(700, 500);
    }

    public EstimateComponent(int n, int n2) {
        this.mWidth = n;
        this.mHeight = n2;
        this.initInterface();
    }

    protected void initInterface() {
        this.setLayout(new BorderLayout(0, 0));
        this.add(this.createDetail(), "Center");
        this.add(this.createEditButtons(), "South");
    }

    protected Component createDetail() {
        this.mDetail = new Table((int[][])new int[][]{{100000}});
        this.mDetail.setBackground(Color.WHITE);
        this.mDetail.setColumnHeader(this.getColumnHeaders());
        this.mDetail.setTableEditable(true);
        this.mDetail.setColumnAlignment(1, 1);
        int n = this.mDetail.getColumnCount();
        for (int i = 2; i < n; ++i) {
            this.mDetail.setColumnAlignment(i, 2);
        }
        this.mDetail.setAutoResizeColumnWidth(false);
        int[] nArray = this.getColumnWidths();
        for (int i = 0; i < nArray.length; ++i) {
            this.mDetail.setColumnWidth(i, nArray[i]);
        }
        this.mDetail.showRowHeader();
        this.mDetail.setColumnEditable(4, false);
        this.addDetailTotal();
        this.mDetail.setSize(this.mWidth, this.mHeight);
        return this.mDetail;
    }

    protected String[] getColumnHeaders() {
        return DEF_COLUMN_HEADERS;
    }

    protected int[] getColumnWidths() {
        int[] nArray = new int[DEF_COLUMN_WIDTHS.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)(DEF_COLUMN_WIDTHS[i] * (float)this.mWidth);
        }
        return nArray;
    }

    protected void addComment(String string) {
        int n = this.getDetailCount();
        this.mDetail.insertRow(new String[]{string, "", "", "", ""}, n, 10000);
        this.mDetail.setRowEditable(n, false);
    }

    protected void addDetailTotal() {
        this.mDetail.addRow(new String[]{ROW_TOTAL_NAME, "", "", "", "0"});
        int n = this.getDetailCount();
        this.mDetail.setRowEditable(n, false);
    }

    protected Component createEditButtons() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.mBtnAddDetail = new JButton("\u660e\u7d30\u884c\u3092\u8ffd\u52a0");
        this.mBtnAddDetail.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EstimateComponent.this.addRow();
            }
        });
        this.mBtnAddDetail.setEnabled(false);
        jPanel.add((Component)this.mBtnAddDetail, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.mBtnDelDetail = new JButton("\u660e\u7d30\u884c\u3092\u524a\u9664");
        this.mBtnDelDetail.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EstimateComponent.this.removeRow();
            }
        });
        this.mBtnDelDetail.setEnabled(false);
        jPanel.add((Component)this.mBtnDelDetail, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.mBtnCalc = new JButton("\u91d1\u984d\u306e\u518d\u8a08\u7b97");
        this.mBtnCalc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!EstimateComponent.this.calculate()) {
                    EstimateComponent.this.showMessage();
                }
            }
        });
        this.mBtnCalc.setEnabled(false);
        jPanel.add((Component)this.mBtnCalc, gridBagConstraints);
        this.mButtonContainer = jPanel;
        return this.mButtonContainer;
    }

    public void setMessageComponent(IMessageComponent iMessageComponent) {
        this.mMsgComp = iMessageComponent;
    }

    public void addOperationComponent(Component component) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        gridBagConstraints.gridx = this.mButtonContainer.getComponentCount();
        this.mButtonContainer.add(component, gridBagConstraints);
    }

    public void addOperationComponent(Component[] componentArray) {
        for (Component component : componentArray) {
            this.addOperationComponent(component);
        }
    }

    public void setOperationComponentEnabled(boolean bl) {
        int n = this.mButtonContainer.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.mButtonContainer.getComponent(i).setEnabled(bl);
        }
    }

    protected void updateButtons() {
        int n = this.getDetailCount();
        if (n > 1) {
            return;
        }
        boolean bl = n == 1;
        this.mBtnAddDetail.setEnabled(true);
        this.mBtnDelDetail.setEnabled(bl);
        this.mBtnCalc.setEnabled(bl);
    }

    protected void addRow() {
        int n = this.mDetail.getSelectedRow();
        if (n >= 0) {
            this.mDetail.insertRow(this.getDefaultRowItems(), n);
            this.updateButtons();
        }
    }

    protected String[] getDefaultRowItems() {
        int n = this.mDetail.getColumnCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = "";
        }
        return stringArray;
    }

    protected void removeRow() {
        int n = this.mDetail.getSelectedRow();
        int n2 = this.getDetailCount();
        if (n >= 0 && n < n2) {
            this.mDetail.removeRow(n);
            this.updateButtons();
        }
    }

    public String[] getMessage() {
        return this.mMessage;
    }

    protected void setMessage(String[] stringArray) {
        this.mMessage = stringArray;
    }

    public boolean calculate() {
        int n = this.checkDetails();
        if (n >= 0) {
            this.mDetail.selectRow(n);
            this.setMessage(new String[]{"\u5165\u529b\u3055\u308c\u305f\u5185\u5bb9\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002", "[ \u6570\u91cf\uff1a" + this.getQuantityString(n) + ", \u30ab\u30bf\u30ed\u30b0\u4fa1\u683c\uff1a" + this.getUnitPriceString(n) + " ]"});
            return false;
        }
        int n2 = 0;
        int n3 = this.getDetailCount();
        for (int i = 0; i < n3; ++i) {
            int n4 = this.mDetail.getRowTypeAt(i);
            if (n4 >= 10000) continue;
            int n5 = this.getQuantity(i) * this.getUnitPrice(i);
            n2 += n5;
            this.setAmount(i, n5);
        }
        this.setAmount(n3, n2);
        this.mDetail.repaint();
        return true;
    }

    protected int checkDetails() {
        int n;
        try {
            int n2 = this.mDetail.getRowCount() - 1;
            for (n = 0; n < n2; ++n) {
                int n3 = this.mDetail.getRowTypeAt(n);
                if (n3 >= 10000) continue;
                if (this.getQuantity(n) <= 0) {
                    return n;
                }
                this.getUnitPrice(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
        return -1;
    }

    public void clearSelection() {
        this.mDetail.clearSelection();
    }

    public void addEstimateRow(ER ER) {
        String string = null;
        if (!this.mEstimateRow.isEmpty()) {
            EstimateRow estimateRow = (EstimateRow)this.mEstimateRow.get(this.mEstimateRow.size() - 1);
            string = estimateRow.mCategoryCode;
        }
        if (!(string != null && string.equals(((EstimateRow)ER).mCategoryCode) || StringUtil.isEmpty((String)((EstimateRow)ER).mCategoryName))) {
            this.addComment("\u2212" + ((EstimateRow)ER).mCategoryName + "\u2212");
        }
        int n = this.getDetailCount();
        int n2 = 0;
        String[] stringArray = new String[5];
        stringArray[n2++] = StringUtil.emptyToZeroString((String)((EstimateRow)ER).mName);
        stringArray[n2++] = StringUtil.emptyToZeroString((String)((EstimateRow)ER).mCode);
        stringArray[n2++] = Integer.toString(((EstimateRow)ER).mQuantity);
        stringArray[n2++] = Integer.toString(((EstimateRow)ER).mPrice);
        stringArray[n2++] = Integer.toString(((EstimateRow)ER).mQuantity * ((EstimateRow)ER).mPrice);
        this.mDetail.insertRow(stringArray, n, 0);
        this.mDetail.setRowIdentify(n, ER.hashCode());
        this.mEstimateRow.add(ER);
        this.clearSelection();
        this.updateButtons();
    }

    public void addEstimateRows(Collection<ER> collection) {
        for (EstimateRow estimateRow : collection) {
            this.addEstimateRow(estimateRow);
        }
    }

    public void removeAllDetails() {
        this.mDetail.removeAll();
        this.mEstimateRow.clear();
        this.addDetailTotal();
    }

    public void removeDetail(int n) {
        this.mDetail.removeRow(n);
    }

    public int getDetailCount() {
        return this.mDetail.getRowCount() - 1;
    }

    protected ER findEstimateRowByIdentify(int n) {
        EstimateRow estimateRow = null;
        for (EstimateRow estimateRow2 : this.mEstimateRow) {
            if (estimateRow2.hashCode() != n) continue;
            estimateRow = estimateRow2;
            break;
        }
        return (ER)estimateRow;
    }

    public ER getEstimateRow(int n) {
        CellGroup cellGroup = this.mDetail.getRow(n);
        if (cellGroup.getType() != 0) {
            return null;
        }
        ER ER = this.createEstimateRow();
        Tuple<ER, Boolean> tuple = this.findNearRow(n);
        if (tuple == null) {
            return null;
        }
        if (tuple.value1 != null) {
            ObjectUtil.shallowCopy((Object)tuple.value1, ER);
        }
        if (!((Boolean)tuple.value2).booleanValue()) {
            ((EstimateRow)ER).mId = "";
            ((EstimateRow)ER).mSubId = "";
        }
        if (StringUtil.isEmpty((String)((EstimateRow)ER).mCategoryCode)) {
            ((EstimateRow)ER).mCategoryCode = "";
            ((EstimateRow)ER).mCategoryName = "";
        }
        try {
            ((EstimateRow)ER).mCode = this.getProductCode(n);
            ((EstimateRow)ER).mName = this.getName(n);
            ((EstimateRow)ER).mPrice = this.getUnitPrice(n);
            ((EstimateRow)ER).mQuantity = this.getQuantity(n);
        }
        catch (NumberFormatException numberFormatException) {
            ER = null;
        }
        if (ER != null) {
            mLog.debug((Object)("row[" + ObjectUtil.toString(ER) + "]"));
            if (((EstimateRow)ER).mCode.equals("") && ((EstimateRow)ER).mName.equals(ROW_TOTAL_NAME) && ((EstimateRow)ER).mPrice == 0 && ((EstimateRow)ER).mQuantity == 0) {
                ER = null;
            }
        }
        return ER;
    }

    protected ER createEstimateRow() {
        return (ER)new EstimateRow();
    }

    protected Tuple<ER, Boolean> findNearRow(int n) {
        CellGroup cellGroup;
        int n2;
        CellGroup cellGroup2 = this.mDetail.getRow(n);
        if (cellGroup2.getType() != 0) {
            return null;
        }
        boolean bl = true;
        ER ER = this.findEstimateRowByIdentify(cellGroup2.getIdentify());
        if (ER == null && this.mDetail.getRowCount() > 1) {
            for (n2 = n - 1; n2 >= 0 && (cellGroup = this.mDetail.getRow(n2)) != null && cellGroup.getType() == 0; --n2) {
                ER = this.findEstimateRowByIdentify(cellGroup.getIdentify());
                if (ER == null) continue;
                bl = false;
                break;
            }
        }
        if (ER == null && this.mDetail.getRowCount() > n) {
            for (n2 = n + 1; n2 < this.mDetail.getRowCount() - 1 && (cellGroup = this.mDetail.getRow(n2)) != null && cellGroup.getType() == 0; ++n2) {
                ER = this.findEstimateRowByIdentify(cellGroup.getIdentify());
                if (ER == null) continue;
                bl = false;
                break;
            }
        }
        return new Tuple(ER, (Object)bl);
    }

    public Collection<ER> getEstimateRows() {
        ArrayList<ER> arrayList = new ArrayList<ER>();
        for (int i = 0; i < this.mDetail.getRowCount(); ++i) {
            ER ER = this.getEstimateRow(i);
            if (ER == null) continue;
            arrayList.add(ER);
        }
        return arrayList;
    }

    public int getTotalAmount() {
        if (!this.calculate()) {
            return 0;
        }
        try {
            return this.getAmount(this.getDetailCount() + 1);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    protected String getName(int n) {
        return this.mDetail.getValueAt(n, 0);
    }

    protected String getProductCode(int n) {
        return this.mDetail.getValueAt(n, 1);
    }

    protected int getQuantity(int n) throws NumberFormatException {
        String string = this.getQuantityString(n);
        if (string == null || string.equals("")) {
            return 0;
        }
        return Integer.valueOf(string);
    }

    protected String getQuantityString(int n) {
        return this.mDetail.getValueAt(n, 2);
    }

    protected int getUnitPrice(int n) {
        String string = this.getUnitPriceString(n);
        if (string == null || string.equals("")) {
            return 0;
        }
        return Integer.valueOf(string);
    }

    protected String getUnitPriceString(int n) {
        return this.mDetail.getValueAt(n, 3);
    }

    protected int getAmount(int n) {
        String string = this.getAmountString(n);
        if (string == null || string.equals("")) {
            return 0;
        }
        return Integer.valueOf(string);
    }

    protected String getAmountString(int n) {
        return this.mDetail.getValueAt(n, 4);
    }

    protected void setAmount(int n, int n2) {
        this.mDetail.setValueAt(n, 4, String.valueOf(n2));
    }

    protected void showMessage() {
        if (this.mMsgComp != null) {
            this.mMsgComp.showMessage(this.getMessage(), 2);
        } else {
            String[] stringArray = this.getMessage();
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println(stringArray[i]);
            }
        }
    }

    public void addTableKeyListener(ITableKeyListener iTableKeyListener) {
        this.mDetail.addKeyHandler(1, -1, 10, iTableKeyListener);
    }
}

