/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.dao;

import com.kt.io.AbstFile;
import com.kt.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import option.gad.core.annotation.GdBitField;
import option.gad.core.annotation.GdByteLength;
import option.gad.core.annotation.GdProperty;
import option.gad.core.annotation.GdQuote;
import option.gad.core.dao.GdDao;
import option.gad.core.db.NoUniqueRuntimeException;
import option.gad.core.entity.GdEntity;
import option.gad.core.inject.GdInject;
import option.gad.core.io.FileIOUtil;
import option.gad.core.util.ClassInfo;
import option.gad.core.util.ClassInfoManager;
import option.gad.core.util.ListNotNullDecorator;
import option.gad.core.util.NameUtil;
import option.gad.core.util.StructUtil;
import option.gad.core.util.csv.Csv;
import option.gad.core.util.csv.CsvBuilder;
import option.gad.core.util.csv.CsvUtil;
import option.gad.core.util.csv.GdCsvColumn;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.math.NumberUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCsvDao<E> {
    @GdInject
    protected CsvBuilder mCsvBuilder = null;
    protected String mResourceName = null;
    protected boolean mHeadExist = true;
    protected ClassInfo mEntityClazzInfo = null;
    protected Csv mCsv = null;
    protected Map<String, Comparator<String>> mCompMap = null;
    protected HashMap<EntityCacheKey, E> mEntityCacheMap = new HashMap();
    protected AbstFile mAbstFile = null;
    protected File mFile = null;
    protected OutputStream mOutputStream = null;

    protected AbstractCsvDao() {
        this.init();
    }

    protected void init() {
        Object object = ClassInfoManager.getInstance().getClassInfo(this.getClass());
        GdDao gdDao = ((ClassInfo)object).getType().getAnnotation(GdDao.class);
        if (gdDao == null) {
            throw new IllegalStateException("GdDao is not defined in " + ((ClassInfo)object).getType().getName() + ".");
        }
        this.mEntityClazzInfo = ClassInfoManager.getInstance().getClassInfo(gdDao.entity());
        object = this.mEntityClazzInfo.getType().getAnnotation(GdEntity.class);
        if (object == null) {
            throw new IllegalStateException("GdEntity is not defined in " + this.mEntityClazzInfo.getType().getName() + ".");
        }
        this.mResourceName = object.name();
        this.mHeadExist = object.head();
        this.mCompMap = this.createCompMap();
    }

    protected String configDefaultCharacterEncoding() {
        return "UTF-8";
    }

    protected Map<String, Comparator<String>> createCompMap() {
        HashMap<String, Comparator<String>> hashMap = new HashMap<String, Comparator<String>>();
        Object object = this.mEntityClazzInfo.getFields();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Field)object.next();
            String string = NameUtil.correctCamelCase(NameUtil.removePrefix(((Field)object2).getName()));
            GdBitField gdBitField = ((Field)object2).getAnnotation(GdBitField.class);
            if (gdBitField != null) {
                if (((Field)object2).getType() == String.class) {
                    if (gdBitField.radix() == 2) {
                        hashMap.put(string, CsvUtil.comparatorMap.get(CsvUtil.BitFieldByBinStringComparator.class));
                    } else if (gdBitField.radix() == 8) {
                        hashMap.put(string, CsvUtil.comparatorMap.get(CsvUtil.BitFieldByOctStringComparator.class));
                    } else if (gdBitField.radix() == 16) {
                        hashMap.put(string, CsvUtil.comparatorMap.get(CsvUtil.BitFieldByHexStringComparator.class));
                    } else {
                        hashMap.put(string, CsvUtil.comparatorMap.get(CsvUtil.BitFieldComparator.class));
                    }
                } else {
                    hashMap.put(string, CsvUtil.comparatorMap.get(CsvUtil.BitFieldComparator.class));
                }
            }
            if ((object2 = ((Field)object2).getAnnotation(GdCsvColumn.class)) == null) continue;
            hashMap.put(string, CsvUtil.comparatorMap.get(object2.comparator()));
        }
        return hashMap;
    }

    public E findOne(E e, boolean ... blArray) {
        return this.findOne(StructUtil.createStrings(e), blArray);
    }

    public E findOne(String[] stringArray, boolean ... blArray) {
        return this.findOne((Collection<String>)Arrays.asList(stringArray), blArray);
    }

    public E findOne(Collection<String> collection, boolean ... object) {
        if (this.mCsv == null) {
            this.loadResource();
        }
        if (this.mCsv == null) {
            throw new IllegalArgumentException("master csv isn't load.");
        }
        Csv csv = CsvUtil.select(this.mCsv, collection, this.mCompMap, object);
        object = csv;
        if (csv.mRowList.size() > 1) {
            throw new NoUniqueRuntimeException(object.mRowList.size(), "keys[" + StringUtil.concat(collection, (String)",") + "]");
        }
        if (object.mRowList.size() == 0) {
            return null;
        }
        return this.createEntity((Collection<String>)object.mRowList.iterator().next());
    }

    public Collection<E> findAll() {
        String[] stringArray = new String[this.mEntityClazzInfo.getFields().size()];
        return this.findMany(stringArray, new boolean[0]);
    }

    public Collection<E> findMany(E e, boolean ... blArray) {
        return this.findMany(StructUtil.createStrings(e), blArray);
    }

    public Collection<E> findMany(String[] stringArray, boolean ... blArray) {
        return this.findMany((Collection<String>)Arrays.asList(stringArray), blArray);
    }

    public Collection<E> findMany(Collection<String> iterator, boolean ... object) {
        if (this.mCsv == null) {
            this.loadResource();
        }
        if (this.mCsv == null) {
            throw new IllegalArgumentException("master csv isn't load.");
        }
        iterator = CsvUtil.select(this.mCsv, iterator, this.mCompMap, (boolean[])object);
        object = new ListNotNullDecorator(new ArrayList());
        for (List<String> list : ((Csv)((Object)iterator)).mRowList) {
            object.add(this.createEntity(list));
        }
        return object;
    }

    protected abstract void loadResource();

    public <E2 extends E> void regist(E2 object) {
        if (this.mAbstFile == null && this.mFile == null) {
            throw new IllegalStateException("The target isn't set.");
        }
        this.mAbstFile.openNewFileToBuffer("", this.configDefaultCharacterEncoding());
        object = this.a(StructUtil.createStrings(object));
        this.mAbstFile.writeStringToBufferln(object);
        this.mAbstFile.closeNewFileToBuffer();
        if (this.mFile != null) {
            this.a(this.mAbstFile, this.mFile);
        }
        if (this.mOutputStream != null) {
            AbstractCsvDao.a(this.mAbstFile, this.mOutputStream);
        }
    }

    public <E2 extends E> void regist(Collection<E2> object) {
        if (this.mAbstFile == null && this.mFile == null) {
            throw new IllegalStateException("The target isn't set.");
        }
        this.mAbstFile.openNewFileToBuffer("", this.configDefaultCharacterEncoding());
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = this.a(StructUtil.createStrings(object2));
            this.mAbstFile.writeStringToBufferln(object2);
        }
        this.mAbstFile.closeNewFileToBuffer();
        if (this.mFile != null) {
            this.a(this.mAbstFile, this.mFile);
        }
        if (this.mOutputStream != null) {
            AbstractCsvDao.a(this.mAbstFile, this.mOutputStream);
        }
    }

    private String a(String[] stringArray) {
        Object object = this.mEntityClazzInfo.getFields();
        ArrayList<GdQuote> arrayList = new ArrayList<GdQuote>();
        ArrayList<GdByteLength> arrayList2 = new ArrayList<GdByteLength>();
        object = object.iterator();
        while (object.hasNext()) {
            Field field = (Field)object.next();
            arrayList.add(field.getAnnotation(GdQuote.class));
            arrayList2.add(field.getAnnotation(GdByteLength.class));
        }
        object = new StringBuilder();
        int n = 0;
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            Object object2 = (GdByteLength)arrayList2.get(n);
            if (object2 != null && object2.value() >= 0) {
                string = StringUtil.getLimitString((String)string, (int)object2.value());
            }
            object2 = null;
            GdQuote gdQuote = (GdQuote)arrayList.get(n);
            if (gdQuote != null) {
                if (gdQuote.add()) {
                    object2 = Character.valueOf(gdQuote.type());
                }
            } else if (!NumberUtils.isDigits((String)string)) {
                object2 = Character.valueOf('\"');
            }
            if ((string = this.escape(string)) != null) {
                if (object2 != null) {
                    ((StringBuilder)object).append(object2);
                }
                ((StringBuilder)object).append(string);
                if (object2 != null) {
                    ((StringBuilder)object).append(object2);
                }
            }
            if (n == stringArray.length - 1) break;
            ++n;
            ((StringBuilder)object).append(',');
        }
        return ((StringBuilder)object).toString();
    }

    protected String escape(String string) {
        return string.replaceAll("\"", "\"\"");
    }

    private void a(AbstFile abstFile, File file) {
        FileOutputStream fileOutputStream = null;
        try {
            if (file.exists() && !file.canWrite()) {
                throw new RuntimeException("can't write " + file.getName() + ".");
            }
            fileOutputStream = new FileOutputStream(file);
            AbstractCsvDao.a(abstFile, fileOutputStream);
        }
        catch (Exception exception) {
            try {
                throw new RuntimeException(exception);
            }
            catch (Throwable throwable) {
                FileIOUtil.close(fileOutputStream);
                throw throwable;
            }
        }
        FileIOUtil.close(fileOutputStream);
        return;
    }

    private static void a(AbstFile abstFile, OutputStream outputStream) {
        try {
            abstFile.BufferToOutputStream(outputStream);
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected E createEntity(String[] stringArray) {
        return this.createEntity(Arrays.asList(stringArray));
    }

    protected E createEntity(Collection<String> collection) {
        EntityCacheKey entityCacheKey = new EntityCacheKey(this, collection);
        Object object = this.mEntityCacheMap.get(entityCacheKey);
        if (object == null) {
            object = StructUtil.createStruct(this.mEntityClazzInfo.getType(), collection, GdProperty.class);
            this.mEntityCacheMap.put(entityCacheKey, object);
        }
        return object;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EntityCacheKey {
        private Collection<String> a;

        public EntityCacheKey(AbstractCsvDao abstractCsvDao, Collection<String> collection) {
            this.a = collection;
        }

        public boolean equals(Object iterator) {
            if (iterator == null) {
                return false;
            }
            if (this == iterator) {
                return true;
            }
            if (!(iterator instanceof EntityCacheKey)) {
                return false;
            }
            iterator = (EntityCacheKey)((Object)iterator);
            EqualsBuilder equalsBuilder = new EqualsBuilder();
            Iterator<String> iterator2 = this.a.iterator();
            iterator = ((EntityCacheKey)((Object)iterator)).a.iterator();
            for (int i = 0; i < this.a.size(); ++i) {
                equalsBuilder.append((Object)iterator2.next(), (Object)iterator.next());
            }
            return equalsBuilder.isEquals();
        }

        public int hashCode() {
            HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
            for (String string : this.a) {
                hashCodeBuilder.append((Object)string);
            }
            return hashCodeBuilder.toHashCode();
        }
    }
}

