/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.format.auto3ds.element;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.kitec.format.auto3ds.Chunk;
import jp.kitec.format.auto3ds.Reader;
import jp.kitec.format.auto3ds.Writer;

public class TriMaterial
extends Chunk {
    byte[] mMaterial;
    private List<Integer> mFaces = new ArrayList<Integer>();

    public TriMaterial() {
        super((short)16688);
    }

    public void setMaterial(String string) {
        this.mMaterial = string.getBytes();
    }

    public String getMaterial() {
        return new String(this.mMaterial);
    }

    public List<Integer> getFaces() {
        return Collections.unmodifiableList(this.mFaces);
    }

    public void addFace(int n) {
        this.mFaces.add(n);
    }

    @Override
    protected int selfSize() {
        return this.mMaterial.length + 1 + SIZE_SHORT + SIZE_SHORT * this.mFaces.size();
    }

    @Override
    protected void writeBody(Writer writer) {
        writer.writeAsciiz(this.mMaterial);
        writer.writeShort(this.mFaces.size());
        for (Integer n : this.mFaces) {
            writer.writeShort(n);
        }
    }

    @Override
    protected void readChildren(Reader reader, int n) {
        int n2 = reader.getPosition();
        this.mMaterial = reader.readAsciiz();
        int n3 = reader.readUShort();
        this.mFaces.clear();
        for (int i = 0; i < n3; ++i) {
            int n4 = reader.readUShort();
            this.mFaces.add(n4);
        }
    }

    @Override
    public void dump(PrintStream printStream, int n) {
        super.dump(printStream, n);
        StringBuilder stringBuilder = new StringBuilder(n);
        if (n > 0) {
            for (int i = 0; i < n - 1; ++i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append("+-");
        }
        printStream.print(stringBuilder);
        printStream.println(this.mMaterial);
        printStream.print(stringBuilder);
        printStream.println(this.mFaces.size());
        printStream.print(stringBuilder);
        for (int n2 : this.mFaces) {
            printStream.print(n2 + " ");
        }
        printStream.println();
    }
}

