/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.format.auto3ds;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jp.kitec.format.auto3ds.Chunk;

public class Writer {
    private ByteBuffer buf;

    public void write(DataOutputStream dataOutputStream, Chunk chunk) throws IOException {
        this.buf = ByteBuffer.allocate(chunk.size());
        this.buf.order(ByteOrder.LITTLE_ENDIAN);
        chunk.write(this);
        dataOutputStream.write(this.buf.array(), 0, this.buf.position());
        dataOutputStream.flush();
    }

    public void writeByte(int n) {
        this.buf.put((byte)n);
    }

    public void writeShort(int n) {
        this.buf.putShort((short)n);
    }

    public void writeInt(int n) {
        this.buf.putInt(n);
    }

    public void writeFloat(float f) {
        this.buf.putFloat(f);
    }

    public void writeAsciiz(byte[] byArray) {
        this.buf.put(byArray);
        this.buf.put((byte)0);
    }

    public int getPosition() {
        return this.buf.position();
    }
}

