/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.format.auto3ds;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jp.kitec.format.auto3ds.Chunk;
import jp.kitec.format.auto3ds.element.Back;
import jp.kitec.format.auto3ds.element.Bogus;
import jp.kitec.format.auto3ds.element.Bottom;
import jp.kitec.format.auto3ds.element.CamUnknwn01;
import jp.kitec.format.auto3ds.element.CamUnknwn02;
import jp.kitec.format.auto3ds.element.Camera;
import jp.kitec.format.auto3ds.element.ChunkFloat;
import jp.kitec.format.auto3ds.element.ChunkShort;
import jp.kitec.format.auto3ds.element.ChunkString;
import jp.kitec.format.auto3ds.element.ColAmount;
import jp.kitec.format.auto3ds.element.ColRgb;
import jp.kitec.format.auto3ds.element.ColTru;
import jp.kitec.format.auto3ds.element.ColUnk;
import jp.kitec.format.auto3ds.element.Disabled;
import jp.kitec.format.auto3ds.element.Edit3DS;
import jp.kitec.format.auto3ds.element.EditAmbient;
import jp.kitec.format.auto3ds.element.EditBackgr;
import jp.kitec.format.auto3ds.element.EditConfig1;
import jp.kitec.format.auto3ds.element.EditConfig2;
import jp.kitec.format.auto3ds.element.EditMaterial;
import jp.kitec.format.auto3ds.element.EditObject;
import jp.kitec.format.auto3ds.element.EditUnknw01;
import jp.kitec.format.auto3ds.element.EditUnknw02;
import jp.kitec.format.auto3ds.element.EditUnknw03;
import jp.kitec.format.auto3ds.element.EditUnknw04;
import jp.kitec.format.auto3ds.element.EditUnknw05;
import jp.kitec.format.auto3ds.element.EditUnknw06;
import jp.kitec.format.auto3ds.element.EditUnknw07;
import jp.kitec.format.auto3ds.element.EditUnknw08;
import jp.kitec.format.auto3ds.element.EditUnknw09;
import jp.kitec.format.auto3ds.element.EditUnknw10;
import jp.kitec.format.auto3ds.element.EditUnknw11;
import jp.kitec.format.auto3ds.element.EditUnknw12;
import jp.kitec.format.auto3ds.element.EditUnknw13;
import jp.kitec.format.auto3ds.element.EditView1;
import jp.kitec.format.auto3ds.element.EditViewP1;
import jp.kitec.format.auto3ds.element.EditViewP2;
import jp.kitec.format.auto3ds.element.EditViewP3;
import jp.kitec.format.auto3ds.element.Front;
import jp.kitec.format.auto3ds.element.Keyf3DS;
import jp.kitec.format.auto3ds.element.KeyfFrames;
import jp.kitec.format.auto3ds.element.KeyfObjdes;
import jp.kitec.format.auto3ds.element.KeyfUnknwn01;
import jp.kitec.format.auto3ds.element.KeyfUnknwn02;
import jp.kitec.format.auto3ds.element.Left;
import jp.kitec.format.auto3ds.element.Light;
import jp.kitec.format.auto3ds.element.LitOff;
import jp.kitec.format.auto3ds.element.LitSpot;
import jp.kitec.format.auto3ds.element.LitUnknwn01;
import jp.kitec.format.auto3ds.element.Main3DS;
import jp.kitec.format.auto3ds.element.MatAmbient;
import jp.kitec.format.auto3ds.element.MatDiffuse;
import jp.kitec.format.auto3ds.element.MatName01;
import jp.kitec.format.auto3ds.element.MatShininess;
import jp.kitec.format.auto3ds.element.MatSpecular;
import jp.kitec.format.auto3ds.element.MatTexture;
import jp.kitec.format.auto3ds.element.MatTransparency;
import jp.kitec.format.auto3ds.element.ObjCamera;
import jp.kitec.format.auto3ds.element.ObjLight;
import jp.kitec.format.auto3ds.element.ObjTrimesh;
import jp.kitec.format.auto3ds.element.ObjUnknwn01;
import jp.kitec.format.auto3ds.element.ObjUnknwn02;
import jp.kitec.format.auto3ds.element.Right;
import jp.kitec.format.auto3ds.element.Top;
import jp.kitec.format.auto3ds.element.TriFacel1;
import jp.kitec.format.auto3ds.element.TriFacel2;
import jp.kitec.format.auto3ds.element.TriLocal;
import jp.kitec.format.auto3ds.element.TriMappingCoords;
import jp.kitec.format.auto3ds.element.TriMaterial;
import jp.kitec.format.auto3ds.element.TriSmooth;
import jp.kitec.format.auto3ds.element.TriVertexl;
import jp.kitec.format.auto3ds.element.TriVisible;
import jp.kitec.format.auto3ds.element.User;

public class Reader {
    ByteBuffer is;
    int pos;
    int markPos;

    public Reader(DataInputStream dataInputStream) throws IOException {
        int n;
        this.is = ByteBuffer.allocate(dataInputStream.available());
        this.is.order(ByteOrder.LITTLE_ENDIAN);
        byte[] byArray = new byte[256];
        while ((n = dataInputStream.read(byArray)) > 0) {
            this.is.put(byArray, 0, n);
        }
        this.is.flip();
        this.pos = 0;
        this.markPos = 0;
    }

    public Reader(ByteBuffer byteBuffer) throws IOException {
        this.is = byteBuffer;
        this.is.order(ByteOrder.LITTLE_ENDIAN);
        this.pos = 0;
        this.markPos = 0;
    }

    public Chunk read() throws IOException {
        Chunk chunk = this.createChunk();
        if (chunk == null) {
            return null;
        }
        chunk.read(this);
        return chunk;
    }

    public void mark(int n) {
        this.is.mark();
        this.markPos = this.pos;
    }

    public void reset() {
        this.is.reset();
        this.pos = this.markPos;
    }

    public int getPosition() {
        return this.is.position();
    }

    public short readShort() {
        this.pos += 2;
        return this.is.getShort();
    }

    public int readUShort() {
        this.pos += 2;
        return 0xFFFF & this.is.getShort();
    }

    public int readInt() {
        this.pos += 4;
        return this.is.getInt();
    }

    public float readFloat() {
        this.pos += 4;
        return this.is.getFloat();
    }

    public byte readByte() {
        ++this.pos;
        return this.is.get();
    }

    public short peekID() {
        this.mark(2);
        short s = this.readShort();
        this.reset();
        return s;
    }

    public byte[] readAsciiz() {
        byte by;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((by = this.readByte()) != 0) {
            byteArrayOutputStream.write(by);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public int skip(int n) {
        this.pos += n;
        this.is.position(this.is.position() + n);
        return this.is.position();
    }

    public Chunk createChunkUnknown() {
        short s = this.readShort();
        return new Chunk(s);
    }

    public ChunkShort createChunkShort() {
        this.mark(2);
        short s = this.readShort();
        return new ChunkShort(s);
    }

    public ChunkFloat createChunkFloat() {
        this.mark(2);
        short s = this.readShort();
        return new ChunkFloat(s);
    }

    public ChunkString createChunkString() {
        this.mark(2);
        short s = this.readShort();
        return new ChunkString(s);
    }

    public Chunk createChunk() {
        this.mark(2);
        short s = this.readShort();
        switch (s) {
            case 19789: {
                return new Main3DS();
            }
        }
        this.reset();
        return this.createChunkUnknown();
    }

    public Chunk createChunkMain() {
        this.mark(2);
        short s = this.readShort();
        switch (s) {
            case 15677: {
                return new Edit3DS();
            }
            case -20480: {
                return new Keyf3DS();
            }
        }
        this.reset();
        return this.createChunkUnknown();
    }

    public Chunk createChunkEdit() {
        this.mark(2);
        short s = this.readShort();
        switch (s) {
            case -20481: {
                return new EditMaterial();
            }
            case 256: {
                return new EditConfig1();
            }
            case 15933: {
                return new EditConfig2();
            }
            case 28690: {
                return new EditViewP1();
            }
            case 28689: {
                return new EditViewP2();
            }
            case 28704: {
                return new EditViewP3();
            }
            case 28673: {
                return new EditView1();
            }
            case 4608: {
                return new EditBackgr();
            }
            case 8448: {
                return new EditAmbient();
            }
            case 16384: {
                return new EditObject();
            }
            case 4352: {
                return new EditUnknw01();
            }
            case 4609: {
                return new EditUnknw02();
            }
            case 4864: {
                return new EditUnknw03();
            }
            case 5120: {
                return new EditUnknw04();
            }
            case 5152: {
                return new EditUnknw05();
            }
            case 5200: {
                return new EditUnknw06();
            }
            case 5376: {
                return new EditUnknw07();
            }
            case 8704: {
                return new EditUnknw08();
            }
            case 8705: {
                return new EditUnknw09();
            }
            case 8720: {
                return new EditUnknw10();
            }
            case 8960: {
                return new EditUnknw11();
            }
            case 8962: {
                return new EditUnknw12();
            }
            case 12288: {
                return new EditUnknw13();
            }
        }
        this.reset();
        return this.createChunkUnknown();
    }

    public Chunk createChunkMaterial() {
        this.mark(2);
        short s = this.readShort();
        switch (s) {
            case -24576: {
                return new MatName01();
            }
            case -24560: {
                return new MatAmbient();
            }
            case -24544: {
                return new MatDiffuse();
            }
            case -24528: {
                return new MatSpecular();
            }
            case -24512: {
                return new MatShininess();
            }
            case -24496: {
                return new MatTransparency();
            }
            case -24064: {
                return new MatTexture();
            }
        }
        this.reset();
        return this.createChunkUnknown();
    }

    public Chunk createChunkObj() {
        this.mark(2);
        short s = this.readShort();
        switch (s) {
            case 16640: {
                return new ObjTrimesh();
            }
            case 17920: {
                return new ObjLight();
            }
            case 18176: {
                return new ObjCamera();
            }
            case 16400: {
                return new ObjUnknwn01();
            }
            case 16402: {
                return new ObjUnknwn02();
            }
        }
        this.reset();
        return this.createChunkUnknown();
    }

    public Chunk createChunkCamera() {
        this.mark(2);
        short s = this.readShort();
        switch (s) {
            case 18192: {
                return new CamUnknwn01();
            }
            case 18208: {
                return new CamUnknwn02();
            }
        }
        this.reset();
        return this.createChunkUnknown();
    }

    public Chunk createChunkLight() {
        this.mark(2);
        short s = this.readShort();
        switch (s) {
            case 17952: {
                return new LitOff();
            }
            case 17936: {
                return new LitSpot();
            }
            case 18010: {
                return new LitUnknwn01();
            }
        }
        this.reset();
        return this.createChunkUnknown();
    }

    public Chunk createChunkTri() {
        this.mark(2);
        short s = this.readShort();
        switch (s) {
            case 16656: {
                return new TriVertexl();
            }
            case 16704: {
                return new TriMappingCoords();
            }
            case 16657: {
                return new TriFacel2();
            }
            case 16672: {
                return new TriFacel1();
            }
            case 16720: {
                return new TriSmooth();
            }
            case 16736: {
                return new TriLocal();
            }
            case 16741: {
                return new TriVisible();
            }
            case 16688: {
                return new TriMaterial();
            }
        }
        this.reset();
        return this.createChunkUnknown();
    }

    public Chunk createChunkKeyf() {
        this.mark(2);
        short s = this.readShort();
        switch (s) {
            case -20471: {
                return new KeyfUnknwn01();
            }
            case -20470: {
                return new KeyfUnknwn02();
            }
            case -20472: {
                return new KeyfFrames();
            }
            case -20478: {
                return new KeyfObjdes();
            }
        }
        this.reset();
        return this.createChunkUnknown();
    }

    public Chunk createChunkCol() {
        this.mark(2);
        short s = this.readShort();
        switch (s) {
            case 16: {
                return new ColRgb();
            }
            case 17: {
                return new ColTru();
            }
            case 19: {
                return new ColUnk();
            }
            case 48: {
                return new ColAmount();
            }
        }
        this.reset();
        return this.createChunkUnknown();
    }

    public Chunk createChunkView() {
        this.mark(2);
        short s = this.readShort();
        switch (s) {
            case 1: {
                return new Top();
            }
            case 2: {
                return new Bottom();
            }
            case 3: {
                return new Left();
            }
            case 4: {
                return new Right();
            }
            case 5: {
                return new Front();
            }
            case 6: {
                return new Back();
            }
            case 7: {
                return new User();
            }
            case 8: {
                return new Camera();
            }
            case 9: {
                return new Light();
            }
            case 16: {
                return new Disabled();
            }
            case 17: {
                return new Bogus();
            }
        }
        this.reset();
        return this.createChunkUnknown();
    }
}

