/*
 * Decompiled with CFR 0.152.
 */
package nethome.ui.command;

import java.awt.Color;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KRichGraphics;
import nethome.geom.util.ToolMath;
import nethome.ui.Canvas2D;
import nethome.ui.CanvasBase;
import nethome.ui.MainComponent;
import nethome.ui.command.Command;
import nethome.ui.command.CommandUtil;

public class ComViewZoomArea
extends Command
implements ActionListener {
    private int x;
    private int y;
    private int z;
    private int A;
    private float x1;
    private float y1;
    private float x2;
    private float y2;
    private boolean B = false;

    public void play() {
        CommandUtil.setActiveUI(this.mComponent, true);
        Panel panel = MainComponent.getInstance();
        panel = ((MainComponent)panel).getActiveCanvas();
        if (panel == null) {
            return;
        }
        ((Canvas2D)panel).setCursor(Canvas2D.MOUSE_CROSS);
    }

    public void end() {
        CommandUtil.setActiveUI(this.mComponent, false);
        this.y2 = 0.0f;
        this.x2 = 0.0f;
        this.y1 = 0.0f;
        this.x1 = 0.0f;
        Panel panel = MainComponent.getInstance();
        panel = ((MainComponent)panel).getActiveCanvas();
        if (panel == null) {
            return;
        }
        ((Canvas2D)panel).setCursor(Canvas2D.MOUSE_DEF);
    }

    public void mouseMove(int n, int n2, int n3) {
    }

    public void mousePress(int n, int n2, int n3) {
        Panel panel = MainComponent.getInstance();
        if ((panel = panel.getActiveCanvas()) == null) {
            return;
        }
        this.B = true;
        this.x = this.z = n;
        this.y = this.A = n2;
        this.x1 = this.x2 = ((Canvas2D)panel).mAbstCanvas.devToRealX(this.x);
        this.y1 = this.y2 = ((Canvas2D)panel).mAbstCanvas.devToRealY(this.y);
    }

    public void mouseDrag(int n, int n2, int n3) {
        Panel panel = MainComponent.getInstance();
        if ((panel = ((MainComponent)panel).getActiveCanvas()) == null) {
            return;
        }
        this.z = n;
        this.A = n2;
        this.x2 = ((Canvas2D)panel).mAbstCanvas.devToRealX(this.z);
        this.y2 = ((Canvas2D)panel).mAbstCanvas.devToRealY(this.A);
        panel.repaint();
    }

    public void mouseRelease(int n, int n2, int n3) {
        ComViewZoomArea comViewZoomArea = this;
        MainComponent mainComponent = MainComponent.getInstance();
        Canvas2D canvas2D = mainComponent.getActiveCanvas();
        if (canvas2D != null) {
            if (Math.abs(comViewZoomArea.z - comViewZoomArea.x) > 10 && Math.abs(comViewZoomArea.A - comViewZoomArea.y) > 10) {
                canvas2D.mAbstCanvas.setView(comViewZoomArea.x1, comViewZoomArea.y1, comViewZoomArea.x2, comViewZoomArea.y2);
                canvas2D.forceImageUpdate();
                canvas2D.repaint();
                canvas2D.updateViewControl();
                mainComponent.updateUserInterface();
            }
            if (!comViewZoomArea.mContinue) {
                canvas2D.setMouseCommand(null);
            }
            canvas2D.repaint();
        }
        this.B = false;
    }

    public void actionPerformed(ActionEvent object) {
        object = MainComponent.getInstance();
        if ((object = ((MainComponent)object).getActiveCanvas()) == null) {
            return;
        }
        ((CanvasBase)object).setMouseCommand(this);
        object = this;
        ((ComViewZoomArea)object).play();
        Panel panel = MainComponent.getInstance();
        panel = ((MainComponent)panel).getActiveCanvas();
        if (panel != null) {
            ((ComViewZoomArea)object).B = false;
            panel.repaint();
        }
    }

    public void drawCommand(IRichGraphics iRichGraphics) {
        if (this.B) {
            iRichGraphics.setColor(Color.red);
            if (!ToolMath.isSame2D((double)this.x1, (double)this.y1, (double)this.x2, (double)this.y2)) {
                iRichGraphics.drawRect(this.x1, this.y1, this.x2, this.y2, KRichGraphics.LINE_1);
            }
        }
    }
}

