/*
 * Decompiled with CFR 0.152.
 */
package nethome.geom.util;

import com.kt.util.Item;
import com.kt.util.RefList;
import com.kt.util.Vector2;
import java.io.Serializable;
import jp.kitec.kwt.Area;
import nethome.geom.HatchPattern;
import nethome.geom.LocalAxis2Df;
import nethome.geom.primitive.GLine;
import nethome.geom.primitive.GPoint2Df;
import nethome.geom.primitive.Geometory;
import nethome.geom.util.ToolMath;
import nethome.geom.util.ToolPolygon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolHatch {
    private static float[] tmpf = new float[2];

    public static Vector2<GLine> createHatch(HatchPattern hatchPattern, RefList<? extends GPoint2Df> refList, float f, double d, float f2, boolean bl, boolean bl2) {
        Vector2 vector2 = new Vector2();
        ToolHatch.createHatch(hatchPattern, refList, (Vector2<GLine>)vector2, f, d, f2, bl, bl2);
        return vector2;
    }

    public static void createHatch(HatchPattern hatchPattern, RefList<? extends GPoint2Df> refList, Vector2<GLine> vector2, float f, double d, float f2, boolean bl, boolean bl2) {
        Serializable serializable;
        GPoint2Df gPoint2Df;
        int n;
        RefList refList2;
        if (hatchPattern == null) {
            return;
        }
        if (hatchPattern.mOffsetToInside != 0.0f) {
            refList2 = new RefList();
            for (n = 0; n < refList.size(); ++n) {
                gPoint2Df = (GPoint2Df)refList.elementAt(n);
                GPoint2Df gPoint2Df2 = (GPoint2Df)refList.elementAt(n + 1);
                serializable = (GPoint2Df)refList.elementAt(n + 2);
                ToolMath.get2LineOffsetCross(gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y, ((GPoint2Df)serializable).x, ((GPoint2Df)serializable).y, hatchPattern.mOffsetToInside, hatchPattern.mOffsetToInside, tmpf);
                refList2.addElement((Object)new GPoint2Df(tmpf[0], tmpf[1]));
            }
            refList = refList2;
        } else {
            refList2 = new RefList();
            for (n = 0; n < refList.size(); ++n) {
                gPoint2Df = (GPoint2Df)refList.elementAt(n);
                refList2.addElement((Object)new GPoint2Df(gPoint2Df.x, gPoint2Df.y));
            }
            refList = refList2;
        }
        float f3 = ToolPolygon.getMinX((RefList<? extends GPoint2Df>)refList);
        float f4 = ToolPolygon.getMaxX((RefList<? extends GPoint2Df>)refList);
        float f5 = ToolPolygon.getMinY((RefList<? extends GPoint2Df>)refList);
        float f6 = ToolPolygon.getMaxY((RefList<? extends GPoint2Df>)refList);
        if (f2 != 0.0f) {
            serializable = new LocalAxis2Df();
            ((LocalAxis2Df)serializable).mRot = f2;
            float f7 = Float.POSITIVE_INFINITY;
            float f8 = Float.POSITIVE_INFINITY;
            float f9 = Float.NEGATIVE_INFINITY;
            float f10 = Float.NEGATIVE_INFINITY;
            for (int i = 0; i < refList.size(); ++i) {
                GPoint2Df gPoint2Df3 = (GPoint2Df)refList.elementAt(i);
                float f11 = ((LocalAxis2Df)serializable).getLocalX(gPoint2Df3.x, gPoint2Df3.y);
                float f12 = ((LocalAxis2Df)serializable).getLocalX(gPoint2Df3.x, gPoint2Df3.y);
                if (f11 < f7) {
                    f3 = gPoint2Df3.x;
                    f7 = f11;
                }
                if (f12 < f8) {
                    f5 = gPoint2Df3.y;
                    f8 = f12;
                }
                if (f11 > f9) {
                    f4 = gPoint2Df3.x;
                    f9 = f11;
                }
                if (!(f12 > f10)) continue;
                f6 = gPoint2Df3.y;
                f10 = f12;
            }
        }
        switch (hatchPattern.mFitPattern) {
            case 0: {
                ToolHatch.createHatchingMinmaxFit(f3, f4, f5, f6, hatchPattern, (RefList<? extends GPoint2Df>)refList, vector2);
                break;
            }
            case 1: {
                ToolHatch.createHatchingInterval(f3, f4, f5, f6, hatchPattern, (RefList<? extends GPoint2Df>)refList, vector2, f, d, f2, bl, bl2);
                break;
            }
            case 3: {
                ToolHatch.createHatchingFromSubtype(f3, f4, f5, f6, hatchPattern, (RefList<? extends GPoint2Df>)refList, vector2, f, d, f2, bl, bl2);
            }
        }
        if (hatchPattern.mFrameLine) {
            for (int i = 0; i < refList.size(); ++i) {
                vector2.addElement((Object)new GLine((GPoint2Df)refList.elementAt(i), (GPoint2Df)refList.elementAt(i + 1), hatchPattern.mLtype));
            }
        }
    }

    private static void createHatchingInterval(float f, float f2, float f3, float f4, HatchPattern hatchPattern, RefList<? extends GPoint2Df> refList, Vector2<GLine> vector2, float f5, double d, float f6, boolean bl, boolean bl2) {
        RefList<GPoint2Df> refList2;
        float f7;
        float f8;
        float f9;
        float f10;
        float f11;
        float f12;
        int n;
        LocalAxis2Df localAxis2Df = new LocalAxis2Df();
        localAxis2Df.mX = f;
        localAxis2Df.mY = f3;
        localAxis2Df.mRot = (float)d;
        Area area = new Area();
        area.maximize();
        area.updateMinMax(localAxis2Df.getLocalX(f, f3), localAxis2Df.getLocalY(f, f3));
        area.updateMinMax(localAxis2Df.getLocalX(f2, f3), localAxis2Df.getLocalY(f2, f3));
        area.updateMinMax(localAxis2Df.getLocalX(f2, f4), localAxis2Df.getLocalY(f2, f4));
        area.updateMinMax(localAxis2Df.getLocalX(f, f4), localAxis2Df.getLocalY(f, f4));
        for (n = 0; n < hatchPattern.mInfinityX.size(); ++n) {
            f12 = ((Float)hatchPattern.mInfinityX.elementAt(n)).floatValue();
            for (f11 = area.minY; f11 < area.maxY; f11 += f12 * f5) {
                f10 = Math.round(localAxis2Df.getGlobalX(area.minX, f11) * 100.0f) / 100;
                f9 = Math.round(localAxis2Df.getGlobalY(area.minX, f11) * 100.0f) / 100;
                f8 = Math.round(localAxis2Df.getGlobalX(area.maxX, f11) * 100.0f) / 100;
                f7 = Math.round(localAxis2Df.getGlobalY(area.maxX, f11) * 100.0f) / 100;
                refList2 = ToolPolygon.getHatchingLine(refList, f10, f9, f8, f7);
                refList2 = ToolHatch.sort(f10, f9, refList2);
                ToolHatch.addDrawLines(refList2, refList, vector2, hatchPattern);
            }
        }
        for (n = 0; n < hatchPattern.mInfinityY.size(); ++n) {
            f12 = ((Float)hatchPattern.mInfinityY.elementAt(n)).floatValue();
            for (f11 = area.minX; f11 < area.maxX; f11 += f12 * f5) {
                f10 = Math.round(localAxis2Df.getGlobalX(f11, area.minY) * 100.0f) / 100;
                f9 = Math.round(localAxis2Df.getGlobalY(f11, area.minY) * 100.0f) / 100;
                f8 = Math.round(localAxis2Df.getGlobalX(f11, area.maxY) * 100.0f) / 100;
                f7 = Math.round(localAxis2Df.getGlobalY(f11, area.maxY) * 100.0f) / 100;
                refList2 = ToolPolygon.getHatchingLine(refList, f10, f9, f8, f7);
                refList2 = ToolHatch.sort(f10, f9, refList2);
                ToolHatch.addDrawLines(refList2, refList, vector2, hatchPattern);
            }
        }
        for (n = 0; n < refList.size(); ++n) {
            GPoint2Df gPoint2Df = (GPoint2Df)refList.elementAt(n);
            GPoint2Df gPoint2Df2 = (GPoint2Df)refList.elementAt(n + 1);
            vector2.addElement((Object)new GLine(gPoint2Df, gPoint2Df2));
        }
    }

    private static void createHatchingFromSubtype(float f, float f2, float f3, float f4, HatchPattern hatchPattern, RefList<? extends GPoint2Df> refList, Vector2<GLine> vector2, float f5, double d, float f6, boolean bl, boolean bl2) {
        Geometory geometory;
        int n;
        float f7;
        float f8;
        float f9 = f2 - f;
        float f10 = f4 - f3;
        int n2 = Math.abs((int)((f9 - f9 % f5) / f5));
        int n3 = Math.abs((int)((f10 - f10 % f5) / f5));
        if (Math.abs(f5 - f9 % f5) < f5 / 1000.0f) {
            ++n2;
        }
        if (Math.abs(f5 - f10 % f5) < f5 / 1000.0f) {
            ++n3;
        }
        float[] fArray = null;
        boolean bl3 = false;
        if (n2 < n3) {
            bl3 = true;
            fArray = hatchPattern.getSubtype2(n3, n2);
        } else {
            fArray = hatchPattern.getSubtype2(n2, n3);
        }
        if (fArray == null) {
            return;
        }
        if (bl3) {
            f8 = fArray[1];
            f7 = fArray[0];
        } else {
            f8 = fArray[0];
            f7 = fArray[1];
        }
        boolean bl4 = false;
        ToolMath.rotation2D(0.0, 0.0, d, f8, f7, tmpf);
        float f11 = Math.abs(tmpf[0]);
        float f12 = Math.abs(tmpf[1]);
        if (bl3) {
            float f13 = f11;
            f11 = f12;
            f12 = f13;
        }
        if (Math.abs(f11 - (float)n2) > 0.1f || Math.abs(f12 - (float)n3) > 0.1f) {
            bl4 = true;
            d = 0.0;
        }
        for (n = 0; n < hatchPattern.mLines.size(); ++n) {
            float f14;
            geometory = (GLine)hatchPattern.mLines.elementAt(n);
            float f15 = geometory.pA.x - fArray[2];
            float f16 = geometory.pA.y - fArray[3];
            float f17 = geometory.pB.x - fArray[2];
            float f18 = geometory.pB.y - fArray[3];
            if (bl4 && bl3) {
                f11 = f15;
                f12 = f16;
                f15 = -f12;
                f16 = f11;
                f11 = f17;
                f12 = f18;
                f17 = -f12;
                f18 = f11;
            }
            ToolMath.rotation2D(0.0, 0.0, d, f15 * f5, f16 * f5, tmpf);
            f15 = tmpf[0] + f + f8 / 2.0f * f5;
            f16 = tmpf[1] + f3 + f7 / 2.0f * f5;
            ToolMath.rotation2D(0.0, 0.0, d, f17 * f5, f18 * f5, tmpf);
            f17 = tmpf[0] + f + f8 / 2.0f * f5;
            f18 = tmpf[1] + f3 + f7 / 2.0f * f5;
            f15 = Math.round(f15 * 100.0f) / 100;
            f16 = Math.round(f16 * 100.0f) / 100;
            f17 = Math.round(f17 * 100.0f) / 100;
            f18 = Math.round(f18 * 100.0f) / 100;
            if (bl) {
                f14 = f + f8 / 2.0f * f5;
                f15 = f14 + (f14 - f15);
                f17 = f14 + (f14 - f17);
            }
            if (bl2) {
                f14 = f3 + f5 * f7 / 2.0f;
                f16 = f14 + (f14 - f16);
                f18 = f14 + (f14 - f18);
            }
            RefList<GPoint2Df> refList2 = ToolPolygon.getHatchingLine(refList, f15, f16, f17, f18);
            refList2 = ToolHatch.sort(geometory.pA.x, geometory.pA.y, refList2);
            ToolHatch.addDrawLines(refList2, refList, vector2, hatchPattern);
        }
        for (n = 0; n < refList.size(); ++n) {
            geometory = (GPoint2Df)refList.elementAt(n);
            GPoint2Df gPoint2Df = (GPoint2Df)refList.elementAt(n + 1);
            vector2.addElement((Object)new GLine((GPoint2Df)geometory, gPoint2Df));
        }
    }

    private static void createHatchingMinmaxFit(float f, float f2, float f3, float f4, HatchPattern hatchPattern, RefList<? extends GPoint2Df> refList, Vector2<GLine> vector2) {
        if (hatchPattern == null) {
            return;
        }
        float f5 = Math.abs(f2 - f) / Math.abs(hatchPattern.mMaxX - hatchPattern.mMinX);
        float f6 = Math.abs(f4 - f3) / Math.abs(hatchPattern.mMaxY - hatchPattern.mMinY);
        for (int i = 0; i < hatchPattern.mLines.size(); ++i) {
            GLine gLine = (GLine)hatchPattern.mLines.elementAt(i);
            RefList<GPoint2Df> refList2 = ToolPolygon.getHatchingLine(refList, gLine.pA.x * f5 + f, gLine.pA.y * f6 + f3, gLine.pB.x * f5 + f, gLine.pB.y * f6 + f3);
            refList2 = ToolHatch.sort(gLine.pA.x * f5 + f, gLine.pA.y * f6 + f3, refList2);
            ToolHatch.addDrawLines(refList2, refList, vector2, hatchPattern);
        }
    }

    private static void addDrawLines(RefList<? extends GPoint2Df> refList, RefList<? extends GPoint2Df> refList2, Vector2<GLine> vector2, HatchPattern hatchPattern) {
        if (refList == null) {
            return;
        }
        Item item = refList.itemAt(0);
        for (int i = 0; i < refList.size() - 1; ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)item.getObject();
            GPoint2Df gPoint2Df2 = (GPoint2Df)item.nextItem.getObject();
            if (ToolPolygon.isInnerPolygon(refList2, (gPoint2Df.x + gPoint2Df2.x) / 2.0f, (gPoint2Df.y + gPoint2Df2.y) / 2.0f) && !ToolPolygon.isOnEdge(refList2, (gPoint2Df.x + gPoint2Df2.x) / 2.0f, (gPoint2Df.y + gPoint2Df2.y) / 2.0f)) {
                vector2.addElement((Object)new GLine(new GPoint2Df(gPoint2Df.x, gPoint2Df.y), new GPoint2Df(gPoint2Df2.x, gPoint2Df2.y), hatchPattern.mLtype));
            }
            item = item.nextItem;
        }
    }

    private static <T extends GPoint2Df> RefList<T> sort(float f, float f2, RefList<T> refList) {
        if (refList == null) {
            return null;
        }
        RefList refList2 = new RefList();
        while (refList.size() != 0) {
            Item<T> item = ToolHatch.getMinLength(f, f2, refList);
            refList2.addElement(item.getObject());
        }
        return refList2;
    }

    private static <T extends GPoint2Df> Item<T> getMinLength(float f, float f2, RefList<T> refList) {
        float f3 = Float.MAX_VALUE;
        Item item = refList.itemAt(0);
        Item item2 = refList.itemAt((int)0).nextItem;
        for (int i = 0; i < refList.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)item2.getObject();
            float f4 = (float)Math.sqrt((gPoint2Df.x - f) * (gPoint2Df.x - f) + (gPoint2Df.y - f2) * (gPoint2Df.y - f2));
            if (f4 < f3) {
                f3 = f4;
                item = item2;
            }
            item2 = item2.nextItem;
        }
        refList.removeItemAt(item);
        return item;
    }
}

