/*
 * Decompiled with CFR 0.152.
 */
package nethome.geom.primitive;

import com.kt.geom.K2DPathFigureLine;
import com.kt.util.RefList;
import com.kt.util.Vector2;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.awt.Color;
import java.io.Serializable;
import jp.kitec.kwt.Area;
import jp.kitec.kwt.IRichGraphics;
import nethome.geom.LocalAxis2Df;
import nethome.geom.Ltype;
import nethome.geom.primitive.GPoint2Df;
import nethome.geom.primitive.Geometory;
import nethome.geom.primitive.Primitive;
import nethome.geom.util.ToolMath;
import nethome.geom.util.ToolPolygon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLine
extends Geometory
implements K2DPathFigureLine,
Primitive,
Serializable {
    private static final String GEOMNAME = "LINE";
    public GPoint2Df pA;
    public GPoint2Df pB;

    public GLine() {
        this(new GPoint2Df(), new GPoint2Df());
    }

    public GLine(GPoint2Df gPoint2Df, GPoint2Df gPoint2Df2) {
        this(gPoint2Df, gPoint2Df2, null);
    }

    public GLine(GPoint2Df gPoint2Df, GPoint2Df gPoint2Df2, Ltype ltype) {
        this.setGeomName(GEOMNAME);
        this.mGeomColor = Color.black;
        this.pA = gPoint2Df;
        this.pB = gPoint2Df2;
        this.lineType = ltype;
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public GLine(float f, float f2, float f3, float f4) {
        this(new GPoint2Df(f, f2), new GPoint2Df(f3, f4));
    }

    @Override
    public boolean getSnapNode(float f, float f2, float f3, float f4, float[] fArray, float[] fArray2, float f5, short s) {
        return false;
    }

    @Override
    public void getSnapLoop(Vector2<? super GPoint2Df> vector2) {
        vector2.addElement((Object)this.pA);
        vector2.addElement((Object)this.pB);
    }

    @Override
    public void getCenter(GPoint2Df gPoint2Df) {
        gPoint2Df.x = (this.pA.x + this.pB.x) / 2.0f;
        gPoint2Df.y = (this.pA.y + this.pB.y) / 2.0f;
    }

    @Override
    public GPoint2Df getNearNode(GPoint2Df gPoint2Df, GPoint2Df gPoint2Df2, float f) {
        float f2 = Float.MAX_VALUE;
        GPoint2Df gPoint2Df3 = null;
        for (int i = 0; i < 2; ++i) {
            float f3;
            GPoint2Df gPoint2Df4 = i == 0 ? this.pA : this.pB;
            float f4 = (float)ToolMath.getLengthLimitLineToPoint2D(gPoint2Df4.x, gPoint2Df4.y, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y);
            if (!(f3 >= 0.0f) || !(f4 < f) || !(f4 < f2)) continue;
            f2 = f4;
            gPoint2Df3 = gPoint2Df4;
        }
        return gPoint2Df3;
    }

    @Override
    public boolean getNearLine(float f, float f2, float f3, GPoint2Df[] gPoint2DfArray) {
        float f4;
        GPoint2Df gPoint2Df = this.pA;
        GPoint2Df gPoint2Df2 = this.pB;
        float f5 = (float)ToolMath.getLengthLimitLineToPoint2D(f, f2, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y);
        if (f4 >= 0.0f && f5 < f3) {
            gPoint2DfArray[0] = gPoint2Df;
            gPoint2DfArray[1] = gPoint2Df2;
            return true;
        }
        return false;
    }

    @Override
    public GPoint2Df getRotbasePoint() {
        return this.pA;
    }

    @Override
    public void updateMinMax(Area area) {
        area.updateMinMax(this.pA.x, this.pA.y);
        area.updateMinMax(this.pB.x, this.pB.y);
    }

    @Override
    public Geometory getCopy() {
        return this.getCopy(new GLine());
    }

    @Override
    protected Geometory getCopy(Geometory geometory) {
        if (geometory == null || !(geometory instanceof GLine)) {
            return null;
        }
        GLine gLine = (GLine)geometory;
        super.getCopy(gLine);
        gLine.pA.setXY(this.pA);
        gLine.pB.setXY(this.pB);
        gLine.area.maximize();
        gLine.updateMinMax(gLine.area);
        return gLine;
    }

    @Override
    public GPoint2Df getNearNode(float f, float f2) {
        float f3;
        float f4;
        float f5 = Float.MAX_VALUE;
        GPoint2Df gPoint2Df = null;
        float f6 = (float)ToolMath.getLength2D(f, f2, this.pA.x, this.pA.y);
        if (f4 < f5) {
            gPoint2Df = this.pA;
            f5 = f6;
        }
        f6 = (float)ToolMath.getLength2D(f, f2, this.pB.x, this.pB.y);
        if (f3 < f5) {
            gPoint2Df = this.pB;
        }
        return gPoint2Df;
    }

    @Override
    public float getDistanceToPoint(float f, float f2) {
        float f3 = (float)ToolMath.getLengthLimitLineToPoint2D(f, f2, this.pA.x, this.pA.y, this.pB.x, this.pB.y);
        if (f3 < 0.0f) {
            return -1.0f;
        }
        return f3;
    }

    @Override
    public void offset(float f, float f2) {
        this.pA.x += f;
        this.pA.y += f2;
        this.pB.x += f;
        this.pB.y += f2;
        this.updateShape();
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    @Override
    public void rotate(float f, float f2, float f3) {
        this.pA.rotate(f, f2, f3);
        this.pB.rotate(f, f2, f3);
        this.updateShape();
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    @Override
    public boolean isInner(float f, float f2, float f3, float f4) {
        boolean bl = false;
        boolean bl2 = false;
        if (this.pA.x > f && this.pA.x < f3 && this.pA.y > f2 && this.pA.y < f4) {
            bl = true;
        }
        if (this.pB.x > f && this.pB.x < f3 && this.pB.y > f2 && this.pB.y < f4) {
            bl2 = true;
        }
        return bl && bl2;
    }

    @Override
    public boolean isInner(RefList<GPoint2Df> refList) {
        return ToolPolygon.isInnerPolygon(refList, this.pA.x, this.pA.y) && ToolPolygon.isInnerPolygon(refList, this.pB.x, this.pB.y);
    }

    @Override
    public void save(ObjectFolder objectFolder) {
        if (objectFolder == null) {
            return;
        }
        objectFolder.setName(GEOMNAME);
        super.save(objectFolder);
        objectFolder.addChild(new ObjectNode("x1", (Object)Float.toString(this.pA.x)));
        objectFolder.addChild(new ObjectNode("y1", (Object)Float.toString(this.pA.y)));
        objectFolder.addChild(new ObjectNode("x2", (Object)Float.toString(this.pB.x)));
        objectFolder.addChild(new ObjectNode("y2", (Object)Float.toString(this.pB.y)));
    }

    public void setLType(Ltype ltype) {
        this.lineType = ltype;
    }

    public Ltype getLType() {
        return this.lineType;
    }

    @Override
    public void drawGeom(IRichGraphics iRichGraphics) {
        this.drawGeom(iRichGraphics, this.mGeomColor, null);
    }

    @Override
    public void drawHighLight(IRichGraphics iRichGraphics, Color color, boolean bl) {
        if (bl) {
            this.drawAbstDevice(iRichGraphics, color, color, null);
        }
        this.pA.drawHighLight(iRichGraphics, color, false);
        this.pB.drawHighLight(iRichGraphics, color, false);
    }

    @Override
    public void drawGeom(IRichGraphics iRichGraphics, Color color, Color color2) {
        if (color == null) {
            color = this.mGeomColor;
        }
        this.drawAbstDevice(iRichGraphics, color, color2, null);
    }

    @Override
    public void drawAlias(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        if (color == null) {
            color = this.mGeomColor;
        }
        this.drawAbstDevice(iRichGraphics, color, color2, localAxis2Df);
    }

    @Override
    public void drawAbstDevice(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        float f;
        float f2;
        float f3;
        float f4;
        if (localAxis2Df != null) {
            f4 = localAxis2Df.getGlobalX(this.pA.x, this.pA.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
            f3 = localAxis2Df.getGlobalY(this.pA.x, this.pA.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
            f2 = localAxis2Df.getGlobalX(this.pB.x, this.pB.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
            f = localAxis2Df.getGlobalY(this.pB.x, this.pB.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
        } else {
            f4 = this.pA.x;
            f3 = this.pA.y;
            f2 = this.pB.x;
            f = this.pB.y;
        }
        iRichGraphics.setColor(color);
        iRichGraphics.drawLine(f4, f3, f2, f, null);
    }

    @Override
    public Object getNearControlPoint(float f, float f2) {
        float f3 = Float.POSITIVE_INFINITY;
        GPoint2Df gPoint2Df = null;
        for (int i = 0; i < 2; ++i) {
            GPoint2Df gPoint2Df2 = i == 0 ? this.pA : this.pB;
            float f4 = gPoint2Df2.getDistanceToPoint(f, f2);
            if (!(f4 < f3)) continue;
            f3 = f4;
            gPoint2Df = gPoint2Df2;
        }
        return gPoint2Df;
    }

    @Override
    public void moveControlPoint(Object object, float f, float f2) {
        if (object == this.pA) {
            this.pA.x = f;
            this.pA.y = f2;
        } else if (object == this.pB) {
            this.pB.x = f;
            this.pB.y = f2;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    @Override
    public void flipx(float f, float f2) {
        this.pA.flipx(f, f2);
        this.pB.flipx(f, f2);
        this.updateShape();
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    @Override
    public void flipy(float f, float f2) {
        this.pA.flipy(f, f2);
        this.pB.flipy(f, f2);
        this.updateShape();
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    @Override
    public void rot(float f, float f2, float f3, float f4) {
        this.pA.rot(f, f2, f3, f4);
        this.pB.rot(f, f2, f3, f4);
        this.updateShape();
        this.area.maximize();
        this.updateMinMax(this.area);
    }

    public int getType() {
        return 1;
    }

    public double getX1() {
        return this.pA.x;
    }

    public double getX2() {
        return this.pB.x;
    }

    public double getY1() {
        return this.pA.y;
    }

    public double getY2() {
        return this.pB.y;
    }

    public void setX1(double d) {
        this.pA.setX(d);
    }

    public void setX2(double d) {
        this.pB.setX(d);
    }

    public void setY1(double d) {
        this.pA.setY(d);
    }

    public void setY2(double d) {
        this.pB.setY(d);
    }
}

