/*
 * Decompiled with CFR 0.152.
 */
package nethome.geom;

import com.kt.geom.KLocalAxis;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.io.Serializable;
import nethome.geom.util.ToolMath;

public class LocalAxis2Df
implements KLocalAxis,
Serializable {
    public float mX;
    public float mY;
    public float mRot;
    private boolean mFlipX = false;
    private boolean mFlipY = false;
    private boolean scaleEnableX = false;
    private boolean scaleEnableY = false;
    private float mScaleX = 1.0f;
    private float mScaleY = 1.0f;

    public LocalAxis2Df() {
        this.mX = 0.0f;
        this.mY = 0.0f;
        this.mRot = 0.0f;
        this.mFlipY = false;
        this.mFlipX = false;
    }

    public float getScaleX() {
        return this.mScaleX;
    }

    public float getScaleY() {
        return this.mScaleY;
    }

    public void setScaleX(float f, boolean bl) {
        if (!this.scaleEnableX && !this.scaleEnableY) {
            this.mScaleY = 1.0f;
            this.mScaleX = 1.0f;
            return;
        }
        if (!this.scaleEnableX) {
            this.mScaleX = 1.0f;
            return;
        }
        this.mScaleX = f;
        if (bl) {
            this.mScaleY = f;
        }
    }

    public void setScaleY(float f, boolean bl) {
        if (!this.scaleEnableX && !this.scaleEnableY) {
            this.mScaleY = 1.0f;
            this.mScaleX = 1.0f;
            return;
        }
        if (!this.scaleEnableY) {
            this.mScaleY = 1.0f;
            return;
        }
        this.mScaleY = f;
        if (bl) {
            this.mScaleX = f;
        }
    }

    public void setScale(float f, float f2) {
        if (!this.scaleEnableX && !this.scaleEnableY) {
            this.mScaleY = 1.0f;
            this.mScaleX = 1.0f;
            return;
        }
        this.mScaleX = f;
        this.mScaleY = f2;
    }

    public void setScaleEnable(boolean bl, boolean bl2) {
        this.scaleEnableX = bl;
        this.scaleEnableY = bl2;
    }

    public boolean isScaleEnableX() {
        return this.scaleEnableX;
    }

    public boolean isScaleEnableY() {
        return this.scaleEnableY;
    }

    public LocalAxis2Df(float f, float f2, float f3, float f4) {
        this.mFlipY = false;
        this.mFlipX = false;
        this.scaleEnableY = false;
        this.scaleEnableX = false;
        this.setLocalCoordinates(f, f2, f3, f4, this.mFlipX, this.mFlipY);
    }

    public LocalAxis2Df(LocalAxis2Df localAxis2Df) {
        this.setLocalCoordinates(localAxis2Df.mX, localAxis2Df.mY, localAxis2Df.mRot, localAxis2Df.mFlipX, localAxis2Df.mFlipY);
        this.setScale(localAxis2Df.mScaleX, localAxis2Df.mScaleY);
        this.setScaleEnable(localAxis2Df.scaleEnableX, localAxis2Df.scaleEnableY);
    }

    public static LocalAxis2Df readData(ObjectFolder objectFolder) throws Exception {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 1.0f;
        float f5 = 1.0f;
        boolean bl = false;
        boolean bl2 = false;
        ObjectNode objectNode = null;
        objectNode = objectFolder.getNode("cx");
        if (objectNode != null) {
            f = Float.valueOf((String)objectNode.getObject()).intValue();
        }
        if ((objectNode = objectFolder.getNode("cy")) != null) {
            f2 = Float.valueOf((String)objectNode.getObject()).intValue();
        }
        if ((objectNode = objectFolder.getNode("angl")) != null) {
            f3 = Float.valueOf((String)objectNode.getObject()).floatValue();
        }
        if ((objectNode = objectFolder.getNode("fx")) != null) {
            bl = Boolean.valueOf((String)objectNode.getObject());
        }
        if ((objectNode = objectFolder.getNode("fy")) != null) {
            bl2 = Boolean.valueOf((String)objectNode.getObject());
        }
        if ((objectNode = objectFolder.getNode("scalex")) != null) {
            f4 = Float.valueOf((String)objectNode.getObject()).floatValue();
        }
        if ((objectNode = objectFolder.getNode("scaley")) != null) {
            f5 = Float.valueOf((String)objectNode.getObject()).floatValue();
        }
        LocalAxis2Df localAxis2Df = new LocalAxis2Df();
        localAxis2Df.mX = f;
        localAxis2Df.mY = f2;
        localAxis2Df.mRot = f3;
        localAxis2Df.mFlipX = bl;
        localAxis2Df.mFlipY = bl2;
        localAxis2Df.mScaleX = f4;
        localAxis2Df.mScaleY = f5;
        return localAxis2Df;
    }

    public void save(ObjectFolder objectFolder) {
        if (objectFolder == null) {
            return;
        }
        objectFolder.setName("AXIS");
        objectFolder.addChild(new ObjectNode("cx", (Object)Float.toString(this.mX)));
        objectFolder.addChild(new ObjectNode("cy", (Object)Float.toString(this.mY)));
        objectFolder.addChild(new ObjectNode("angl", (Object)Float.toString(this.mRot)));
        objectFolder.addChild(new ObjectNode("fx", (Object)Boolean.toString(this.mFlipX)));
        objectFolder.addChild(new ObjectNode("fy", (Object)Boolean.toString(this.mFlipY)));
        objectFolder.addChild(new ObjectNode("scalex", (Object)Float.toString(this.mScaleX)));
        objectFolder.addChild(new ObjectNode("scaley", (Object)Float.toString(this.mScaleY)));
    }

    public void setLocalCoordinates(float f, float f2, float f3, float f4, boolean bl, boolean bl2) {
        this.setLocalCoordinates(f, f2, (float)ToolMath.getAngle2D(f, f2, f3, f4), bl, bl2);
    }

    public void setLocalCoordinates(float f, float f2, float f3, boolean bl, boolean bl2) {
        this.mX = f;
        this.mY = f2;
        this.mRot = f3;
        this.mFlipX = bl;
        this.mFlipY = bl2;
    }

    public void setLocalCoordinates(LocalAxis2Df localAxis2Df) {
        this.mX = localAxis2Df.mX;
        this.mY = localAxis2Df.mY;
        this.mRot = localAxis2Df.mRot;
        this.mFlipX = localAxis2Df.mFlipX;
        this.mFlipY = localAxis2Df.mFlipY;
        this.mScaleX = localAxis2Df.mScaleX;
        this.mScaleY = localAxis2Df.mScaleY;
        this.scaleEnableX = localAxis2Df.scaleEnableX;
        this.scaleEnableY = localAxis2Df.scaleEnableY;
    }

    public boolean getFlipX() {
        return this.mFlipX;
    }

    public void setFlipX(boolean bl) {
        this.mFlipX = bl;
    }

    public boolean getFlipY() {
        return this.mFlipY;
    }

    public void setFlipY(boolean bl) {
        this.mFlipY = bl;
    }

    public float getGlobalX(float f, float f2) {
        if (this.mFlipX) {
            f = -f;
        }
        if (this.mFlipY) {
            f2 = -f2;
        }
        float f3 = f * (float)Math.cos(this.mRot) - f2 * (float)Math.sin(this.mRot) + this.mX;
        return f3;
    }

    public float getGlobalY(float f, float f2) {
        if (this.mFlipX) {
            f = -f;
        }
        if (this.mFlipY) {
            f2 = -f2;
        }
        float f3 = f * (float)Math.sin(this.mRot) + f2 * (float)Math.cos(this.mRot) + this.mY;
        return f3;
    }

    public float getScaledX(float f, float f2, boolean bl, boolean bl2, boolean bl3, float f3, float f4) {
        float f5 = bl ? (!this.scaleEnableX && !this.scaleEnableY ? 1.0f : (this.scaleEnableX && this.scaleEnableY ? Math.max(this.mScaleX, this.mScaleY) : (this.scaleEnableX ? this.mScaleX : this.mScaleY))) : (bl2 ? this.mScaleX : 1.0f);
        float f6 = (f - f3) * f5;
        float f7 = f6 + f3;
        return f7;
    }

    public float getScaledY(float f, float f2, boolean bl, boolean bl2, boolean bl3, float f3, float f4) {
        float f5 = bl ? (!this.scaleEnableX && !this.scaleEnableY ? 1.0f : (this.scaleEnableX && this.scaleEnableY ? Math.max(this.mScaleX, this.mScaleY) : (this.scaleEnableX ? this.mScaleX : this.mScaleY))) : (bl3 ? this.mScaleY : 1.0f);
        float f6 = (f2 - f4) * f5;
        float f7 = f6 + f4;
        return f7;
    }

    public float getGlobalX(float f, float f2, boolean bl, boolean bl2, boolean bl3, float f3, float f4) {
        float f5;
        float f6;
        if (bl) {
            if (!this.scaleEnableX && !this.scaleEnableY) {
                f6 = 1.0f;
                f5 = 1.0f;
            } else {
                f5 = this.scaleEnableX && this.scaleEnableY ? (f6 = Math.max(this.mScaleX, this.mScaleY)) : (this.scaleEnableX ? (f6 = this.mScaleX) : (f6 = this.mScaleY));
            }
        } else {
            f5 = bl2 ? this.mScaleX : 1.0f;
            f6 = bl3 ? this.mScaleY : 1.0f;
        }
        float f7 = (f - f3) * f5;
        float f8 = (f2 - f4) * f6;
        if (this.mFlipX) {
            f7 = -f7;
            f3 = -f3;
        }
        if (this.mFlipY) {
            f8 = -f8;
            f4 = -f4;
        }
        float f9 = (f7 + f3) * (float)Math.cos(this.mRot) - (f8 + f4) * (float)Math.sin(this.mRot) + this.mX;
        return f9;
    }

    public float getGlobalY(float f, float f2, boolean bl, boolean bl2, boolean bl3, float f3, float f4) {
        float f5;
        float f6;
        if (bl) {
            if (!this.scaleEnableX && !this.scaleEnableY) {
                f6 = 1.0f;
                f5 = 1.0f;
            } else {
                f5 = this.scaleEnableX && this.scaleEnableY ? (f6 = Math.max(this.mScaleX, this.mScaleY)) : (this.scaleEnableX ? (f6 = this.mScaleX) : (f6 = this.mScaleY));
            }
        } else {
            f5 = bl2 ? this.mScaleX : 1.0f;
            f6 = bl3 ? this.mScaleY : 1.0f;
        }
        float f7 = (f - f3) * f5;
        float f8 = (f2 - f4) * f6;
        if (this.mFlipX) {
            f7 = -f7;
            f3 = -f3;
        }
        if (this.mFlipY) {
            f8 = -f8;
            f4 = -f4;
        }
        float f9 = (f7 + f3) * (float)Math.sin(this.mRot) + (f8 + f4) * (float)Math.cos(this.mRot) + this.mY;
        return f9;
    }

    public float getGlobalLength(float f) {
        return f * this.mScaleX;
    }

    public float getLocalX(float f, float f2) {
        float f3 = (f - this.mX) * (float)Math.cos(-this.mRot) - (f2 - this.mY) * (float)Math.sin(-this.mRot);
        if (this.mFlipX) {
            f3 = -f3;
        }
        return f3;
    }

    public float getLocalY(float f, float f2) {
        float f3 = (f - this.mX) * (float)Math.sin(-this.mRot) + (f2 - this.mY) * (float)Math.cos(-this.mRot);
        if (this.mFlipY) {
            f3 = -f3;
        }
        return f3;
    }

    public float getGlobalAngl(double d) {
        d += (double)this.mRot;
        if (this.mFlipX) {
            d = Math.PI - d;
        }
        if (this.mFlipY) {
            d = -d;
        }
        return (float)ToolMath.getAngl2PI(d);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.mFlipX ? 1231 : 1237);
        n = 31 * n + (this.mFlipY ? 1231 : 1237);
        n = 31 * n + Float.floatToIntBits(this.mRot);
        n = 31 * n + Float.floatToIntBits(this.mScaleX);
        n = 31 * n + Float.floatToIntBits(this.mScaleY);
        n = 31 * n + Float.floatToIntBits(this.mX);
        n = 31 * n + Float.floatToIntBits(this.mY);
        n = 31 * n + (this.scaleEnableX ? 1231 : 1237);
        n = 31 * n + (this.scaleEnableY ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LocalAxis2Df localAxis2Df = (LocalAxis2Df)object;
        if (this.mFlipX != localAxis2Df.mFlipX) {
            return false;
        }
        if (this.mFlipY != localAxis2Df.mFlipY) {
            return false;
        }
        if (Float.floatToIntBits(this.mRot) != Float.floatToIntBits(localAxis2Df.mRot)) {
            return false;
        }
        if (Float.floatToIntBits(this.mScaleX) != Float.floatToIntBits(localAxis2Df.mScaleX)) {
            return false;
        }
        if (Float.floatToIntBits(this.mScaleY) != Float.floatToIntBits(localAxis2Df.mScaleY)) {
            return false;
        }
        if (Float.floatToIntBits(this.mX) != Float.floatToIntBits(localAxis2Df.mX)) {
            return false;
        }
        if (Float.floatToIntBits(this.mY) != Float.floatToIntBits(localAxis2Df.mY)) {
            return false;
        }
        if (this.scaleEnableX != localAxis2Df.scaleEnableX) {
            return false;
        }
        return this.scaleEnableY == localAxis2Df.scaleEnableY;
    }
}

