/*
 * Decompiled with CFR 0.152.
 */
package nethome.geom;

import com.kt.util.RefList;
import java.io.Serializable;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KRichGraphics;
import nethome.NethomeLookAndFeel;
import nethome.NethomeResource;
import nethome.geom.primitive.GLine;
import nethome.geom.primitive.GPoint2Df;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AreaControl
implements Serializable {
    private RefList<GPoint2Df> _points = new RefList();
    private RefList<GLine> _lines = new RefList();
    private boolean mClose = true;

    public void init() {
        this._points.removeAllElements();
        this._lines.removeAllElements();
    }

    public void setCloseMode(boolean bl) {
        this.mClose = bl;
    }

    public boolean getCloseMode() {
        return this.mClose;
    }

    public void close() {
        int n = this.mClose ? 0 : 1;
        this._lines.removeAllElements();
        for (int i = 0; i < this._points.size() - n; ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)this._points.elementAt(i);
            GPoint2Df gPoint2Df2 = (GPoint2Df)this._points.elementAt(i + 1);
            this._lines.addElement((Object)new GLine(gPoint2Df, gPoint2Df2));
        }
    }

    public RefList<GPoint2Df> getPoints() {
        return this._points;
    }

    public RefList<GLine> getLines() {
        return this._lines;
    }

    public void setArea(RefList<GPoint2Df> refList) {
        this._points.removeAllElements();
        this._points = null;
        this._points = new RefList();
        for (int i = 0; i < refList.size(); ++i) {
            this._points.addElement(refList.elementAt(i));
        }
        this.close();
    }

    public void drawGeomHilight(IRichGraphics iRichGraphics) {
        KRichGraphics kRichGraphics = null;
        if (!(iRichGraphics instanceof KRichGraphics)) {
            return;
        }
        kRichGraphics = (KRichGraphics)iRichGraphics;
        if (this._points.size() > 2 || !this.mClose) {
            GPoint2Df gPoint2Df;
            int n;
            int n2 = this.mClose ? 0 : 1;
            kRichGraphics.setColor(NethomeLookAndFeel.SELECT_SYMBOL_COLOR);
            for (n = 0; n < this._points.size() - n2; ++n) {
                gPoint2Df = (GPoint2Df)this._points.elementAt(n);
                GPoint2Df gPoint2Df2 = (GPoint2Df)this._points.elementAt(n + 1);
                kRichGraphics.drawLine(gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y, IRichGraphics.LINE_DASH_1);
            }
            for (n = 0; n < this._points.size(); ++n) {
                gPoint2Df = (GPoint2Df)this._points.elementAt(n);
                kRichGraphics.setColor(NethomeLookAndFeel.SELECT_SYMBOL_COLOR);
                kRichGraphics.drawMark(gPoint2Df.x, gPoint2Df.y, (int)NethomeResource.MARKER_SIZE, 3);
                kRichGraphics.setColor(NethomeLookAndFeel.SELECT_SYMBOL_MARK_FRAME_COLOR);
                kRichGraphics.drawMark(gPoint2Df.x, gPoint2Df.y, (int)NethomeResource.MARKER_SIZE, 2);
            }
        }
    }
}

