/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.pattern;

import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.object.DictObj;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.util.PdfRect;

public class Shading
extends DictObj {
    private int dx;
    private PdfName dy;
    private PdfRect dz;
    private PdfName bP;

    public Shading(Body body, int n, String string) {
        super(body);
        body.add(this);
        this.setShadingType(n);
        this.setName(string);
    }

    public void setShadingType(int n) {
        this.dx = n;
    }

    public void setColorSpace(PdfName pdfName) {
        this.dy = pdfName;
    }

    public void setBBox(PdfRect pdfRect) {
        this.dz = pdfRect;
    }

    public void setName(String string) {
        this.bP = new PdfName(string);
    }

    public PdfName getName() {
        return this.bP;
    }

    public void updateDict() {
        this.dict.clear();
        this.dict.put(SHADINGTYPE, new Integer(this.dx));
        if (this.dy != null) {
            this.dict.put(COLORSPACE, this.dy);
        }
        if (this.dz != null) {
            this.dict.put(BBOX, this.dz);
        }
    }

    protected String toArrayString(float[] fArray, boolean bl) {
        if (fArray == null || fArray.length <= 0) {
            return null;
        }
        if (fArray.length == 1 && !bl) {
            return String.valueOf(fArray[0]);
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(fArray[0]);
        int n = 1;
        while (n < fArray.length) {
            stringBuffer.append(" ");
            stringBuffer.append(fArray[n]);
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected String toArrayString(boolean[] blArray, boolean bl) {
        if (blArray == null || blArray.length <= 0) {
            return null;
        }
        if (blArray.length == 1 && !bl) {
            return String.valueOf(blArray[0]);
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(blArray[0]);
        int n = 1;
        while (n < blArray.length) {
            stringBuffer.append(" ");
            stringBuffer.append(blArray[n]);
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

