/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.object;

import java.awt.Canvas;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.zip.DeflaterOutputStream;
import option.io.pdfcommon.io.PdfOutFile;
import option.io.pdfcommon.io.PdfStream;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfDictionary;
import option.io.pdfcommon.object.PdfIndirectObject;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.object.PdfXObject;
import option.io.pdfcommon.util.PdfMetrices;

public class ImageXObject
extends PdfIndirectObject
implements DefinedName,
PdfXObject {
    private PdfDictionary dict = new PdfDictionary();
    private PdfStream stream;
    private PdfName ag;
    private int width = 1;
    private int height = 1;
    private PdfMetrices ah = new PdfMetrices(2);

    public ImageXObject() {
        this.dict.put(TYPE, XOBJECT);
        this.dict.put(SUBTYPE, IMAGE);
    }

    public ImageXObject(Image image) {
        this();
        if (image != null) {
            this.setImage(image);
        }
    }

    public ImageXObject(int[] nArray, int n, int n2) {
        this();
        if (nArray.length > 0 && nArray.length == n * n2) {
            this.setImage(nArray, n, n2);
        }
    }

    public void setWidth(int n) {
        this.width = n;
        this.dict.put(WIDTH, new Integer(n));
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int n) {
        this.height = n;
        this.dict.put(HEIGHT, new Integer(n));
    }

    public int getHeight() {
        return this.height;
    }

    public void setName(PdfName pdfName) {
        this.ag = pdfName;
    }

    public void setName(String string) {
        this.setName(new PdfName(string));
    }

    public PdfName getName() {
        return this.ag;
    }

    public PdfMetrices getMTransMatrices() {
        return this.ah;
    }

    public void setMTransMatrices(PdfMetrices pdfMetrices) {
        this.ah = pdfMetrices;
    }

    public void setImage(Image object) throws IllegalStateException {
        Serializable serializable = new MediaTracker(new Canvas());
        serializable.addImage((Image)object, 0);
        try {
            serializable.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            serializable = interruptedException;
            interruptedException.printStackTrace();
            return;
        }
        int n = ((Image)object).getWidth(null);
        int n2 = ((Image)object).getHeight(null);
        if (n < 0 || n2 < 0) {
            throw new IllegalStateException("width or height value is not accepted.");
        }
        int[] nArray = new int[n * n2];
        try {
            object = new PixelGrabber((Image)object, 0, 0, n, n2, nArray, 0, n);
            ((PixelGrabber)object).grabPixels();
        }
        catch (InterruptedException interruptedException) {
            object = interruptedException;
            interruptedException.printStackTrace();
            return;
        }
        this.setImage(nArray, n, n2);
    }

    protected void setImage(int[] nArray, int n, int n2) {
        this.setEntries();
        this.setWidth(n);
        this.setHeight(n2);
        this.stream = new PdfStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(this.stream);
        DataOutputStream dataOutputStream = new DataOutputStream(deflaterOutputStream);
        byte[] byArray = new byte[3072];
        int n3 = 0;
        ColorModel colorModel = ColorModel.getRGBdefault();
        try {
            try {
                int n4 = 0;
                while (n4 < n2) {
                    int n5 = n4 * n;
                    int n6 = 0;
                    while (n6 < n) {
                        int n7 = nArray[n6 + n5];
                        byArray[n3++] = (byte)colorModel.getRed(n7);
                        byArray[n3++] = (byte)colorModel.getGreen(n7);
                        byArray[n3++] = (byte)colorModel.getBlue(n7);
                        if (n3 >= byArray.length) {
                            dataOutputStream.write(byArray, 0, n3);
                            n3 = 0;
                        }
                        ++n6;
                    }
                    ++n4;
                }
                if (n3 > 0) {
                    dataOutputStream.write(byArray, 0, n3);
                }
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                iOException.printStackTrace();
                try {
                    deflaterOutputStream.close();
                    return;
                }
                catch (IOException iOException3) {
                    IOException iOException4 = iOException3;
                    iOException3.printStackTrace();
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            try {
                deflaterOutputStream.close();
            }
            catch (IOException iOException) {
                IOException iOException5 = iOException;
                iOException.printStackTrace();
            }
            throw throwable;
        }
        try {
            deflaterOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            IOException iOException6 = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    protected void setEntries() {
        this.dict.put(COLORSPACE, DEVICERGB);
        this.dict.put(BITSPERCOMPONENT, new Integer(8));
        this.dict.put(FILTER, FLATEDECODE);
        this.dict.put(INTERPOLATE, new Boolean(true));
    }

    public void write(PdfOutFile pdfOutFile) {
        try {
            this.dict.put(LENGTH, new Integer(this.stream.size()));
            PrintStream printStream = pdfOutFile.getPrintStream();
            this.startObject(pdfOutFile);
            printStream.println(this.dict);
            printStream.println("stream");
            this.stream.writeTo(pdfOutFile.getByteStream());
            printStream.println("endstream");
            this.endObject(pdfOutFile);
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.getName().equals(((ImageXObject)object).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

