/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.object;

import java.awt.Color;
import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.document.Contents;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.object.PdfXObject;
import option.io.pdfcommon.path.LineStyle;
import option.io.pdfcommon.util.PdfMetrices;
import option.io.pdfcommon.util.PdfRect;

public class FormXObject
extends Contents
implements DefinedName,
PdfXObject {
    private PdfName ag;
    private float width;
    private float height;
    private float aw = 0.0f;
    private Color ax = Color.black;
    private PdfMetrices ah = new PdfMetrices(3);

    public FormXObject(Body body, PdfRect pdfRect, String string) {
        super(body, pdfRect);
        this.mBody = body;
        this.mediabox = pdfRect;
        this.width = pdfRect.getWidth();
        this.height = pdfRect.getHeight();
        body.add(this.resources);
        this.dict.put(TYPE, XOBJECT);
        this.dict.put(SUBTYPE, new PdfName("Form"));
        this.dict.put(FORMTYPE, new Integer(1));
        this.dict.put(BBOX, pdfRect);
        this.dict.put(RESOURCES, this.resources.getReference());
        if (string == null) {
            this.setName("xf" + (this.resources.getXObjectDictionary().size() + 1));
        } else {
            this.resources.getXObjectDictionary().containsKey(string);
            this.setName(string);
        }
        this.pageCoor();
    }

    public FormXObject(Body body, PdfRect pdfRect) {
        this(body, pdfRect, "XF1");
    }

    public FormXObject(Body body, PdfRect pdfRect, int n) {
        this(body, pdfRect);
        this.aw = n;
        this.writeBorder();
    }

    public FormXObject(Body body, PdfRect pdfRect, String string, int n) {
        this(body, pdfRect, string);
        this.aw = n;
        this.writeBorder();
    }

    public void setName(String string) {
        this.ag = new PdfName(string);
    }

    public void setName(PdfName pdfName) {
        this.ag = pdfName;
    }

    public PdfName getName() {
        return this.ag;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getBorder() {
        return this.aw;
    }

    public void setBorder(float f) {
        this.aw = f;
    }

    public PdfMetrices getMTransMatrices() {
        return this.ah;
    }

    public void setMTransMatrices(PdfMetrices pdfMetrices) {
        this.ah = pdfMetrices;
    }

    public void writeBorder() {
        this.writeBorder(this.aw, new LineStyle(this.aw), this.ax);
    }

    public void writeBorder(float f, LineStyle lineStyle, Color color) {
        if (f > 0.0f && f < this.height && f < this.width) {
            this.aw = f;
            this.ax = color;
            this.writeRectangle(this.mediabox.getLux(), 0.0f, this.mediabox.getWidth(), this.mediabox.getHeight(), lineStyle, color, false);
        }
    }

    public void pageCoor() {
        this.setDefaultCoor();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.getName().equals(((FormXObject)object).getName());
    }

    public final int hashCode() {
        return this.getName().hashCode();
    }
}

