/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.function;

import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.object.DictObj;

public class Function
extends DictObj {
    private int bv;
    private float[] a;
    private float[] bw;

    public Function(Body body, int n) {
        super(body);
        body.add(this);
        this.setFunctionType(n);
    }

    public void setFunctionType(int n) {
        this.bv = n;
    }

    public void setDomain(float[] fArray) {
        this.a = fArray;
    }

    public void setRange(float[] fArray) {
        this.bw = fArray;
    }

    public void updateDict() {
        this.dict.clear();
        this.dict.put(FUNCTIONTYPE, new Integer(this.bv));
        String string = this.toArrayString(this.a, true);
        if (string != null) {
            this.dict.put(DOMAIN, string);
        }
        if ((string = this.toArrayString(this.bw, true)) != null) {
            this.dict.put(RANGE, string);
        }
    }

    protected String toArrayString(float[] fArray, boolean bl) {
        if (fArray == null || fArray.length <= 0) {
            return null;
        }
        if (fArray.length == 1 && !bl) {
            return String.valueOf(fArray[0]);
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(fArray[0]);
        int n = 1;
        while (n < fArray.length) {
            stringBuffer.append(" ");
            stringBuffer.append(fArray[n]);
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

