/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.io.FileNotFoundException;
import java.io.IOException;
import option.io.pdfcommon.font.CIDFont;
import option.io.pdfcommon.font.CIDSystemInfo;
import option.io.pdfcommon.font.CmapStream;
import option.io.pdfcommon.font.EmbedFontFile;
import option.io.pdfcommon.font.Encoding;
import option.io.pdfcommon.font.FontDescriptor;
import option.io.pdfcommon.font.PdfFont;
import option.io.pdfcommon.font.TrueTypeFile;
import option.io.pdfcommon.font.TrueTypeFontFileReader;
import option.io.pdfcommon.object.DefinedName;
import option.io.pdfcommon.object.PdfArray;
import option.io.pdfcommon.object.PdfName;
import option.io.pdfcommon.util.PdfRect;

public class TrueTypeFont
extends PdfFont {
    public String fontFileName;
    private TrueTypeFile bj;
    private TrueTypeFontFileReader fr;
    private CIDFont bk;
    private FontDescriptor bl;
    private int[] bm = new int[4];
    private String bn;
    private PdfName bo;
    private boolean bp;

    public TrueTypeFont() {
        this.setEncoding(new Encoding("UnicodeBigUnmarked"));
        this.cL = new CmapStream();
        this.cM = new EmbedFontFile();
    }

    public TrueTypeFont(String object) {
        this();
        this.fontFileName = object;
        try {
            this.fr = new TrueTypeFontFileReader(this.fontFileName, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            object = fileNotFoundException;
            fileNotFoundException.printStackTrace();
        }
        this.bj = new TrueTypeFile();
        this.bj.fr = this.fr;
        this.bk = new CIDFont();
        new CIDSystemInfo();
        this.bl = new FontDescriptor();
    }

    public void resetUesedChars(String string) {
        this.bj.resetUsedChars(string);
    }

    private void a(String string) {
        this.bo = new PdfName("TTF+" + string);
        this.setBaseFont(this.bo);
    }

    public void loadFontDirectory() {
        this.bj.loadFontDirectory();
        this.a(this.bj.getFontName());
    }

    public void createFont() {
        if (!this.bp) {
            this.bj.LoadFontData();
            this.bp = true;
        }
        this.bj.getUsedGlyphIndexs();
        this.cL.setCmapStr(this.bj.getUsedCmaps());
        this.cM.setFontData(this.bj.getFontData());
        this.a(this.bj.getFontName());
        this.bm = this.bj.getFontBox();
        this.setSubtype(DefinedName.TYPE0);
        this.setName(new PdfName(this.bn));
        this.setDescendantFont(this.bk);
        this.setEncoding(this.getEncoding());
        this.bk.setSubtype(DefinedName.CIDFONTTYPE2);
        this.bk.setName(this.getName());
        this.bk.setBaseFont(this.bo);
        this.bk.setFontDescriptor(this.bl);
        this.bk.setCIDSystemInfo(this.getEncoding().getMCIDSystemInfo());
        this.bk.setDW(1000);
        this.bk.dict.put(CIDTOGIDMAP, new PdfName("Identity"));
        PdfArray pdfArray = new PdfArray();
        int[] nArray = this.bj.getUsedGIInt();
        int[] nArray2 = this.bj.getUsedGWidths();
        int n = 0;
        while (n < nArray.length) {
            if (nArray2[n] != 1000) {
                pdfArray.addElement(String.valueOf(nArray[n]) + " [" + nArray2[n] + "]");
            }
            ++n;
        }
        this.bk.setW(pdfArray);
        this.bl.setFontName(this.bo);
        this.bl.setAscent(this.bj.getAscent());
        this.bl.setCapHeight(this.bj.getCapHeight());
        this.bl.setDescent(this.bj.getDscent());
        this.bl.setFlags(this.bj.getFlags());
        this.bl.setFontBBox(new PdfRect(this.bm[0], this.bm[1], this.bm[2], this.bm[3]));
        this.bl.setItalicAngle((int)this.bj.getItalicAngle());
        this.bl.setStemV(this.bj.getStemV());
        this.bl.setMEmbedFontFile(this.cM);
    }

    public TrueTypeFile getMTrueTypeFile() {
        return this.bj;
    }

    public void setListFontName(String string) {
        this.bn = string;
    }

    public String getListFontName() {
        return this.bn;
    }

    public int charWidth(char c) {
        Integer n = (Integer)this.bj.getCmaps().get(new Integer(c));
        return (Integer)this.bj.getUsedGI_GW().get(n);
    }

    public boolean isTrueTypeCollection() {
        return this.fontFileName.toLowerCase().indexOf(".ttc") > 0;
    }

    public void close() throws IOException {
        if (this.fr != null) {
            this.fr.close();
        }
    }
}

