/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import option.io.pdfcommon.font.CmapTable;
import option.io.pdfcommon.font.DefaultTable;
import option.io.pdfcommon.font.FontDirectory;
import option.io.pdfcommon.font.HeadTable;
import option.io.pdfcommon.font.HheaTable;
import option.io.pdfcommon.font.HtmxTable;
import option.io.pdfcommon.font.LocaTable;
import option.io.pdfcommon.font.MaxpTable;
import option.io.pdfcommon.font.NameTable;
import option.io.pdfcommon.font.OS2Table;
import option.io.pdfcommon.font.PostTable;
import option.io.pdfcommon.font.TrueTypeFontFileReader;

public class TrueTypeFile {
    private static String[] bX = new String[]{"cvt ", "fpgm", "glyf", "head", "hhea", "hmtx", "loca", "maxp", "prep"};
    private static int[] bY;
    private FontDirectory bZ;
    private HeadTable ca;
    private MaxpTable cb;
    private HheaTable cc;
    private NameTable cd;
    private LocaTable ce;
    private CmapTable cf;
    private OS2Table cg;
    private PostTable ch;
    private HtmxTable ci;
    private String copyRightNotice;
    private String familyName;
    private String subFamilyName;
    private String fullName;
    private String fontName;
    private int flags;
    private int cj;
    private int ascent;
    private int ck;
    private float ItalicAngle;
    private int[] cl = new int[4];
    private byte[] panose = new byte[10];
    private Hashtable bO;
    private Hashtable cm;
    private int[] cn;
    private long[] offsets;
    private Vector co;
    private int firstChar;
    private int lastChar;
    private Hashtable tableCollection;
    public TrueTypeFontFileReader fr;
    private int[] cp;
    private byte[] cq;
    private byte[] cr;
    private int cs;
    private int ct;
    private int[] cu;
    private int[] cv;
    private Hashtable cw;

    static {
        int[] nArray = new int[21];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 2;
        nArray[5] = 2;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 3;
        nArray[9] = 3;
        nArray[10] = 3;
        nArray[11] = 3;
        nArray[12] = 3;
        nArray[13] = 3;
        nArray[14] = 3;
        nArray[15] = 3;
        nArray[16] = 4;
        nArray[17] = 4;
        nArray[18] = 4;
        nArray[19] = 4;
        nArray[20] = 4;
        bY = nArray;
    }

    public TrueTypeFile() {
        this.bZ = new FontDirectory();
        this.co = new Vector();
    }

    public void loadFontDirectory() {
        this.bZ.loadFontData(this.fr);
        this.tableCollection = this.bZ.tableCollection;
        DefaultTable defaultTable = (DefaultTable)this.tableCollection.get("name");
        if (defaultTable != null) {
            this.cd = new NameTable();
            this.cd.tableName = defaultTable.tableName;
            this.cd.checkSum = defaultTable.checkSum;
            this.cd.offset = defaultTable.offset;
            this.cd.length = defaultTable.length;
            this.cd.loadFontData(this.fr);
        }
        this.copyRightNotice = this.cd.copyRightNotice;
        this.familyName = this.cd.familyName;
        this.subFamilyName = this.cd.subFamilyName;
        this.fullName = this.cd.fullName;
        this.fontName = this.cd.fontName;
    }

    public void checkTTC(String string) {
        block9: {
            Object object = this.fr.readByteString(4);
            if (((String)object).equals("ttcf")) {
                try {
                    this.fr.skipBytes(4);
                    int n = (int)this.fr.readUInt32();
                    long[] lArray = new long[n];
                    int n2 = 0;
                    while (n2 < n) {
                        lArray[n2] = this.fr.readUInt32();
                        ++n2;
                    }
                    n2 = 0;
                    while (n2 < n) {
                        this.bZ.offset = lArray[n2];
                        this.bZ.loadFontData(this.fr);
                        this.tableCollection = this.bZ.tableCollection;
                        DefaultTable defaultTable = (DefaultTable)this.tableCollection.get("name");
                        if (defaultTable != null) {
                            this.cd = new NameTable();
                            this.cd.tableName = defaultTable.tableName;
                            this.cd.checkSum = defaultTable.checkSum;
                            this.cd.offset = defaultTable.offset;
                            this.cd.length = defaultTable.length;
                            this.cd.loadFontData(this.fr);
                        }
                        if (!string.equals(this.cd.familyName)) {
                            ++n2;
                            continue;
                        }
                        break block9;
                    }
                    return;
                }
                catch (IOException iOException) {
                    object = iOException;
                    iOException.printStackTrace();
                    System.out.println("IOException on checking ttc");
                    return;
                }
            }
            try {
                this.fr.seek(0L);
                return;
            }
            catch (IOException iOException) {
                object = iOException;
                iOException.printStackTrace();
            }
        }
    }

    public void LoadFontData() {
        this.loadFontDirectory();
        Object object = (DefaultTable)this.tableCollection.get("head");
        if (object != null) {
            this.ca = new HeadTable();
            this.ca.tableName = ((DefaultTable)object).tableName;
            this.ca.checkSum = ((DefaultTable)object).checkSum;
            this.ca.offset = ((DefaultTable)object).offset;
            this.ca.length = ((DefaultTable)object).length;
            this.ca.loadFontData(this.fr);
        }
        if ((object = (DefaultTable)this.tableCollection.get("hhea")) != null) {
            this.cc = new HheaTable();
            this.cc.tableName = ((DefaultTable)object).tableName;
            this.cc.checkSum = ((DefaultTable)object).checkSum;
            this.cc.offset = ((DefaultTable)object).offset;
            this.cc.length = ((DefaultTable)object).length;
            this.cc.loadFontData(this.fr);
        }
        if ((object = (DefaultTable)this.tableCollection.get("hmtx")) != null) {
            this.ci = new HtmxTable();
            this.ci.tableName = ((DefaultTable)object).tableName;
            this.ci.checkSum = ((DefaultTable)object).checkSum;
            this.ci.offset = ((DefaultTable)object).offset;
            this.ci.length = ((DefaultTable)object).length;
            this.ci.numOfLongHorMetrics = this.cc.numOfLongHorMetrics;
            this.ci.loadFontData(this.fr);
        }
        if ((object = (DefaultTable)this.tableCollection.get("maxp")) != null) {
            this.cb = new MaxpTable();
            this.cb.tableName = ((DefaultTable)object).tableName;
            this.cb.checkSum = ((DefaultTable)object).checkSum;
            this.cb.offset = ((DefaultTable)object).offset;
            this.cb.length = ((DefaultTable)object).length;
            this.cb.loadFontData(this.fr);
        }
        if ((object = (DefaultTable)this.tableCollection.get("loca")) != null) {
            this.ce = new LocaTable();
            this.ce.tableName = ((DefaultTable)object).tableName;
            this.ce.checkSum = ((DefaultTable)object).checkSum;
            this.ce.offset = ((DefaultTable)object).offset;
            this.ce.length = ((DefaultTable)object).length;
            this.ce.indexToLocFormat = this.ca.indexToLocFormat;
            this.ce.numGlyphs = this.cb.numGlyphs;
            this.ce.loadFontData(this.fr);
        }
        if ((object = (DefaultTable)this.tableCollection.get("glyf")) != null && this.ce != null) {
            this.cm = new Hashtable();
            int n = 0;
            while (n < this.ce.numGlyphs) {
                int n2 = (int)(this.ce.offsets[n + 1] - this.ce.offsets[n]);
                if (n2 > 0) {
                    Object object2 = new byte[n2];
                    try {
                        this.fr.seek(((DefaultTable)object).offset + this.ce.offsets[n]);
                        this.fr.read((byte[])object2);
                        this.cm.put(new Integer(n), object2);
                    }
                    catch (IOException iOException) {
                        object2 = iOException;
                        iOException.printStackTrace();
                    }
                }
                ++n;
            }
        }
        if ((object = (DefaultTable)this.tableCollection.get("cmap")) != null) {
            this.cf = new CmapTable();
            this.cf.tableName = ((DefaultTable)object).tableName;
            this.cf.checkSum = ((DefaultTable)object).checkSum;
            this.cf.offset = ((DefaultTable)object).offset;
            this.cf.length = ((DefaultTable)object).length;
            this.cf.loadFontData(this.fr);
            this.bO = this.cf.getCmaps();
        }
        if ((object = (DefaultTable)this.tableCollection.get("OS/2")) != null) {
            this.cg = new OS2Table();
            this.cg.tableName = ((DefaultTable)object).tableName;
            this.cg.checkSum = ((DefaultTable)object).checkSum;
            this.cg.offset = ((DefaultTable)object).offset;
            this.cg.length = ((DefaultTable)object).length;
            this.cg.unitsPerEm = this.ca.unitsPerEm;
            this.cg.loadFontData(this.fr);
        }
        if ((object = (DefaultTable)this.tableCollection.get("post")) != null) {
            this.ch = new PostTable();
            this.ch.tableName = ((DefaultTable)object).tableName;
            this.ch.checkSum = ((DefaultTable)object).checkSum;
            this.ch.offset = ((DefaultTable)object).offset;
            this.ch.length = ((DefaultTable)object).length;
            this.ch.loadFontData(this.fr);
        }
        object = this;
        if (((TrueTypeFile)object).ca != null) {
            ((TrueTypeFile)object).ca.flags = 0;
            if (((TrueTypeFile)object).ch != null && ((TrueTypeFile)object).ch.ItalicAngle != 0.0f) {
                ((TrueTypeFile)object).ca.flags |= 0x40;
            }
            if (((TrueTypeFile)object).cg != null) {
                if (((TrueTypeFile)object).cg.panose[0] == 3) {
                    ((TrueTypeFile)object).ca.flags |= 8;
                }
                if (((TrueTypeFile)object).cg.panose[1] != 0) {
                    ((TrueTypeFile)object).ca.flags |= 2;
                }
                if (((TrueTypeFile)object).cg.panose[2] >= 8) {
                    ((TrueTypeFile)object).ca.flags |= 0x40000;
                }
                if (((TrueTypeFile)object).cg.panose[3] != 9) {
                    ((TrueTypeFile)object).ca.flags |= 1;
                }
            }
            ((TrueTypeFile)object).ca.flags |= 4;
            ((TrueTypeFile)object).ca.flags |= 0x20000;
        }
        this.flags = this.ca.flags;
        if (this.flags <= 0) {
            this.flags = 32;
        }
        this.cl[0] = this.ca.changeTTF2PdfUnit(this.ca.xMin, this.ca.unitsPerEm);
        this.cl[1] = this.ca.changeTTF2PdfUnit(this.ca.yMin, this.ca.unitsPerEm);
        this.cl[2] = this.ca.changeTTF2PdfUnit(this.ca.xMax, this.ca.unitsPerEm);
        this.cl[3] = this.ca.changeTTF2PdfUnit(this.ca.yMax, this.ca.unitsPerEm);
        this.ascent = this.cc.changeTTF2PdfUnit(this.cc.ascent, this.ca.unitsPerEm);
        this.ck = this.cc.changeTTF2PdfUnit(this.cc.descent, this.ca.unitsPerEm);
        this.ItalicAngle = this.ch.ItalicAngle;
        this.panose = this.cg.panose;
        this.cj = this.cg.changeTTF2PdfUnit(this.cg.sCapHeight, this.ca.unitsPerEm);
        this.cn = this.ci.advanceWidths;
        this.offsets = this.ce.offsets;
    }

    public void resetUsedChars(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            int n2 = this.co.size();
            if (n2 == 0) {
                this.co.add(new Integer(c));
                this.firstChar = c;
                this.lastChar = c;
            } else if (this.co.indexOf(new Integer(c)) < 0) {
                this.co.add(new Integer(c));
            }
            if (c > this.lastChar) {
                this.lastChar = c;
            }
            if (c < this.firstChar) {
                this.firstChar = c;
            }
            ++n;
        }
    }

    private static String toHex(int n) {
        String string = Integer.toHexString(n);
        return String.valueOf("<0000".substring(0, 5 - string.length())) + string + ">";
    }

    private static void a(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >> 8);
        byArray[n] = (byte)n2;
    }

    private static void a(byte[] byArray, int n, long l) {
        byArray[n++] = (byte)(l >> 24 & 0xFFL);
        byArray[n++] = (byte)(l >> 16 & 0xFFL);
        byArray[n++] = (byte)(l >> 8 & 0xFFL);
        byArray[n] = (byte)(l & 0xFFL);
    }

    public byte[] getFontData() {
        int n;
        int n2;
        Object object = this;
        int[] nArray = ((TrueTypeFile)object).cu;
        ((TrueTypeFile)object).cq = null;
        ((TrueTypeFile)object).cp = new int[((TrueTypeFile)object).ce.numGlyphs + 1];
        int n3 = 0;
        if (((TrueTypeFile)object).fr != null && ((TrueTypeFile)object).tableCollection != null && ((TrueTypeFile)object).co != null) {
            int n4;
            int n5 = 0;
            while (n5 < nArray.length) {
                n4 = nArray[n5];
                int n6 = (int)(((TrueTypeFile)object).offsets[n4 + 1] - ((TrueTypeFile)object).offsets[n4]);
                n3 += n6;
                ++n5;
            }
            ((TrueTypeFile)object).cs = n3;
            ((TrueTypeFile)object).cq = new byte[n3 + 3 & 0xFFFFFFFC];
            n5 = 0;
            n4 = 0;
            DefaultTable defaultTable = (DefaultTable)((TrueTypeFile)object).tableCollection.get("glyf");
            n2 = 0;
            while (n2 < ((TrueTypeFile)object).cp.length) {
                ((TrueTypeFile)object).cp[n2] = n5;
                if (n4 < nArray.length && nArray[n4] == n2) {
                    ++n4;
                    ((TrueTypeFile)object).cp[n2] = n5;
                    long l = ((TrueTypeFile)object).offsets[n2];
                    n = (int)(((TrueTypeFile)object).offsets[n2 + 1] - l);
                    if (n > 0) {
                        try {
                            ((TrueTypeFile)object).fr.seek(defaultTable.offset + l);
                            ((TrueTypeFile)object).fr.readFully(((TrueTypeFile)object).cq, n5, n);
                            n5 += n;
                        }
                        catch (IOException iOException) {
                            IOException iOException2 = iOException;
                            iOException.printStackTrace();
                        }
                    }
                }
                ++n2;
            }
            n2 = ((TrueTypeFile)object).ce.indexToLocFormat == 0 ? ((TrueTypeFile)object).cp.length << 1 : ((TrueTypeFile)object).cp.length << 2;
            ((TrueTypeFile)object).cr = new byte[n2 + 3 & 0xFFFFFFFC];
            ((TrueTypeFile)object).ct = n2;
            int n7 = 0;
            int n8 = 0;
            while (n8 < ((TrueTypeFile)object).cp.length) {
                if (((TrueTypeFile)object).ce.indexToLocFormat == 0) {
                    TrueTypeFile.a(((TrueTypeFile)object).cr, n7, ((TrueTypeFile)object).cp[n8] / 2);
                    n7 += 2;
                } else {
                    TrueTypeFile.a(((TrueTypeFile)object).cr, n7, (long)((TrueTypeFile)object).cp[n8]);
                    n7 += 4;
                }
                ++n8;
            }
        }
        int n9 = 0;
        n = 0;
        while (n < bX.length) {
            if (bX[n] != "glyf" && bX[n] != "loca") {
                DefaultTable defaultTable = (DefaultTable)this.tableCollection.get(bX[n]);
                n9 += defaultTable.length + 3 & 0xFFFFFFFC;
            }
            ++n;
        }
        n9 += this.cr.length;
        n9 += this.cq.length;
        byte[] byArray = new byte[n9 += 12 + 16 * bX.length];
        n2 = 0;
        TrueTypeFile.a(byArray, 0, 65536L);
        n2 += 4;
        TrueTypeFile.a(byArray, 4, bX.length);
        n2 += 2;
        n = bY[bX.length];
        TrueTypeFile.a(byArray, 6, 1 << n << 4);
        n2 += 2;
        TrueTypeFile.a(byArray, 8, n);
        n2 += 2;
        TrueTypeFile.a(byArray, 10, bX.length - (1 << n) << 4);
        n2 += 2;
        int n10 = 12 + 16 * bX.length;
        n = 0;
        while (n < bX.length) {
            Object object2 = object = bX[n];
            int n11 = n2;
            object = byArray;
            try {
                byte[] byArray2 = ((String)object2).getBytes("ISO-8859-1");
                System.arraycopy(byArray2, 0, object, n11, byArray2.length);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                UnsupportedEncodingException unsupportedEncodingException2 = unsupportedEncodingException;
                unsupportedEncodingException.printStackTrace();
            }
            n2 += 4;
            object = (DefaultTable)this.tableCollection.get(bX[n]);
            if (bX[n] == "glyf") {
                TrueTypeFile.a(byArray, n2, (long)this.calculateChecksum(this.cq));
                ((DefaultTable)object).length = this.cs;
            } else if (bX[n] == "loca") {
                TrueTypeFile.a(byArray, n2, (long)this.calculateChecksum(this.cr));
                ((DefaultTable)object).length = this.ct;
            } else {
                TrueTypeFile.a(byArray, n2, ((DefaultTable)object).checkSum);
            }
            TrueTypeFile.a(byArray, n2 += 4, (long)n10);
            n11 = ((DefaultTable)object).length + 3 & 0xFFFFFFFC;
            TrueTypeFile.a(byArray, n2 += 4, (long)((DefaultTable)object).length);
            n2 += 4;
            n10 += n11;
            ++n;
        }
        n = 0;
        while (n < bX.length) {
            object = (DefaultTable)this.tableCollection.get(bX[n]);
            if (bX[n] == "glyf") {
                System.arraycopy(this.cq, 0, byArray, n2, this.cq.length);
                n2 += this.cq.length;
            } else if (bX[n] == "loca") {
                System.arraycopy(this.cr, 0, byArray, n2, this.cr.length);
                n2 += this.cr.length;
            } else {
                try {
                    this.fr.seek(((DefaultTable)object).offset);
                    this.fr.readFully(byArray, n2, ((DefaultTable)object).length);
                    n2 += ((DefaultTable)object).length + 3 & 0xFFFFFFFC;
                }
                catch (IOException iOException) {
                    object = iOException;
                    iOException.printStackTrace();
                }
            }
            ++n;
        }
        return byArray;
    }

    public void getUsedGlyphIndexs() {
        if (this.co != null) {
            Vector<Object> vector = new Vector<Object>();
            int n = 0;
            while (n < this.co.size()) {
                Integer n2 = (Integer)this.co.elementAt(n);
                vector.add(this.bO.get(n2));
                ++n;
            }
            if (vector.size() > 0 && !vector.contains(new Integer(0))) {
                vector.add(new Integer(0));
            }
            this.cu = new int[vector.size()];
            n = 0;
            while (n < vector.size()) {
                this.cu[n] = (Integer)vector.elementAt(n);
                ++n;
            }
            Arrays.sort(this.cu);
            this.cv = new int[this.cu.length];
            this.cw = new Hashtable();
            n = 0;
            while (n < this.cu.length) {
                this.cv[n] = this.ci.changeTTF2PdfUnit(this.ci.advanceWidths[this.cu[n]], this.ca.unitsPerEm);
                this.cw.put(new Integer(this.cu[n]), new Integer(this.cv[n]));
                ++n;
            }
        }
    }

    public String getUsedCmaps() {
        if (this.co.size() == 0) {
            return null;
        }
        int n = (Integer)this.bO.get(new Integer(this.firstChar));
        int n2 = (Integer)this.bO.get(new Integer(this.lastChar));
        StringBuffer stringBuffer = new StringBuffer("/CIDInit /ProcSet findresource begin\n");
        stringBuffer.append("12 dict begin\n");
        stringBuffer.append("begincmap\n");
        stringBuffer.append("/CIDSystemInfo\n");
        stringBuffer.append("<< /Registry (Adobe)\n");
        stringBuffer.append("/Ordering (UCS)\n");
        stringBuffer.append("/Supplement 0\n");
        stringBuffer.append(">> def\n");
        stringBuffer.append("/CMapName /Adobe-Identity-UCS def\n");
        stringBuffer.append("/CMapType 2 def\n");
        stringBuffer.append("1 begincodespacerange\n");
        stringBuffer.append(TrueTypeFile.toHex(n));
        stringBuffer.append(TrueTypeFile.toHex(n2));
        stringBuffer.append("\nendcodespacerange\n");
        stringBuffer.append(this.co.size());
        stringBuffer.append(" beginbfrange\n");
        int n3 = 0;
        while (n3 < this.co.size()) {
            Integer n4 = (Integer)this.co.elementAt(n3);
            n = n4;
            n2 = (Integer)this.bO.get(n4);
            stringBuffer.append(TrueTypeFile.toHex(n));
            stringBuffer.append(" ");
            stringBuffer.append(TrueTypeFile.toHex(n));
            stringBuffer.append(" ");
            stringBuffer.append(n2);
            stringBuffer.append("\n");
            ++n3;
        }
        stringBuffer.append("endbfrange\n");
        stringBuffer.append("endcmap\n");
        stringBuffer.append("CMapName currentdict /CMap defineresource pop\n");
        stringBuffer.append("end end\n");
        return stringBuffer.toString();
    }

    public CmapTable getMCmapTable() {
        return this.cf;
    }

    public FontDirectory getMFontDirectory() {
        return this.bZ;
    }

    public HeadTable getMHeadTable() {
        return this.ca;
    }

    public HheaTable getMHheaTable() {
        return this.cc;
    }

    public LocaTable getMLocaTable() {
        return this.ce;
    }

    public MaxpTable getMMaxpTable() {
        return this.cb;
    }

    public NameTable getMNameTable() {
        return this.cd;
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getCapHeight() {
        return this.cj;
    }

    public Hashtable getCmaps() {
        return this.bO;
    }

    public String getCopyRightNotice() {
        return this.copyRightNotice;
    }

    public int getDscent() {
        return this.ck;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public int getFirstChar() {
        return this.firstChar;
    }

    public int getFlags() {
        return this.flags;
    }

    public int[] getFontBox() {
        return this.cl;
    }

    public String getFontName() {
        return this.fontName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public Hashtable getGlyphData() {
        return this.cm;
    }

    public int[] getGlyphWidths() {
        return this.cn;
    }

    public float getItalicAngle() {
        return this.ItalicAngle;
    }

    public int getLastChar() {
        return this.lastChar;
    }

    public HtmxTable getMHtmxTable() {
        return this.ci;
    }

    public OS2Table getMOS2Table() {
        return this.cg;
    }

    public PostTable getMPostTable() {
        return this.ch;
    }

    public long[] getOffsets() {
        return this.offsets;
    }

    public byte[] getPanose() {
        return this.panose;
    }

    public int getStemV() {
        return 0;
    }

    public String getSubFamilyName() {
        return this.subFamilyName;
    }

    public Vector getUsedChars() {
        return this.co;
    }

    public void setMCmapTable(CmapTable cmapTable) {
        this.cf = cmapTable;
    }

    public void setMFontDirectory(FontDirectory fontDirectory) {
        this.bZ = fontDirectory;
    }

    public void setMHeadTable(HeadTable headTable) {
        this.ca = headTable;
    }

    public void setMHheaTable(HheaTable hheaTable) {
        this.cc = hheaTable;
    }

    public void setMLocaTable(LocaTable locaTable) {
        this.ce = locaTable;
    }

    public void setMMaxpTable(MaxpTable maxpTable) {
        this.cb = maxpTable;
    }

    public void setMNameTable(NameTable nameTable) {
        this.cd = nameTable;
    }

    protected int calculateChecksum(byte[] byArray) {
        int n = byArray.length / 4;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n) {
            n5 += byArray[n6++] & 0xFF;
            n4 += byArray[n6++] & 0xFF;
            n3 += byArray[n6++] & 0xFF;
            n2 += byArray[n6++] & 0xFF;
            ++n7;
        }
        return n2 + (n3 << 8) + (n4 << 16) + (n5 << 24);
    }

    public static void main(String[] object) {
        try {
            object = new TrueTypeFontFileReader("d:\\HGRPP1.TTC", "r");
            TrueTypeFile trueTypeFile = new TrueTypeFile();
            new TrueTypeFile().fr = object;
            trueTypeFile.LoadFontData();
            trueTypeFile.resetUsedChars("\u65e5");
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            object = fileNotFoundException;
            fileNotFoundException.printStackTrace();
            return;
        }
    }

    public Hashtable getUsedGI_GW() {
        return this.cw;
    }

    public int[] getUsedGIInt() {
        return this.cu;
    }

    public int[] getUsedGWidths() {
        return this.cv;
    }
}

