/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.font;

import java.io.IOException;
import option.io.pdfcommon.font.TTFTable;
import option.io.pdfcommon.font.TrueTypeFontFileReader;

public class NameTable
extends TTFTable {
    private int cx;
    private int cy;
    private int cz;
    private int[] cA;
    private int[] bF;
    private int[] cB;
    private int[] cC;
    private int[] bH;
    private int[] offsets;
    private String[] names;
    public String copyRightNotice;
    public String familyName;
    public String subFamilyName;
    public String fullName;
    public String fontName;

    public void loadFontData(TrueTypeFontFileReader trueTypeFontFileReader) {
        try {
            trueTypeFontFileReader.seekTable(this);
            this.cx = trueTypeFontFileReader.readUInt16();
            this.cy = trueTypeFontFileReader.readUInt16();
            this.cz = trueTypeFontFileReader.readUInt16();
            this.cA = new int[this.cy];
            this.bF = new int[this.cy];
            this.cB = new int[this.cy];
            this.cC = new int[this.cy];
            this.bH = new int[this.cy];
            this.offsets = new int[this.cy];
            this.names = new String[this.cy];
            long l = trueTypeFontFileReader.getFilePointer();
            int n = 0;
            while (n < this.cy) {
                trueTypeFontFileReader.seek(l + (long)(n * 12));
                this.cA[n] = trueTypeFontFileReader.readUInt16();
                this.bF[n] = trueTypeFontFileReader.readUInt16();
                this.cB[n] = trueTypeFontFileReader.readUInt16();
                this.cC[n] = trueTypeFontFileReader.readUInt16();
                this.bH[n] = trueTypeFontFileReader.readUInt16();
                this.offsets[n] = trueTypeFontFileReader.readUInt16();
                trueTypeFontFileReader.seek(this.offset + (long)this.cz + (long)this.offsets[n]);
                if (this.cA[n] == 1) {
                    this.names[n] = trueTypeFontFileReader.readByteString(this.bH[n]);
                } else if (this.cA[n] == 3) {
                    this.names[n] = trueTypeFontFileReader.readChars(this.bH[n] / 2);
                }
                switch (this.cC[n]) {
                    case 0: {
                        this.copyRightNotice = this.names[n];
                        break;
                    }
                    case 1: {
                        this.familyName = this.names[n];
                        break;
                    }
                    case 2: {
                        this.subFamilyName = this.names[n];
                        break;
                    }
                    case 4: {
                        this.fullName = this.names[n];
                        break;
                    }
                    case 6: {
                        this.fontName = this.names[n];
                    }
                }
                ++n;
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public final String toString() {
        String string = "[  copyRightNotice: " + this.copyRightNotice + "\n" + "  familyName: " + this.familyName + "\n" + "  subFamilyName: " + this.subFamilyName + "\n" + "  fullName: " + this.fullName + "\n" + "  fontName: " + this.fontName + "  ]";
        return string;
    }

    public String getCopyRightNotice() {
        return this.copyRightNotice;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFormat() {
        return this.cx;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getSubFamilyName() {
        return this.subFamilyName;
    }
}

