/*
 * Decompiled with CFR 0.152.
 */
package option.io.pdfcommon.document;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import option.io.pdfcommon.document.Body;
import option.io.pdfcommon.document.Header;
import option.io.pdfcommon.document.PdfDocumentInfo;
import option.io.pdfcommon.document.Trailer;
import option.io.pdfcommon.document.XrefReference;
import option.io.pdfcommon.document.XrefTable;
import option.io.pdfcommon.io.PdfOutFile;

public class PdfDocument {
    private Body body;
    private Header ap;
    private XrefTable aq;
    private Trailer ar;
    private PdfDocumentInfo as = new PdfDocumentInfo(this);
    private PdfOutFile at;

    public PdfDocument() {
        this.body = new Body(this);
        this.at = new PdfOutFile();
    }

    public Body getBody() {
        return this.body;
    }

    public XrefTable getXref() {
        return this.aq;
    }

    protected void setOutput() {
        this.ap = new Header();
        this.aq = new XrefTable();
        this.ar = new Trailer();
        this.body.add(this.as);
        this.aq.addElement(new XrefReference(0, 65535, false));
        this.ap.write(this.at);
        this.body.write(this.at);
        this.ar.setLocationOfXref(this.at.size());
        this.ar.setSize(this.aq.size());
        this.ar.setRoot(this.body.getCatalog());
        this.ar.setInfo(this.as);
        this.aq.write(this.at);
        this.ar.write(this.at);
    }

    public ByteArrayOutputStream getByteArrayOutputStream() {
        return this.at.getByteStream();
    }

    public byte[] getData() {
        return this.at.getData();
    }

    public void setData(byte[] byArray) {
        this.at.setData(byArray);
    }

    public void flush() {
        this.body.flush();
        this.at.flush();
    }

    public void close() {
        this.body.clear();
        this.at.close();
    }

    public boolean writeToFile() {
        this.setOutput();
        try {
            this.at.writeToFile();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void writeToStream(OutputStream outputStream) {
        this.setOutput();
        this.at.writeToStream(outputStream);
    }

    public void writeToFile(String string) {
        this.setOutput();
        this.at.writeToFile(string);
    }

    public PdfOutFile getOutputFile() {
        return this.at;
    }

    public void setOutputFile(PdfOutFile pdfOutFile) {
        this.at = pdfOutFile;
    }

    public PdfDocumentInfo getInfo() {
        return this.as;
    }

    public void setInfo(PdfDocumentInfo pdfDocumentInfo) {
        pdfDocumentInfo.setDocument(this);
        this.as = pdfDocumentInfo;
    }
}

