/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.searches.regiontree;

import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import jp.kitec.math.searches.regiontree.RectangleSupplier;
import jp.kitec.math.searches.regiontree.RegionTree;
import jp.kitec.math.searches.regiontree.RegionTreeBuilder;

public class TestRegionTree {
    public static void main(String[] stringArray) {
        TestRegionTree testRegionTree = new TestRegionTree();
        testRegionTree.test2();
    }

    public void test() {
        RegionTree regionTree = new RegionTree();
        RegionTreeBuilder regionTreeBuilder = new RegionTreeBuilder();
        Rect rect = new Rect();
        rect.x1 = 0.0;
        rect.x2 = 10.0;
        rect.y1 = 0.0;
        rect.y2 = 10.0;
        regionTreeBuilder.addNodes(rect);
        rect = new Rect();
        rect.x1 = 15.0;
        rect.x2 = 25.0;
        rect.y1 = 15.0;
        rect.y2 = 25.0;
        regionTreeBuilder.addNodes(rect);
        rect = new Rect();
        rect.x1 = 2.0;
        rect.x2 = 8.0;
        rect.y1 = 2.0;
        rect.y2 = 8.0;
        regionTreeBuilder.addNodes(rect);
        rect = new Rect();
        rect.x1 = 12.0;
        rect.x2 = 20.0;
        rect.y1 = 0.0;
        rect.y2 = 5.0;
        regionTreeBuilder.addNodes(rect);
        regionTreeBuilder.build(regionTree);
        Vector vector = new Vector(10, 10);
        int n = 0;
        while (n < vector.size()) {
            rect = (Rect)vector.get(n);
            System.out.println("(" + rect.x1 + ", " + rect.y1 + ")-(" + rect.x2 + ", " + rect.y2 + ")");
            ++n;
        }
    }

    public void test2() {
        Rect rect;
        int n;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        RegionTree regionTree = new RegionTree();
        RegionTreeBuilder regionTreeBuilder = new RegionTreeBuilder();
        int n2 = 100;
        int n3 = 100;
        simpleDateFormat.applyLocalizedPattern("kk:mm:ss.SSS");
        Date date = new Date();
        System.out.println("Data registering ! " + simpleDateFormat.format(date));
        int n4 = 0;
        while (n4 < n2) {
            n = 0;
            while (n < n3) {
                rect = new Rect();
                rect.x1 = n4 * 100;
                rect.y1 = n * 100;
                rect.x2 = (n4 + 1) * 100;
                rect.y2 = (n + 1) * 100;
                regionTreeBuilder.addNodes(rect);
                ++n;
            }
            ++n4;
        }
        date = new Date();
        System.out.println("Build start ! " + simpleDateFormat.format(date));
        regionTreeBuilder.build(regionTree);
        Vector vector = new Vector(100, 100);
        date = new Date();
        System.out.println("Search start ! " + simpleDateFormat.format(date));
        regionTree.search(vector, 50.0, 50.0, 150.0, 150.0);
        date = new Date();
        System.out.println("Search Ended !! " + simpleDateFormat.format(date));
        n = 0;
        while (n < vector.size()) {
            rect = (Rect)vector.get(n);
            System.out.println("(" + rect.x1 + ", " + rect.y1 + ")-(" + rect.x2 + ", " + rect.y2 + ")");
            ++n;
        }
    }

    public void test3() {
        Rect rect;
        int n;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        RegionTree regionTree = new RegionTree();
        RegionTreeBuilder regionTreeBuilder = new RegionTreeBuilder();
        int n2 = 100;
        int n3 = 100;
        simpleDateFormat.applyLocalizedPattern("kk:mm:ss.SSS");
        Date date = new Date();
        System.out.println("Data registering ! " + simpleDateFormat.format(date));
        int n4 = 0;
        while (n4 < n2) {
            n = 0;
            while (n < n3) {
                rect = new Rect();
                rect.x1 = n4 * 100;
                rect.y1 = n * 100;
                rect.x2 = (n4 + 2) * 100;
                rect.y2 = (n + 2) * 100;
                regionTreeBuilder.addNodes(rect);
                ++n;
            }
            ++n4;
        }
        date = new Date();
        System.out.println("Build start ! " + simpleDateFormat.format(date));
        regionTreeBuilder.build(regionTree);
        Vector vector = new Vector(100, 100);
        date = new Date();
        System.out.println("Search start ! " + simpleDateFormat.format(date));
        regionTree.search(vector, 5050.0, 5050.0, 5150.0, 5150.0);
        date = new Date();
        System.out.println("Search Ended !! " + simpleDateFormat.format(date));
        n = 0;
        while (n < vector.size()) {
            rect = (Rect)vector.get(n);
            System.out.println("(" + rect.x1 + ", " + rect.y1 + ")-(" + rect.x2 + ", " + rect.y2 + ")");
            ++n;
        }
    }

    public void test4() {
        Rect rect;
        int n;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        TreeSet<Rect> treeSet = new TreeSet<Rect>(new TestComp());
        int n2 = 20000;
        int n3 = 1;
        simpleDateFormat.applyLocalizedPattern("kk:mm:ss.SSS");
        Date date = new Date();
        System.out.println("Data registering ! " + simpleDateFormat.format(date));
        date = new Date();
        System.out.println("Registering start ! " + simpleDateFormat.format(date));
        int n4 = 0;
        while (n4 < n2) {
            n = 0;
            while (n < n3) {
                rect = new Rect();
                rect.x1 = n4 * 100;
                rect.y2 = 0.0;
                rect.x2 = 0.0;
                rect.y1 = 0.0;
                treeSet.add(rect);
                ++n;
            }
            ++n4;
        }
        date = new Date();
        System.out.println("Registering Ended !! " + simpleDateFormat.format(date));
        Iterator iterator = treeSet.iterator();
        date = new Date();
        System.out.println("Iterator made !! " + simpleDateFormat.format(date));
        n = 0;
        while (iterator.hasNext()) {
            rect = (Rect)iterator.next();
            ++n;
        }
        date = new Date();
        System.out.println("Finished !! " + simpleDateFormat.format(date));
    }

    public class Rect
    implements RectangleSupplier {
        double x1;
        double y1;
        double x2;
        double y2;

        public double getLeft() {
            return this.x1;
        }

        public double getRight() {
            return this.x2;
        }

        public double getLower() {
            return this.y1;
        }

        public double getUpper() {
            return this.y2;
        }
    }

    class TestComp
    implements Comparator {
        TestComp() {
        }

        public int compare(Object object, Object object2) {
            Rect rect = (Rect)object;
            Rect rect2 = (Rect)object2;
            if (rect.x1 < rect2.x1) {
                return -1;
            }
            if (rect.x1 > rect2.x1) {
                return 1;
            }
            return 0;
        }
    }
}

