/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.searches.regiontree;

import jp.kitec.math.searches.regiontree.RectangleSupplier;

public class RegionTreeNode {
    private RectangleSupplier node;
    private RegionTreeNode pairNode;
    private boolean bLowerLeft;
    private boolean checkFlag;

    public RegionTreeNode() {
        this.reset();
    }

    public void reset() {
        this.node = null;
        this.pairNode = null;
        this.checkFlag = false;
        this.bLowerLeft = false;
    }

    void setPairNode(RegionTreeNode regionTreeNode) {
        this.pairNode = regionTreeNode;
    }

    RegionTreeNode getPairNode() {
        return this.pairNode;
    }

    void set(RectangleSupplier rectangleSupplier) {
        this.node = rectangleSupplier;
    }

    RectangleSupplier getNode() {
        return this.node;
    }

    void setLowerLeft(boolean bl) {
        this.bLowerLeft = bl;
    }

    boolean isLowerLeft() {
        return this.bLowerLeft;
    }

    void setFlag(boolean bl) {
        this.checkFlag = bl;
    }

    boolean getFlag() {
        return this.checkFlag;
    }

    double getX() {
        return this.bLowerLeft ? this.node.getLeft() : this.node.getRight();
    }

    double getY() {
        return this.bLowerLeft ? this.node.getLower() : this.node.getUpper();
    }

    public double getCompareValue(int n) {
        if (n % 2 == 0) {
            return this.isLowerLeft() ? this.getNode().getLeft() : this.getNode().getRight();
        }
        return this.isLowerLeft() ? this.getNode().getLower() : this.getNode().getUpper();
    }
}

