/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.searches.binarytree;

import java.util.Vector;
import jp.kitec.math.searches.binarytree.BinaryTreeNode;

public abstract class BinaryTreeBuilder {
    protected Vector vectorAllNodes = new Vector(100, 100);
    protected int currentNode;
    private boolean ascent;

    public BinaryTreeBuilder() {
        this.reset();
        this.ascent = true;
    }

    public void reset() {
        this.currentNode = 0;
    }

    public BinaryTreeNode addNode(Object object) {
        BinaryTreeNode binaryTreeNode = null;
        if (this.currentNode < this.vectorAllNodes.size()) {
            binaryTreeNode = (BinaryTreeNode)this.vectorAllNodes.get(this.currentNode);
            binaryTreeNode.reset();
            ++this.currentNode;
        } else {
            binaryTreeNode = new BinaryTreeNode();
            this.vectorAllNodes.add(binaryTreeNode);
            ++this.currentNode;
        }
        binaryTreeNode.set(object);
        return binaryTreeNode;
    }

    public void setAscent(boolean bl) {
        this.ascent = bl;
    }

    public boolean getAscent() {
        return this.ascent;
    }

    public int getNodeCount() {
        return this.currentNode;
    }

    public abstract void build();

    public BinaryTreeNode getNode(int n) {
        return (BinaryTreeNode)this.vectorAllNodes.get(n);
    }
}

