/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.logicaloperation;

import java.util.Vector;
import jp.kitec.math.geom.datapassing.ToolPolyline2D;
import jp.kitec.math.geom.datapassing.ToolPolyline2DCollection;
import jp.kitec.math.geom.datapassing.plane.ToolPlane2D;
import jp.kitec.math.geom.datapassing.polylines.ToolGeomPolyline2D;
import jp.kitec.math.geom.logicaloperation.CrossPointChecker;
import jp.kitec.math.geom.logicaloperation.CrossPolylineGroup;
import jp.kitec.math.geom.logicaloperation.InOutChecker;
import jp.kitec.math.geom.logicaloperation.InOutVertexTracking;
import jp.kitec.math.geom.logicaloperation.IntersectRegionSort;
import jp.kitec.math.geom.logicaloperation.OverlapDeterminater;
import jp.kitec.math.geom.logicaloperation.PolylineManager;
import jp.kitec.math.geom.logicaloperation.crossway.CrossWayDeterminater;
import jp.kitec.math.geom.logicaloperation.inoutdeterm.CrossChecker;
import jp.kitec.math.searches.binarysort.BinarySortBuilder;

public class ToolPlaneLogic {
    public static final int COMBINATION_ONE_GROUP = 1;
    public static final int COMBINATION_TWO_GROUP = 2;
    public static final int COMBINATION_SAME_GROUP = 3;
    public static final int COMBINATION_NONE = 4;
    public static final int COMBINATION_ALL = 5;
    CrossPointChecker crossPointChecker;
    BinarySortBuilder builder;
    OverlapDeterminater determinater;
    InOutChecker inoutChecker;
    Vector vectorPointTracer;
    Vector vectorDoubledPlane;
    Vector vectorDoubledSurface;

    public ToolPlaneLogic(CrossPointChecker crossPointChecker, OverlapDeterminater overlapDeterminater, InOutChecker inOutChecker) {
        this.crossPointChecker = crossPointChecker;
        this.determinater = overlapDeterminater;
        this.builder = new BinarySortBuilder();
        this.inoutChecker = inOutChecker;
        this.vectorPointTracer = new Vector(10, 10);
        this.vectorDoubledPlane = new Vector(10, 10);
        this.vectorDoubledSurface = new Vector(10, 10);
    }

    public ToolPlaneLogic() {
        this(new CrossChecker(), new CrossWayDeterminater(), new InOutVertexTracking());
    }

    public void clear() {
        this.builder.reset();
    }

    public void clear(ToolPolyline2DCollection toolPolyline2DCollection) {
        int n = 0;
        while (n < toolPolyline2DCollection.size()) {
            ToolPolyline2D toolPolyline2D = toolPolyline2DCollection.get(n);
            PolylineManager polylineManager = (PolylineManager)toolPolyline2D.get(4096);
            polylineManager.reset();
            ++n;
        }
    }

    public boolean processForEach(ToolPolyline2DCollection toolPolyline2DCollection) {
        this.preprocess(toolPolyline2DCollection);
        if (!this.crossPointChecker.searchForEach(toolPolyline2DCollection)) {
            return false;
        }
        if (!this.determinater.process(toolPolyline2DCollection)) {
            return false;
        }
        if (!this.inoutChecker.process(toolPolyline2DCollection)) {
            return false;
        }
        this.postprocess(toolPolyline2DCollection);
        return true;
    }

    public boolean process(ToolPolyline2DCollection toolPolyline2DCollection) {
        this.preprocess(toolPolyline2DCollection);
        if (!this.crossPointChecker.search(toolPolyline2DCollection)) {
            return false;
        }
        if (!this.determinater.process(toolPolyline2DCollection)) {
            return false;
        }
        if (!this.inoutChecker.process(toolPolyline2DCollection)) {
            return false;
        }
        this.postprocess(toolPolyline2DCollection);
        return true;
    }

    public boolean process(ToolPolyline2DCollection toolPolyline2DCollection, ToolPolyline2DCollection toolPolyline2DCollection2) {
        this.preprocess(toolPolyline2DCollection, toolPolyline2DCollection2);
        if (!this.crossPointChecker.search(toolPolyline2DCollection)) {
            return false;
        }
        if (!this.crossPointChecker.search(toolPolyline2DCollection, toolPolyline2DCollection2)) {
            return false;
        }
        if (!this.determinater.process(toolPolyline2DCollection)) {
            return false;
        }
        if (!this.determinater.process(toolPolyline2DCollection2)) {
            return false;
        }
        if (!this.inoutChecker.process(toolPolyline2DCollection)) {
            return false;
        }
        if (!this.inoutChecker.process(toolPolyline2DCollection2)) {
            return false;
        }
        if (!this.inoutChecker.process(toolPolyline2DCollection, toolPolyline2DCollection2)) {
            return false;
        }
        if (!this.inoutChecker.process(toolPolyline2DCollection2, toolPolyline2DCollection)) {
            return false;
        }
        this.postprocess(toolPolyline2DCollection, toolPolyline2DCollection2);
        return true;
    }

    void preprocess(ToolPolyline2DCollection toolPolyline2DCollection) {
        int n = 0;
        while (n < toolPolyline2DCollection.size()) {
            ToolPolyline2D toolPolyline2D = toolPolyline2DCollection.get(n);
            PolylineManager polylineManager = (PolylineManager)toolPolyline2D.get(4096);
            if (polylineManager == null) {
                polylineManager = new PolylineManager(this.builder, toolPolyline2D);
                toolPolyline2D.put(polylineManager);
                int n2 = ToolPlane2D.getDirection(toolPolyline2D);
                polylineManager.setCw(n2 == 1);
                switch (toolPolyline2D.getRegion()) {
                    case 3: {
                        polylineManager.setRegion((byte)(n2 != 0 ? (n2 == 1 ? 1 : 2) : 0));
                        break;
                    }
                    case 4: {
                        polylineManager.setRegion((byte)(n2 != 0 ? (n2 != 1 ? 1 : 2) : 0));
                        break;
                    }
                    case 1: {
                        polylineManager.setRegion((byte)1);
                        break;
                    }
                    case 2: {
                        polylineManager.setRegion((byte)2);
                        break;
                    }
                    default: {
                        if (ToolGeomPolyline2D.isClosed(toolPolyline2D)) {
                            polylineManager.setRegion(n2 == 1 ? (byte)1 : 2);
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else {
                byte by = polylineManager.getRegion();
                polylineManager.reset();
                polylineManager.setCw(ToolPlane2D.getDirection(toolPolyline2D) == 1);
                polylineManager.setRegion(by);
            }
            ++n;
        }
    }

    void preprocess(ToolPolyline2DCollection toolPolyline2DCollection, ToolPolyline2DCollection toolPolyline2DCollection2) {
        this.preprocess(toolPolyline2DCollection);
        this.preprocess(toolPolyline2DCollection2);
    }

    void postprocess(ToolPolyline2DCollection toolPolyline2DCollection) {
        this.setPreviousStatus(toolPolyline2DCollection);
        this.setTatchedSurfaceFlag(toolPolyline2DCollection, false);
        this.setTemporaryIncludeLevel(toolPolyline2DCollection, 1, false);
        this.levelIncludeLevel(toolPolyline2DCollection, 1, false);
        this.addIncludeLevel(toolPolyline2DCollection, false);
    }

    void postprocess(ToolPolyline2DCollection toolPolyline2DCollection, ToolPolyline2DCollection toolPolyline2DCollection2) {
        this.setPreviousStatus(toolPolyline2DCollection);
        this.setPreviousStatus(toolPolyline2DCollection2);
        this.setTatchedSurfaceFlag(toolPolyline2DCollection, false);
        this.setTatchedSurfaceFlag(toolPolyline2DCollection2, false);
        this.setTemporaryIncludeLevel(toolPolyline2DCollection, 2, false);
        this.setTemporaryIncludeLevel(toolPolyline2DCollection2, 4, false);
        this.levelIncludeLevel(toolPolyline2DCollection, 2, false);
        this.addIncludeLevel(toolPolyline2DCollection, false);
        this.addIncludeLevel(toolPolyline2DCollection2, false);
    }

    boolean checkCombination(ToolPolyline2DCollection toolPolyline2DCollection, ToolPolyline2D toolPolyline2D, ToolPolyline2D toolPolyline2D2, int n) {
        switch (n) {
            case 4: {
                return false;
            }
            case 5: {
                return true;
            }
            case 3: {
                ToolPolyline2DCollection toolPolyline2DCollection2 = toolPolyline2D2.getParent();
                if (toolPolyline2DCollection == toolPolyline2DCollection2) {
                    int n2;
                    int n3 = toolPolyline2D.getIndex();
                    if (n3 < (n2 = toolPolyline2D2.getIndex())) {
                        return true;
                    }
                    if (n3 == n2) {
                        return toolPolyline2D.hashCode() < toolPolyline2D2.hashCode();
                    }
                    return false;
                }
                return false;
            }
            case 2: {
                ToolPolyline2DCollection toolPolyline2DCollection3 = toolPolyline2D2.getParent();
                if (toolPolyline2DCollection != toolPolyline2DCollection3) {
                    return true;
                }
            }
            case 1: {
                int n4 = toolPolyline2D.getIndex();
                int n5 = toolPolyline2D2.getIndex();
                if (n4 < n5) {
                    return true;
                }
                if (n4 == n5) {
                    return toolPolyline2D.hashCode() < toolPolyline2D2.hashCode();
                }
                return false;
            }
        }
        return false;
    }

    public static byte getCrossStatus(ToolPolyline2D toolPolyline2D, byte by, boolean bl) {
        if (bl) {
            return by;
        }
        if (toolPolyline2D.getRegion() == 4) {
            switch (by) {
                case 1: {
                    by = (byte)2;
                    break;
                }
                case 2: {
                    by = 1;
                }
            }
        }
        return by;
    }

    void setPreviousStatus(ToolPolyline2DCollection toolPolyline2DCollection) {
        int n = 1;
        int n2 = 0;
        while (n2 < toolPolyline2DCollection.size()) {
            ToolPolyline2D toolPolyline2D = toolPolyline2DCollection.get(n2);
            PolylineManager polylineManager = (PolylineManager)toolPolyline2D.get(4096);
            if (polylineManager.size() != 0) {
                boolean bl = ToolGeomPolyline2D.isClosed(toolPolyline2D);
                this.vectorDoubledPlane.clear();
                this.vectorDoubledSurface.clear();
                int n3 = n;
                IntersectRegionSort intersectRegionSort = polylineManager.getFirst();
                while (true) {
                    if (intersectRegionSort == null) {
                        intersectRegionSort = polylineManager.getFirst();
                        if (n3 == 0) break;
                        --n3;
                    }
                    IntersectRegionSort intersectRegionSort2 = intersectRegionSort.samePointsRoot;
                    while (intersectRegionSort2 != null) {
                        ToolPolyline2D toolPolyline2D2 = intersectRegionSort2.pair.figure.getParent();
                        boolean bl2 = false;
                        int n4 = 0;
                        while (n4 < this.vectorDoubledPlane.size()) {
                            IntersectRegionSort intersectRegionSort3 = (IntersectRegionSort)this.vectorDoubledPlane.get(n4);
                            if (intersectRegionSort3.pair.figure.getParent() == toolPolyline2D2) {
                                if (bl || n3 == n) {
                                    intersectRegionSort2.crossPrevStatus = intersectRegionSort3.crossStatus;
                                } else if (intersectRegionSort2.crossPrevStatus == 0) {
                                    switch (intersectRegionSort2.crossStatus) {
                                        case 1: {
                                            intersectRegionSort2.crossPrevStatus = (byte)2;
                                            break;
                                        }
                                        case 2: {
                                            intersectRegionSort2.crossPrevStatus = 1;
                                        }
                                    }
                                }
                                this.vectorDoubledPlane.set(n4, intersectRegionSort2);
                                bl2 = true;
                                break;
                            }
                            ++n4;
                        }
                        if (!bl2) {
                            this.vectorDoubledPlane.add(intersectRegionSort2);
                        }
                        intersectRegionSort2 = intersectRegionSort2.samePointsNext;
                    }
                    intersectRegionSort = polylineManager.getNext(intersectRegionSort);
                }
            }
            ++n2;
        }
    }

    void setTatchedSurfaceFlag(ToolPolyline2DCollection toolPolyline2DCollection, boolean bl) {
        int n = 1;
        int n2 = 0;
        while (n2 < toolPolyline2DCollection.size()) {
            ToolPolyline2D toolPolyline2D = toolPolyline2DCollection.get(n2);
            PolylineManager polylineManager = (PolylineManager)toolPolyline2D.get(4096);
            if (polylineManager.size() != 0) {
                this.vectorDoubledSurface.clear();
                int n3 = n;
                IntersectRegionSort intersectRegionSort = polylineManager.getFirst();
                while (true) {
                    if (intersectRegionSort == null) {
                        if (n3 == 0 || this.vectorDoubledSurface.size() == 0) break;
                        intersectRegionSort = polylineManager.getFirst();
                        --n3;
                    }
                    IntersectRegionSort intersectRegionSort2 = intersectRegionSort.samePointsRoot;
                    while (intersectRegionSort2 != null) {
                        ToolPolyline2D toolPolyline2D2 = intersectRegionSort2.pair.figure.getParent();
                        byte by = intersectRegionSort2.crossPrevStatus;
                        byte by2 = intersectRegionSort2.crossStatus;
                        byte by3 = intersectRegionSort2.pair.crossPrevStatus;
                        byte by4 = intersectRegionSort2.pair.crossStatus;
                        if (by == 3 && by2 != 3) {
                            int n4 = 0;
                            while (n4 < this.vectorDoubledSurface.size()) {
                                IntersectRegionSort intersectRegionSort3 = (IntersectRegionSort)this.vectorDoubledSurface.get(n4);
                                if (intersectRegionSort3.pair.figure.getParent() == toolPolyline2D2) {
                                    while (intersectRegionSort3 != intersectRegionSort2.samePointsRoot) {
                                        intersectRegionSort3.setSurface(true);
                                        intersectRegionSort3 = IntersectRegionSort.getNextNode(intersectRegionSort3, true);
                                    }
                                    this.vectorDoubledSurface.remove(n4);
                                    break;
                                }
                                ++n4;
                            }
                        } else if ((by == 2 || by == 1) && by2 == 3 && (by == by3 && by4 == 3 || by == by4 && by3 == 3)) {
                            this.vectorDoubledSurface.add(intersectRegionSort2);
                        }
                        intersectRegionSort2 = intersectRegionSort2.samePointsNext;
                    }
                    intersectRegionSort = polylineManager.getNext(intersectRegionSort);
                }
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void setTemporaryIncludeLevel(ToolPolyline2DCollection toolPolyline2DCollection, int n, boolean bl) {
        int n2 = 0;
        while (n2 < toolPolyline2DCollection.size()) {
            ToolPolyline2D toolPolyline2D = toolPolyline2DCollection.get(n2);
            PolylineManager polylineManager = (PolylineManager)toolPolyline2D.get(4096);
            this.vectorDoubledPlane.clear();
            this.vectorDoubledSurface.clear();
            int n3 = 0;
            int n4 = Short.MAX_VALUE;
            IntersectRegionSort intersectRegionSort = polylineManager.getFirst();
            while (intersectRegionSort != null) {
                IntersectRegionSort intersectRegionSort2 = intersectRegionSort.samePointsRoot;
                while (intersectRegionSort2 != null) {
                    block16: {
                        ToolPolyline2D toolPolyline2D2 = intersectRegionSort2.pair.figure.getParent();
                        byte by = intersectRegionSort2.crossStatus;
                        byte by2 = intersectRegionSort2.crossPrevStatus;
                        switch (by) {
                            case 1: {
                                if (by2 != 1) {
                                    if (this.vectorDoubledPlane.contains(toolPolyline2D2)) {
                                        this.vectorDoubledPlane.remove(toolPolyline2D2);
                                    }
                                    n3 = (short)(n3 + 1);
                                    break;
                                }
                                break block16;
                            }
                            case 2: {
                                if (by2 != 2) {
                                    if (this.vectorDoubledPlane.contains(toolPolyline2D2)) {
                                        this.vectorDoubledPlane.remove(toolPolyline2D2);
                                    }
                                    if (by2 != 1) break;
                                    n3 = (short)(n3 - 1);
                                    break;
                                }
                                break block16;
                            }
                            case 3: {
                                if (by2 == 1) {
                                    n3 = (short)(n3 - 1);
                                }
                                if (intersectRegionSort2.getSurface() || !this.checkCombination(toolPolyline2DCollection, toolPolyline2D, toolPolyline2D2, n) || this.vectorDoubledPlane.contains(toolPolyline2D2)) break;
                                this.vectorDoubledPlane.add(toolPolyline2D2);
                                break;
                            }
                            case 0: {
                                if (by2 != 3 || !this.vectorDoubledPlane.contains(toolPolyline2D2)) break;
                                this.vectorDoubledPlane.remove(toolPolyline2D2);
                            }
                        }
                        if (n3 < n4) {
                            n4 = n3;
                        }
                    }
                    intersectRegionSort2 = intersectRegionSort2.samePointsNext;
                }
                intersectRegionSort.setLevel((short)n3, bl);
                intersectRegionSort.setDoubled((short)(intersectRegionSort.getDoubled() + this.vectorDoubledPlane.size()));
                intersectRegionSort = polylineManager.getNext(intersectRegionSort);
            }
            if (n4 < 0) {
                this.adjustLevel(polylineManager, (short)(-n4), bl);
            }
            ++n2;
        }
    }

    void levelIncludeLevel(ToolPolyline2DCollection toolPolyline2DCollection, int n, boolean bl) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < toolPolyline2DCollection.size()) {
            ToolPolyline2D toolPolyline2D = toolPolyline2DCollection.get(n5);
            PolylineManager polylineManager = (PolylineManager)toolPolyline2D.get(4096);
            CrossPolylineGroup crossPolylineGroup = polylineManager.getGroup();
            if (crossPolylineGroup != null && crossPolylineGroup.getFirst() == toolPolyline2D) {
                n3 = 0;
                n4 = 0;
                ToolPolyline2D[] toolPolyline2DArray = crossPolylineGroup.getAllPolyline();
                do {
                    if (n3 >= n2) {
                        if (n4 >= 3) break;
                        ++n4;
                    } else {
                        n3 = n2;
                        n4 = 0;
                    }
                    n2 = 0;
                    int n6 = 0;
                    while (n6 < toolPolyline2DArray.length) {
                        ToolPolyline2D toolPolyline2D2 = toolPolyline2DArray[n6];
                        polylineManager = (PolylineManager)toolPolyline2D2.get(4096);
                        this.vectorDoubledPlane.clear();
                        IntersectRegionSort intersectRegionSort = polylineManager.getFirst();
                        while (intersectRegionSort != null) {
                            short s = intersectRegionSort.getLevel(bl);
                            IntersectRegionSort intersectRegionSort2 = intersectRegionSort.samePointsRoot;
                            while (intersectRegionSort2 != null) {
                                ToolPolyline2D toolPolyline2D3 = intersectRegionSort.pair.figure.getParent();
                                if (this.checkCombination(toolPolyline2DCollection, toolPolyline2D2, toolPolyline2D3, n)) {
                                    short s2 = intersectRegionSort2.pair.getLevel(bl);
                                    short s3 = this.getOuterPartLevel(toolPolyline2D2, intersectRegionSort2.samePointsRoot, bl);
                                    short s4 = this.getOuterPartLevel(toolPolyline2D3, intersectRegionSort2.pair.samePointsRoot, bl);
                                    short s5 = (short)(s - s3);
                                    short s6 = (short)(s2 - s4);
                                    toolPolyline2D2.getIndex();
                                    toolPolyline2D3.getIndex();
                                    if (s5 > s6) {
                                        PolylineManager polylineManager2 = (PolylineManager)toolPolyline2D3.get(4096);
                                        this.adjustLevel(polylineManager2, (short)(s5 - s6), bl);
                                        ++n2;
                                    } else if (s5 < s6) {
                                        this.adjustLevel(polylineManager, (short)(s6 - s5), bl);
                                        ++n2;
                                    }
                                }
                                intersectRegionSort2 = intersectRegionSort2.samePointsNext;
                            }
                            intersectRegionSort = polylineManager.getNext(intersectRegionSort);
                        }
                        ++n6;
                    }
                } while (n2 > 0);
                this.searchOuterPolygon(crossPolylineGroup, bl);
            }
            ++n5;
        }
    }

    private short getOuterPartLevel(ToolPolyline2D toolPolyline2D, IntersectRegionSort intersectRegionSort, boolean bl) {
        short s = 0;
        IntersectRegionSort intersectRegionSort2 = intersectRegionSort;
        while (intersectRegionSort2 != null) {
            intersectRegionSort2.pair.figure.getParent();
            byte by = intersectRegionSort2.crossStatus;
            switch (by) {
                case 1: {
                    if (this.vectorDoubledPlane.contains(intersectRegionSort2.pair.figure.getParent())) {
                        this.vectorDoubledPlane.remove(intersectRegionSort2.pair.figure.getParent());
                    }
                    s = (short)(s + 1);
                    break;
                }
                case 2: {
                    if (!this.vectorDoubledPlane.contains(intersectRegionSort2.pair.figure.getParent())) break;
                    this.vectorDoubledPlane.remove(intersectRegionSort2.pair.figure.getParent());
                    break;
                }
            }
            intersectRegionSort2 = intersectRegionSort2.samePointsNext;
        }
        return s;
    }

    private void adjustLevel(PolylineManager polylineManager, short s, boolean bl) {
        IntersectRegionSort intersectRegionSort = polylineManager.getFirst();
        while (intersectRegionSort != null) {
            intersectRegionSort.setLevel((short)(intersectRegionSort.getLevel(bl) + s), bl);
            intersectRegionSort = polylineManager.getNext(intersectRegionSort);
        }
    }

    private void searchOuterPolygon(CrossPolylineGroup crossPolylineGroup, boolean bl) {
        PolylineManager polylineManager = (PolylineManager)crossPolylineGroup.getFirst().get(4096);
        IntersectRegionSort intersectRegionSort = polylineManager.getFirst();
        IntersectRegionSort intersectRegionSort2 = null;
        IntersectRegionSort intersectRegionSort3 = null;
        short s = 0;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        this.vectorPointTracer.clear();
        block0: while (intersectRegionSort != null) {
            int n;
            if (intersectRegionSort3 == null && this.vectorPointTracer.contains(intersectRegionSort)) {
                intersectRegionSort3 = intersectRegionSort;
            } else if (intersectRegionSort == intersectRegionSort3) break;
            if (intersectRegionSort3 != null && intersectRegionSort.figure.getParent().getRegion() == 4) {
                bl3 = true;
            }
            if (intersectRegionSort3 != null && intersectRegionSort.figure.getParent().getRegion() == 3 && (bl2 && intersectRegionSort.crossStatus != 3 || !bl2 && intersectRegionSort.crossPrevStatus != 3)) {
                bl4 = true;
            }
            if (intersectRegionSort3 == null) {
                this.vectorPointTracer.add(intersectRegionSort);
            }
            if (intersectRegionSort3 != null && intersectRegionSort2 != null && bl2 && intersectRegionSort2.samePointsRoot.getLevel(bl) > s) {
                s = intersectRegionSort2.samePointsRoot.getLevel(bl);
            } else if (intersectRegionSort3 != null && !bl2 && intersectRegionSort.samePointsRoot.getLevel(bl) > s) {
                s = intersectRegionSort.samePointsRoot.getLevel(bl);
            }
            if (intersectRegionSort.crossStatus == 0 && intersectRegionSort.crossPrevStatus == 0) continue;
            ToolPolyline2D toolPolyline2D = intersectRegionSort.figure.getParent();
            IntersectRegionSort intersectRegionSort4 = intersectRegionSort.samePointsRoot;
            while (intersectRegionSort4 != null) {
                n = this.checkAllCrossStatus(toolPolyline2D, intersectRegionSort4.pair);
                if (n != 0) {
                    intersectRegionSort2 = intersectRegionSort4.pair.samePointsRoot;
                    if (n < 0) {
                        intersectRegionSort = IntersectRegionSort.getPrevNode(intersectRegionSort4.pair, true);
                        bl2 = false;
                        continue block0;
                    }
                    intersectRegionSort = IntersectRegionSort.getNextNode(intersectRegionSort4.pair, true);
                    bl2 = true;
                    continue block0;
                }
                intersectRegionSort4 = intersectRegionSort4.samePointsNext;
            }
            n = this.checkAllCrossStatus(toolPolyline2D, intersectRegionSort.samePointsRoot);
            if (n != 0) {
                intersectRegionSort2 = intersectRegionSort.samePointsRoot;
                if (n < 0) {
                    intersectRegionSort = IntersectRegionSort.getPrevNode(intersectRegionSort.samePointsRoot, true);
                    bl2 = false;
                    continue;
                }
                intersectRegionSort = IntersectRegionSort.getNextNode(intersectRegionSort.samePointsRoot, true);
                bl2 = true;
                continue;
            }
            intersectRegionSort4 = intersectRegionSort.samePointsRoot;
            while (intersectRegionSort4 != null) {
                if (intersectRegionSort4.pair.samePointsRoot.getLevel(bl) == 0) {
                    intersectRegionSort = intersectRegionSort4.pair.samePointsRoot;
                    continue block0;
                }
                intersectRegionSort4 = intersectRegionSort4.samePointsNext;
            }
            intersectRegionSort = IntersectRegionSort.getNextNode(intersectRegionSort.samePointsRoot, true);
        }
        crossPolylineGroup.setMaxLevel(s);
        crossPolylineGroup.regionInside = !bl3;
        crossPolylineGroup.innerRegionFound = bl4;
        crossPolylineGroup.outerMostPoint = intersectRegionSort3;
    }

    int checkAllCrossStatus(ToolPolyline2D toolPolyline2D, IntersectRegionSort intersectRegionSort) {
        int n = 0;
        int n2 = 0;
        IntersectRegionSort intersectRegionSort2 = intersectRegionSort;
        while (intersectRegionSort2 != null) {
            byte by = ToolPlaneLogic.getCrossStatus(toolPolyline2D, intersectRegionSort2.crossPrevStatus, false);
            byte by2 = ToolPlaneLogic.getCrossStatus(toolPolyline2D, intersectRegionSort2.crossStatus, false);
            if (n == 0) {
                n = by;
            } else if (by == 1) {
                n = by;
            }
            if (n2 == 0) {
                n2 = by2;
            } else if (by2 == 1) {
                n2 = by2;
            }
            intersectRegionSort2 = intersectRegionSort2.samePointsNext;
        }
        if (n2 == 2) {
            return 1;
        }
        if (n == 2) {
            return -1;
        }
        return 0;
    }

    void addIncludeLevel(ToolPolyline2DCollection toolPolyline2DCollection, boolean bl) {
        int n = 0;
        while (n < toolPolyline2DCollection.size()) {
            ToolPolyline2D toolPolyline2D = toolPolyline2DCollection.get(n);
            PolylineManager polylineManager = (PolylineManager)toolPolyline2D.get(4096);
            CrossPolylineGroup crossPolylineGroup = polylineManager.getGroup();
            if (crossPolylineGroup != null) {
                int n2;
                if (crossPolylineGroup != null) {
                    n2 = crossPolylineGroup.getIncludedLevel();
                    if (ToolGeomPolyline2D.isClosed(toolPolyline2D)) {
                        n2 -= crossPolylineGroup.getMaxLevel();
                    }
                    if (!crossPolylineGroup.regionInside) {
                        --n2;
                        if (crossPolylineGroup.innerRegionFound) {
                            ++n2;
                        }
                    }
                } else {
                    n2 = polylineManager.getIncludedLevel();
                }
                IntersectRegionSort intersectRegionSort = polylineManager.getFirst();
                while (intersectRegionSort != null) {
                    intersectRegionSort.setLevel((short)(intersectRegionSort.getLevel(bl) + n2), bl);
                    intersectRegionSort.setLevel((short)(intersectRegionSort.getLevel(bl) + intersectRegionSort.getDoubled()), bl);
                    intersectRegionSort = polylineManager.getNext(intersectRegionSort);
                }
            }
            ++n;
        }
    }
}

