/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.logicaloperation;

import jp.kitec.math.geom.datapassing.ToolAdditData;
import jp.kitec.math.geom.datapassing.ToolFigure2D;
import jp.kitec.math.geom.datapassing.ToolPolyline2D;
import jp.kitec.math.geom.logicaloperation.CrossPolylineGroup;
import jp.kitec.math.geom.logicaloperation.IntersectRegionSort;
import jp.kitec.math.searches.NodeComparator;
import jp.kitec.math.searches.binarysort.BinarySort;
import jp.kitec.math.searches.binarysort.BinarySortBuilder;
import jp.kitec.math.searches.binarytree.BinaryTreeNode;

public class PolylineManager
implements ToolAdditData {
    public static final byte REGION_NONE = 0;
    public static final byte REGION_RIGHT = 1;
    public static final byte REGION_LEFT = 2;
    private IntersectRegionComparator comparator = new IntersectRegionComparator();
    private BinarySort intersectRegionSort;
    private boolean cw;
    private byte region;
    private boolean includeInnerRegionPlane;
    private boolean includeOuterRegionPlane;
    private int includedLevel;
    private CrossPolylineGroup group;
    private ToolPolyline2D polyline;

    public PolylineManager(BinarySortBuilder binarySortBuilder, ToolPolyline2D toolPolyline2D) {
        this.intersectRegionSort = new BinarySort(this.comparator, binarySortBuilder);
        this.polyline = toolPolyline2D;
        this.init();
    }

    public void reset() {
        this.init();
        this.intersectRegionSort.clearNodes();
    }

    public void init() {
        this.cw = true;
        this.region = 0;
        this.includeOuterRegionPlane = false;
        this.includeInnerRegionPlane = false;
        this.includedLevel = 0;
        this.group = null;
    }

    public int getKey() {
        return 4096;
    }

    public IntersectRegionSort get(double d) {
        BinaryTreeNode binaryTreeNode = this.intersectRegionSort.search(d);
        if (binaryTreeNode == null) {
            return null;
        }
        return (IntersectRegionSort)binaryTreeNode.get();
    }

    public IntersectRegionSort getFirst() {
        return (IntersectRegionSort)this.intersectRegionSort.getFirst();
    }

    public IntersectRegionSort getNext() {
        return (IntersectRegionSort)this.intersectRegionSort.getNext();
    }

    public IntersectRegionSort getPrev(IntersectRegionSort intersectRegionSort) {
        return (IntersectRegionSort)this.intersectRegionSort.getPrev(intersectRegionSort);
    }

    public IntersectRegionSort getNext(IntersectRegionSort intersectRegionSort) {
        return (IntersectRegionSort)this.intersectRegionSort.getNext(intersectRegionSort);
    }

    public IntersectRegionSort getTop() {
        return (IntersectRegionSort)this.intersectRegionSort.getLeftMost();
    }

    public IntersectRegionSort getBottom() {
        return (IntersectRegionSort)this.intersectRegionSort.getRightMost();
    }

    public void setCw(boolean bl) {
        this.cw = bl;
    }

    public boolean isCw() {
        return this.cw;
    }

    public void setRegion(byte by) {
        this.region = by;
    }

    public byte getRegion() {
        return this.region;
    }

    public boolean isRegionInside() {
        return this.region != 0 && this.cw == (this.region == 1);
    }

    public void setIncludeInnerRegionPlane(boolean bl) {
        this.includeInnerRegionPlane = bl;
    }

    public boolean checkIncludeInnerRegionPlane() {
        return this.includeInnerRegionPlane;
    }

    public void setIncludeOuterRegionPlane(boolean bl) {
        this.includeOuterRegionPlane = bl;
    }

    public boolean checkIncludeOuterRegionPlane() {
        return this.includeOuterRegionPlane;
    }

    public IntersectRegionSort add(ToolFigure2D toolFigure2D, double d, double d2, double d3) {
        IntersectRegionSort intersectRegionSort = new IntersectRegionSort();
        intersectRegionSort.figure = toolFigure2D;
        intersectRegionSort.x = d;
        intersectRegionSort.y = d2;
        intersectRegionSort.parameterOfFigure = d3;
        intersectRegionSort.samePointsRoot = intersectRegionSort;
        this.intersectRegionSort.add(intersectRegionSort);
        return intersectRegionSort;
    }

    public int size() {
        return this.intersectRegionSort.getNodeCount();
    }

    public ToolPolyline2D getPolyline() {
        return this.polyline;
    }

    public CrossPolylineGroup getGroup() {
        return this.group;
    }

    public void setGroup(CrossPolylineGroup crossPolylineGroup) {
        this.group = crossPolylineGroup;
    }

    public CrossPolylineGroup addGroup(PolylineManager polylineManager) {
        CrossPolylineGroup crossPolylineGroup = this.group;
        CrossPolylineGroup crossPolylineGroup2 = polylineManager.group;
        if (crossPolylineGroup != null && crossPolylineGroup == crossPolylineGroup2 || this == polylineManager) {
            return crossPolylineGroup;
        }
        if (crossPolylineGroup == null && crossPolylineGroup2 != null) {
            crossPolylineGroup2.add(this);
            this.group = polylineManager.group;
            return crossPolylineGroup2;
        }
        if (crossPolylineGroup != null && crossPolylineGroup2 == null) {
            crossPolylineGroup.add(polylineManager);
            polylineManager.group = this.group;
            return crossPolylineGroup;
        }
        if (crossPolylineGroup != null && crossPolylineGroup2 != null) {
            crossPolylineGroup.integrate(crossPolylineGroup2);
            polylineManager.group = this.group;
            return this.group;
        }
        this.group = polylineManager.group = new CrossPolylineGroup();
        this.group.add(this);
        this.group.add(polylineManager);
        return this.group;
    }

    public void addIncludedLevel(int n) {
        this.includedLevel += n;
    }

    public int getIncludedLevel() {
        return this.includedLevel;
    }

    class IntersectRegionComparator
    implements NodeComparator {
        static final double TOLERANCE = 1.0E-8;

        IntersectRegionComparator() {
        }

        int compareParameter(double d, double d2) {
            if (Math.abs(d - d2) <= 1.0E-8) {
                return 0;
            }
            if (d > d2) {
                return 1;
            }
            return -1;
        }

        public int compare(Object object, Object object2) {
            IntersectRegionSort intersectRegionSort = (IntersectRegionSort)object;
            IntersectRegionSort intersectRegionSort2 = (IntersectRegionSort)object2;
            return this.compareParameter(intersectRegionSort.parameterOfFigure, intersectRegionSort2.parameterOfFigure);
        }

        public int compare(Object object, double d) {
            IntersectRegionSort intersectRegionSort = (IntersectRegionSort)object;
            return this.compareParameter(intersectRegionSort.parameterOfFigure, d);
        }

        public boolean addSameValue(Object object, Object object2) {
            IntersectRegionSort intersectRegionSort = (IntersectRegionSort)object;
            IntersectRegionSort intersectRegionSort2 = (IntersectRegionSort)object2;
            if (intersectRegionSort.samePointsNext == null) {
                intersectRegionSort.samePointsNext = intersectRegionSort2;
                intersectRegionSort.samePointsRoot = intersectRegionSort2.samePointsRoot = intersectRegionSort;
            } else {
                intersectRegionSort2.samePointsNext = intersectRegionSort.samePointsNext.samePointsNext;
                intersectRegionSort.samePointsNext.samePointsNext = intersectRegionSort2;
                intersectRegionSort2.samePointsRoot = intersectRegionSort;
            }
            return true;
        }
    }
}

