/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.logicaloperation;

import jp.kitec.math.geom.ToolGeom2D;
import jp.kitec.math.geom.datapassing.ToolFigure2D;
import jp.kitec.math.geom.datapassing.ToolPolyline2D;
import jp.kitec.math.geom.datapassing.plane.ToolPlane2D;
import jp.kitec.math.geom.logicaloperation.IntersectRegionSort;
import jp.kitec.math.geom.logicaloperation.PolylineManager;
import jp.kitec.math.searches.regiontree.RectangleSupplier;

public class CrossPolylineGroup {
    PolylineList first = null;
    PolylineList last = null;
    int count = 0;
    double x = 0.0;
    double y = 0.0;
    double[] rect = new double[4];
    int includedLevel = 0;
    int levelMax = 0;
    boolean innerRegionFound = false;
    boolean regionInside = true;
    IntersectRegionSort outerMostPoint;
    PolylineList iterator = null;

    public ToolPolyline2D getFirst() {
        if (this.first != null) {
            return this.first.manager.getPolyline();
        }
        return null;
    }

    public ToolPolyline2D iterFirst() {
        this.iterator = this.first;
        if (this.first != null) {
            return this.iterator.manager.getPolyline();
        }
        return null;
    }

    public ToolPolyline2D next() {
        if (this.iterator == null) {
            return null;
        }
        this.iterator = this.iterator.next;
        if (this.iterator != null) {
            return this.iterator.manager.getPolyline();
        }
        return null;
    }

    public void add(PolylineManager polylineManager) {
        PolylineList polylineList = new PolylineList();
        RectangleSupplier rectangleSupplier = polylineManager.getPolyline() instanceof RectangleSupplier ? (RectangleSupplier)((Object)polylineManager.getPolyline()) : null;
        polylineList.manager = polylineManager;
        if (this.first == null) {
            this.first = polylineList;
            this.x = ((ToolFigure2D)polylineManager.getPolyline().firstElement()).getX1();
            this.y = ((ToolFigure2D)polylineManager.getPolyline().firstElement()).getY1();
            if (rectangleSupplier != null) {
                this.rect[0] = rectangleSupplier.getLeft();
                this.rect[1] = rectangleSupplier.getLower();
                this.rect[2] = rectangleSupplier.getRight();
                this.rect[3] = rectangleSupplier.getUpper();
            } else {
                ToolPlane2D.getFitRectangle(this.rect, polylineManager.getPolyline());
            }
        } else if (rectangleSupplier != null) {
            ToolGeom2D.getFitRectangleOr(this.rect, this.rect[0], this.rect[1], this.rect[2], this.rect[3], rectangleSupplier.getLeft(), rectangleSupplier.getLower(), rectangleSupplier.getRight(), rectangleSupplier.getUpper());
        } else {
            double d = this.rect[0];
            double d2 = this.rect[1];
            double d3 = this.rect[2];
            double d4 = this.rect[3];
            ToolPlane2D.getFitRectangle(this.rect, polylineManager.getPolyline());
            ToolGeom2D.getFitRectangleOr(this.rect, d, d2, d3, d4, this.rect[0], this.rect[1], this.rect[2], this.rect[3]);
        }
        if (this.last != null) {
            this.last.next = polylineList;
        }
        this.last = polylineList;
        ++this.count;
    }

    public boolean search(ToolPolyline2D toolPolyline2D) {
        PolylineList polylineList = this.first;
        while (polylineList != null) {
            if (polylineList.manager.getPolyline() == toolPolyline2D) {
                return true;
            }
            polylineList = polylineList.next;
        }
        return false;
    }

    public void addIncludedLevel(int n) {
        this.includedLevel += n;
    }

    public int getIncludedLevel() {
        return this.includedLevel;
    }

    public int getMaxLevel() {
        return this.levelMax;
    }

    public void setMaxLevel(int n) {
        this.levelMax = n;
    }

    public void integrate(CrossPolylineGroup crossPolylineGroup) {
        PolylineList polylineList = crossPolylineGroup.first;
        while (polylineList != null) {
            polylineList.manager.setGroup(this);
            polylineList = polylineList.next;
        }
        this.last.next = crossPolylineGroup.first;
        this.last = crossPolylineGroup.last;
        this.count += crossPolylineGroup.count;
    }

    public ToolPolyline2D[] getAllPolyline() {
        ToolPolyline2D[] toolPolyline2DArray = new ToolPolyline2D[this.count];
        int n = 0;
        PolylineList polylineList = this.first;
        while (polylineList != null) {
            toolPolyline2DArray[n] = polylineList.manager.getPolyline();
            polylineList = polylineList.next;
            ++n;
        }
        return toolPolyline2DArray;
    }

    private class PolylineList {
        PolylineManager manager;
        PolylineList next;

        private PolylineList() {
        }
    }
}

