/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.datapassing.complete;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import jp.kitec.math.geom.datapassing.CollectionEditable;
import jp.kitec.math.geom.datapassing.PolylineEditable;
import jp.kitec.math.geom.datapassing.Searchable;
import jp.kitec.math.geom.datapassing.ToolPolyline2D;
import jp.kitec.math.geom.datapassing.ToolPolyline2DCollection;
import jp.kitec.math.geom.datapassing.complete.ToolPolyline;
import jp.kitec.math.searches.regiontree.RegionTree;
import jp.kitec.math.searches.regiontree.RegionTreeBuilder;

public class ToolPolylineCollection
implements ToolPolyline2DCollection,
CollectionEditable,
Searchable,
Serializable {
    private Vector vectorPolylines = new Vector(10, 10);
    private Hashtable hash = new Hashtable();
    private RegionTree tree = null;
    private double[] rect = new double[4];
    private boolean bChanged = false;

    public ToolPolylineCollection() {
    }

    public ToolPolylineCollection(ToolPolylineCollection toolPolylineCollection) {
        this();
        this.addAll(toolPolylineCollection);
    }

    public boolean addAll(ToolPolyline2DCollection toolPolyline2DCollection) {
        int n = 0;
        while (n < toolPolyline2DCollection.size()) {
            ToolPolyline2D toolPolyline2D = toolPolyline2DCollection.get(n);
            ToolPolyline2D toolPolyline2D2 = this.add();
            if (!(toolPolyline2D2 instanceof PolylineEditable)) {
                return false;
            }
            PolylineEditable polylineEditable = (PolylineEditable)((Object)toolPolyline2D2);
            polylineEditable.addAll(toolPolyline2D);
            ++n;
        }
        this.setChangedFlag();
        return true;
    }

    public ToolPolyline2D add(ToolPolyline2D toolPolyline2D) {
        if (!(toolPolyline2D instanceof PolylineEditable)) {
            return null;
        }
        this.vectorPolylines.add(toolPolyline2D);
        PolylineEditable polylineEditable = (PolylineEditable)((Object)toolPolyline2D);
        polylineEditable.setParent(this);
        this.setChangedFlag();
        return toolPolyline2D;
    }

    public boolean remove(ToolPolyline2D toolPolyline2D) {
        if (!(toolPolyline2D instanceof PolylineEditable)) {
            return false;
        }
        this.vectorPolylines.remove(toolPolyline2D);
        PolylineEditable polylineEditable = (PolylineEditable)((Object)toolPolyline2D);
        polylineEditable.setParent(null);
        this.setChangedFlag();
        return true;
    }

    public void clear() {
        this.vectorPolylines.clear();
        this.hash.clear();
        this.tree = null;
        this.bChanged = false;
    }

    public ToolPolyline2D get(int n) {
        if (n < this.vectorPolylines.size()) {
            return (ToolPolyline2D)this.vectorPolylines.get(n);
        }
        return null;
    }

    public int size() {
        return this.vectorPolylines.size();
    }

    public ToolPolyline2D add() {
        ToolPolyline toolPolyline = new ToolPolyline(this, this.vectorPolylines.size());
        this.vectorPolylines.add(toolPolyline);
        this.tree = null;
        return toolPolyline;
    }

    public void makeTree(RegionTreeBuilder regionTreeBuilder) {
        if (!this.bChanged) {
            return;
        }
        RegionTreeBuilder regionTreeBuilder2 = new RegionTreeBuilder();
        int n = 0;
        while (n < this.size()) {
            ToolPolyline toolPolyline = (ToolPolyline)this.get(n);
            toolPolyline.makeTree(regionTreeBuilder2);
            regionTreeBuilder.addNodes(toolPolyline);
            if (n == 0) {
                this.rect[0] = toolPolyline.getLeft();
                this.rect[1] = toolPolyline.getLower();
                this.rect[2] = toolPolyline.getRight();
                this.rect[3] = toolPolyline.getUpper();
            } else {
                this.rect[0] = toolPolyline.getLeft() < this.rect[0] ? toolPolyline.getLeft() : this.rect[0];
                this.rect[1] = toolPolyline.getLower() < this.rect[1] ? toolPolyline.getLower() : this.rect[1];
                this.rect[2] = toolPolyline.getRight() > this.rect[2] ? toolPolyline.getRight() : this.rect[2];
                this.rect[3] = toolPolyline.getUpper() > this.rect[3] ? toolPolyline.getUpper() : this.rect[3];
            }
            ++n;
        }
        if (this.tree == null) {
            this.tree = new RegionTree();
        }
        regionTreeBuilder.build(this.tree);
        this.bChanged = false;
    }

    public int search(Vector vector, double d, double d2, double d3, double d4) {
        if (this.tree == null || this.bChanged) {
            this.makeTree(new RegionTreeBuilder());
        }
        if (this.tree != null) {
            return this.tree.search(vector, d, d2, d3, d4);
        }
        return 0;
    }

    void setChangedFlag() {
        this.bChanged = true;
    }

    public double getLeft() {
        if (this.bChanged) {
            this.makeTree(new RegionTreeBuilder());
        }
        return this.rect[0];
    }

    public double getRight() {
        if (this.bChanged) {
            this.makeTree(new RegionTreeBuilder());
        }
        return this.rect[2];
    }

    public double getLower() {
        if (this.bChanged) {
            this.makeTree(new RegionTreeBuilder());
        }
        return this.rect[1];
    }

    public double getUpper() {
        if (this.bChanged) {
            this.makeTree(new RegionTreeBuilder());
        }
        return this.rect[3];
    }
}

