/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom;

import jp.kitec.math.algebra.AlgebraException;
import jp.kitec.math.geom.ToolIntersectPoint2D;

public class ToolGeom2D
extends ToolIntersectPoint2D {
    public static final int LINE = 1;
    public static final int ARCCW = 2;
    public static final int ARCCCW = 3;

    public static void main(String[] stringArray) {
        double[] dArray = new double[4];
        double d = 2.0 / Math.sqrt(2.0);
        try {
            ToolGeom2D.getIntersectPoints(dArray, 0.0, d, d, 0.0, 1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0, false);
        }
        catch (AlgebraException algebraException) {}
    }

    public static int compareAngle(double d, double d2) {
        if (Math.abs(d2 - d) < 1.0E-4) {
            return 0;
        }
        if (d < d2) {
            return -1;
        }
        return 1;
    }

    public static double getParameter(double d, double d2, double d3) {
        double d4 = d3 - d2;
        double d5 = Double.POSITIVE_INFINITY;
        if (Math.abs(d4) > 1.0E-8) {
            d5 = (d - d2) / d4;
        }
        if (Math.abs(d5) <= 1.0E-10) {
            d5 = 0.0;
        }
        return d5;
    }

    public static double getParameter(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d5 - d3;
        double d8 = d6 - d4;
        double d9 = Double.POSITIVE_INFINITY;
        if (Math.abs(d7) > 1.0E-8) {
            d9 = (d - d3) / d7;
        } else if (Math.abs(d8) > 1.0E-8) {
            d9 = (d2 - d4) / d8;
        }
        if (Math.abs(d9) <= 1.0E-10) {
            d9 = 0.0;
        }
        return d9;
    }

    public static double getParameter(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, boolean bl) {
        double d10;
        double d11 = Double.POSITIVE_INFINITY;
        int n = 0;
        double d12 = Math.atan2(d4 - d8, d3 - d7);
        double d13 = Math.atan2(d6 - d8, d5 - d7);
        double d14 = Math.atan2(d2 - d8, d - d7);
        if (bl && d12 < d13) {
            d10 = d13 - d12 - Math.PI * 2;
            n = 1;
        } else if (!bl && d12 > d13) {
            d10 = Math.PI * 2 - d12 + d13;
            n = 2;
        } else {
            d10 = d13 - d12;
        }
        switch (n) {
            case 1: {
                if (!(d12 < d14)) break;
                d14 -= Math.PI * 2;
                break;
            }
            case 2: {
                if (!(d12 > d14)) break;
                d14 += Math.PI * 2;
            }
        }
        d11 = (d14 - d12) / d10;
        return d11;
    }

    public static double getValueFromParameter(double d, double d2, double d3) {
        double d4 = d2 - d;
        return d + d4 * d3;
    }

    public static void getPointFromParameter(double[] dArray, double d, double d2, double d3, double d4, double d5) {
        dArray[0] = ToolGeom2D.getValueFromParameter(d, d3, d5);
        dArray[1] = ToolGeom2D.getValueFromParameter(d2, d4, d5);
    }

    public static void getPointFromParameter(double[] dArray, double d, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl, double d8) {
        double d9 = Math.atan2(d2 - d6, d - d5);
        double d10 = Math.atan2(d4 - d6, d3 - d5);
        double d11 = bl && d9 < d10 ? d10 - (d9 + Math.PI * 2) : (!bl && d9 > d10 ? d10 - (d9 - Math.PI * 2) : d10 - d9);
        double d12 = d8 * d11 + d9;
        if (d12 > Math.PI) {
            d12 -= Math.PI * 2;
        } else if (d12 < -Math.PI) {
            d12 += Math.PI * 2;
        }
        dArray[0] = d5 + Math.cos(d12) * d7;
        dArray[1] = d6 + Math.sin(d12) * d7;
    }

    public static void getPointFromDistance(double[] dArray, double d, double d2, double d3, double d4, double d5, boolean bl) {
        double d6 = ToolGeom2D.getLength(d, d2, d3, d4);
        double d7 = bl ? d5 / d6 : (d6 - d5) / d6;
        ToolGeom2D.getPointFromParameter(dArray, d, d2, d3, d4, d7);
    }

    public static void getPointFromDistance(double[] dArray, double d, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl, double d8, boolean bl2) {
        double d9 = ToolGeom2D.getLength(d, d2, d3, d4, d5, d6, d7, bl);
        double d10 = bl2 ? d8 / d9 : (d9 - d8) / d9;
        ToolGeom2D.getPointFromParameter(dArray, d, d2, d3, d4, d5, d6, d7, bl, d10);
    }

    public static boolean getPerpendicularPoint(double[] dArray, double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d5 - d3;
        double d8 = d6 - d4;
        if (ToolGeom2D.compare(d7, 0.0, 1.0E-8) == 0) {
            dArray[0] = (d3 + d5) / 2.0;
            dArray[1] = d2;
        } else if (ToolGeom2D.compare(d8, 0.0, 1.0E-8) == 0) {
            dArray[0] = d;
            dArray[1] = (d4 + d6) / 2.0;
        } else {
            double d9 = Math.sqrt(d7 * d7 + d8 * d8);
            double d10 = ((d3 - d) * (d6 - d2) - (d4 - d2) * (d5 - d)) / d9;
            double d11 = -d8 * (d10 / d9);
            double d12 = d7 * (d10 / d9);
            dArray[0] = d + d11;
            dArray[1] = d2 + d12;
            double d13 = dArray[0] - d3;
            double d14 = d13 / d7;
            double d15 = dArray[1] - d4;
            double d16 = d15 / d8;
            if (Math.abs(d14 - d16) > 1.0E-8) {
                dArray[0] = d - d11;
                dArray[1] = d2 - d12;
            }
        }
        return true;
    }

    public static boolean getPerpendicularPoint(double[] dArray, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, boolean bl) {
        double d10 = d - d7;
        double d11 = d2 - d8;
        double d12 = Math.sqrt(d10 * d10 + d11 * d11);
        if (d12 == 0.0) {
            return false;
        }
        dArray[0] = d7 + d10 * (d9 / d12);
        dArray[1] = d8 + d11 * (d9 / d12);
        return true;
    }

    public static void getFitRectangle(double[] dArray, double d, double d2, double d3, double d4) {
        dArray[0] = Math.min(d, d3);
        dArray[1] = Math.min(d2, d4);
        dArray[2] = Math.max(d, d3);
        dArray[3] = Math.max(d2, d4);
    }

    public static void getFitRectangle(double[] dArray, double d, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl) {
        double d8;
        double d9;
        if (ToolGeom2D.compareDistance(d7, 0.0) == 0) {
            d7 = ToolGeom2D.getRadius(d, d2, d3, d4, d5, d6);
        }
        if (!bl) {
            d9 = Math.atan2(d2 - d6, d - d5);
            d8 = Math.atan2(d4 - d6, d3 - d5);
        } else {
            d9 = Math.atan2(d4 - d6, d3 - d5);
            d8 = Math.atan2(d2 - d6, d - d5);
        }
        if (d < d3) {
            dArray[0] = d;
            dArray[2] = d3;
        } else {
            dArray[0] = d3;
            dArray[2] = d;
        }
        if (d2 < d4) {
            dArray[1] = d2;
            dArray[3] = d4;
        } else {
            dArray[1] = d4;
            dArray[3] = d2;
        }
        if (d9 < d8) {
            if (d9 < -1.5707963267948966 && d8 > -1.5707963267948966) {
                dArray[1] = d6 - d7;
            }
            if (d9 < 0.0 && d8 > 0.0) {
                dArray[2] = d5 + d7;
            }
            if (d9 < 1.5707963267948966 && d8 > 1.5707963267948966) {
                dArray[3] = d6 + d7;
            }
        } else {
            dArray[0] = d5 - d7;
            if (d9 < -1.5707963267948966 || d8 > -1.5707963267948966) {
                dArray[1] = d6 - d7;
            }
            if (d9 < 0.0 || d8 > 0.0) {
                dArray[2] = d5 + d7;
            }
            if (d9 < 1.5707963267948966 || d8 > 1.5707963267948966) {
                dArray[3] = d6 + d7;
            }
        }
    }

    public static void getFitRectangleOr(double[] dArray, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        dArray[0] = Math.min(d, d5);
        dArray[1] = Math.min(d2, d6);
        dArray[2] = Math.max(d3, d7);
        dArray[3] = Math.max(d4, d8);
    }

    public static boolean getFitRectangleAnd(double[] dArray, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        if (d3 < d5 || d > d7 || d4 < d6 || d2 > d8) {
            return false;
        }
        dArray[0] = d >= d5 && d <= d7 ? d : d5;
        if (d2 >= d6 && d2 <= d8) {
            dArray[1] = d2;
        } else if (d6 >= d2 && d6 <= d4) {
            dArray[1] = d6;
        }
        dArray[2] = d3 >= d5 && d3 <= d7 ? d3 : d7;
        dArray[3] = d4 >= d6 && d4 <= d8 ? d4 : d8;
        return true;
    }

    public static boolean checkFitRectangleIntersect(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return ToolGeom2D.compare(d3, d5) >= 0 && ToolGeom2D.compare(d, d7) <= 0 && ToolGeom2D.compare(d4, d6) >= 0 && ToolGeom2D.compare(d2, d8) <= 0;
    }

    public static double findAreaOfSegment(double d, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl) {
        double d8 = 0.0;
        double d9 = Math.atan2(d2 - d6, d - d5);
        double d10 = Math.atan2(d4 - d6, d3 - d5);
        d8 = bl ? (d10 > d9 ? Math.PI - (d10 - d9) : d9 - d10) : (d9 > d10 ? Math.PI - (d9 - d10) : d10 - d9);
        d8 = Math.abs(d8);
        double d11 = d7 * d7 * d8 / 2.0;
        return d11 -= d7 * d7 * Math.sin(d8) / 2.0;
    }

    public static double getAngleOfArc(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        double d7 = Math.atan2(d2 - d6, d - d5);
        double d8 = Math.atan2(d4 - d6, d3 - d5);
        double d9 = bl && d7 < d8 ? d8 - d7 - Math.PI * 2 : (!bl && d7 > d8 ? Math.PI * 2 - d7 - d8 : d8 - d7);
        return d9;
    }

    public static double getAngleTwoTangentsOfFiguresAtJoint(double d, double d2, double d3, double d4, double d5, double d6, int n, double d7, double d8, double d9, double d10, double d11, double d12, int n2) {
        double d13;
        double d14;
        double d15;
        if (n == 1) {
            d15 = Math.atan2(d4 - d2, d3 - d);
        } else {
            d15 = Math.atan2(d4 - d6, d3 - d5);
            d15 += n == 2 ? -1.5707963267948966 : 1.5707963267948966;
        }
        if (n2 == 1) {
            d14 = Math.atan2(d10 - d8, d9 - d7);
        } else {
            d14 = Math.atan2(d8 - d12, d7 - d11);
            d14 += n2 == 2 ? -1.5707963267948966 : 1.5707963267948966;
        }
        if (d15 <= -Math.PI) {
            d15 += Math.PI * 2;
        }
        if (d15 > Math.PI) {
            d15 -= Math.PI * 2;
        }
        if (d14 <= -Math.PI) {
            d14 += Math.PI * 2;
        }
        if (d14 > Math.PI) {
            d14 -= Math.PI * 2;
        }
        if (ToolGeom2D.compareAngle(Math.abs(d13 = d14 - d15), Math.PI) == 0) {
            if (n == 2 || n == 3) {
                double d16;
                double d17;
                if (n2 == 3) {
                    d17 = d7 + d8 - d6;
                    d16 = d8 - d7 - d5;
                } else if (n2 == 2) {
                    d17 = d7 - d8 - d6;
                    d16 = d8 + d7 - d5;
                } else {
                    d17 = d7;
                    d16 = d8;
                }
                byte by = ToolGeom2D.getSideOfPointWithLine(d17, d16, d9, d10, d5, d6);
                if (by == 1) {
                    return -Math.abs(d13);
                }
                return Math.abs(d13);
            }
            if (n2 == 2 || n2 == 3) {
                double d18;
                double d19;
                if (n == 3) {
                    d19 = d3 + d4 - d6;
                    d18 = d4 - d3 - d5;
                } else if (n == 2) {
                    d19 = d3 - d4 - d6;
                    d18 = d4 + d3 - d5;
                } else {
                    d19 = d;
                    d18 = d2;
                }
                byte by = ToolGeom2D.getSideOfPointWithLine(d19, d18, d3, d4, d11, d12);
                if (by == 1) {
                    return -Math.abs(d13);
                }
                return Math.abs(d13);
            }
            if (n == 1 && n2 == 1) {
                return Math.PI;
            }
        }
        if (ToolGeom2D.compareAngle(d13, -Math.PI) == -1) {
            return d13 + Math.PI * 2;
        }
        if (ToolGeom2D.compareAngle(d13, Math.PI) == 1) {
            return d13 - Math.PI * 2;
        }
        return d13;
    }

    public static void getMidPoint(double[] dArray, double d, double d2, double d3, double d4) {
        dArray[0] = (d + d3) / 2.0;
        dArray[1] = (d2 + d4) / 2.0;
    }

    public static void getMidPoint(double[] dArray, double d, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl) {
        byte by = ToolGeom2D.getSideOfPointWithLine(d5, d6, d, d2, d3, d4);
        if (by == 3) {
            double d8 = d5 - d;
            double d9 = d6 - d2;
            dArray[0] = d5 + (bl ? -d9 : d9);
            dArray[1] = d6 + (bl ? d8 : -d8);
            return;
        }
        double d10 = (d + d3) / 2.0;
        double d11 = (d2 + d4) / 2.0;
        double d12 = d10 - d5;
        double d13 = d11 - d6;
        double d14 = d7 / Math.sqrt(d12 * d12 + d13 * d13);
        if (bl && by == 1 || !bl && by == 2) {
            dArray[0] = d12 * d14 + d5;
            dArray[1] = d13 * d14 + d6;
        } else {
            dArray[0] = d12 * -d14 + d5;
            dArray[1] = d13 * -d14 + d6;
        }
    }

    public static double getRadius(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = ToolGeom2D.getDistance(d, d2, d5, d6);
        double d8 = ToolGeom2D.getDistance(d3, d4, d5, d6);
        return (d7 + d8) / 2.0;
    }

    public static double getLength(double d, double d2, double d3, double d4) {
        return ToolGeom2D.getDistance(d, d2, d3, d4);
    }

    public static double getLength(double d, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl) {
        double d8 = ToolGeom2D.getAngleOfArc(d, d2, d3, d4, d5, d6, bl);
        return d8 * d7 * 2.0;
    }

    public static void getOffsetOfLine(double[] dArray, double d, double d2, double d3, double d4, double d5, boolean bl) {
        double d6 = d3 - d;
        double d7 = d4 - d2;
        double d8 = Math.sqrt(d6 * d6 + d7 * d7);
        d6 *= d5 / d8;
        d7 *= d5 / d8;
        if (bl) {
            dArray[0] = d + d7;
            dArray[1] = d2 - d6;
            dArray[2] = d3 + d7;
            dArray[3] = d4 - d6;
        } else {
            dArray[0] = d - d7;
            dArray[1] = d2 + d6;
            dArray[2] = d3 - d7;
            dArray[3] = d4 + d6;
        }
    }

    public static boolean getOffsetOfArc(double[] dArray, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, boolean bl, boolean bl2) {
        double d9 = d7 + (bl == bl2 ? -d8 : d8);
        dArray[0] = ToolGeom2D.getValueFromParameter(d, d5, d9 / d7);
        dArray[1] = ToolGeom2D.getValueFromParameter(d2, d6, d9 / d7);
        dArray[2] = ToolGeom2D.getValueFromParameter(d3, d5, d9 / d7);
        dArray[3] = ToolGeom2D.getValueFromParameter(d4, d6, d9 / d7);
        dArray[4] = d9;
        return d9 > 0.0;
    }

    public static double getMinimumDistance(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double[] dArray = new double[2];
        if (ToolGeom2D.getPerpendicularPoint(dArray, d, d2, d3, d4, d5, d6) && ToolGeom2D.checkPointOn(dArray[0], dArray[1], d3, d4, d5, d6)) {
            return ToolGeom2D.getDistance(d, d2, dArray[0], dArray[1]);
        }
        double d8 = ToolGeom2D.getDistance(d, d2, d3, d4);
        return d8 <= (d7 = ToolGeom2D.getDistance(d, d2, d5, d6)) ? d8 : d7;
    }

    public static double getMinimumDistance(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, boolean bl) {
        double d10;
        double[] dArray = new double[2];
        if (ToolGeom2D.getPerpendicularPoint(dArray, d, d2, d3, d4, d5, d6, d7, d8, d9, bl) && ToolGeom2D.checkPointOn(dArray[0], dArray[1], d3, d4, d5, d6, d7, d8, d9, bl)) {
            return ToolGeom2D.getDistance(d, d2, dArray[0], dArray[1]);
        }
        double d11 = ToolGeom2D.getDistance(d, d2, d3, d4);
        return d11 <= (d10 = ToolGeom2D.getDistance(d, d2, d5, d6)) ? d11 : d10;
    }
}

