/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.algebra;

import jp.kitec.math.algebra.AlgebraException;
import jp.kitec.math.algebra.ToolAlgebra1D;

public class ToolAlgebra2DQuadratic {
    private static double TOLERANCE_1 = 1.0E-10;
    private static double TOLERANCE_2 = 1.0E-8;
    public static final int EQUALITYSIGN_NOT_EQUAL = 0;
    public static final int EQUALITYSIGN_EQUAL = 1;
    public static final int EQUALITYSIGN_LESS_THAN = 2;
    public static final int EQUALITYSIGN_GREATER_THAN = 3;
    public static final int EQUALITYSIGN_LESS_THAN_OR_EQUAL = 4;
    public static final int EQUALITYSIGN_GREATER_THAN_OR_EQUAL = 5;
    private double A;
    private double B;
    private double C;
    private double D;
    private double E;
    private double F;
    private double[] answerX;
    private double[] answerY;
    ToolAlgebra1D __evaluateTwoQuadraticEquations_ToolAlgebra1D_1 = new ToolAlgebra1D();
    ToolAlgebra1D __evaluateTwoQuadraticEquations_ToolAlgebra1D_2 = new ToolAlgebra1D();
    ToolAlgebra1D __evaluateTwoQuadraticEquations_ToolAlgebra1D_3 = new ToolAlgebra1D();

    public ToolAlgebra2DQuadratic() {
        this.answerX = new double[4];
        this.answerY = new double[4];
    }

    public ToolAlgebra2DQuadratic(double d, double d2, double d3, double d4, double d5, double d6) {
        this();
        this.A = d;
        this.B = d2;
        this.C = d3;
        this.D = d4;
        this.E = d5;
        this.F = d6;
    }

    static int compare(double d) {
        if (Math.abs(d) <= TOLERANCE_1) {
            return 0;
        }
        if (d < 0.0) {
            return -1;
        }
        return 1;
    }

    static int compare(double d, double d2) {
        if (Math.abs(d - d2) <= TOLERANCE_2) {
            return 0;
        }
        if (d < d2) {
            return -1;
        }
        return 1;
    }

    static int compare(double d, double d2, double d3) {
        if (Math.abs(d - d2) <= d3) {
            return 0;
        }
        if (d < d2) {
            return -1;
        }
        return 1;
    }

    private static boolean CheckPositionOfPoint(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, int n) {
        double d9 = d * d7 * d7 + d2 * d8 * d8 + d3 * d7 * d8 + d4 * d7 + d5 * d8 + d6;
        int n2 = ToolAlgebra2DQuadratic.compare(d9, 0.0, 5.0E-10);
        switch (n) {
            case 1: {
                if (n2 != 0) break;
                return true;
            }
            case 2: {
                if (n2 >= 0) break;
                return true;
            }
            case 3: {
                if (n2 <= 0) break;
                return true;
            }
            case 4: {
                if (n2 > 0) break;
                return true;
            }
            case 5: {
                if (n2 < 0) break;
                return true;
            }
        }
        return false;
    }

    public boolean linear(double d, double d2, double d3, double d4) throws AlgebraException {
        return this.linear(d, d2, d, d2, d3, d4);
    }

    public boolean linear(double d, double d2, double d3, double d4, double d5, double d6) throws AlgebraException {
        this.C = 0.0;
        this.B = 0.0;
        this.A = 0.0;
        this.D = d6 - d4;
        if (ToolAlgebra2DQuadratic.compare(this.D, 0.0) == 0) {
            this.D = 0.0;
        }
        this.E = -(d5 - d3);
        if (ToolAlgebra2DQuadratic.compare(this.E, 0.0) == 0) {
            this.E = 0.0;
        }
        this.F = -(this.D * d + this.E * d2);
        if (this.D == 0.0 && this.E == 0.0) {
            return false;
        }
        if (this.E != 0.0 && this.D / this.E > 1.0E8 || this.D != 0.0 && this.E / this.D > 1.0E8) {
            throw new AlgebraException();
        }
        return true;
    }

    public boolean halfDividePerpendicularLinear(double d, double d2, double d3, double d4) throws AlgebraException {
        this.C = 0.0;
        this.B = 0.0;
        this.A = 0.0;
        this.D = d3 - d;
        if (ToolAlgebra2DQuadratic.compare(this.D, 0.0) == 0) {
            this.D = 0.0;
        }
        this.E = d4 - d2;
        if (ToolAlgebra2DQuadratic.compare(this.E, 0.0) == 0) {
            this.E = 0.0;
        }
        this.F = -(d4 * d4 - d2 * d2 + d3 * d3 - d * d) / 2.0;
        if (this.D == 0.0 && this.E == 0.0) {
            return false;
        }
        if (ToolAlgebra2DQuadratic.compare(this.F, 0.0, 1.0E-15) == 0) {
            this.F = 0.0;
        }
        if (this.E != 0.0 && this.D / this.E > 1.0E8 || this.D != 0.0 && this.E / this.D > 1.0E8) {
            throw new AlgebraException();
        }
        return true;
    }

    public void circle(double d, double d2, double d3) {
        this.B = 1.0;
        this.A = 1.0;
        this.C = 0.0;
        this.D = -2.0 * d;
        this.E = -2.0 * d2;
        this.F = d * d + d2 * d2 - d3 * d3;
    }

    public void ellipse(double d, double d2, double d3, double d4) {
        this.A = 1.0 / (d3 * d3);
        this.B = 1.0 / (d4 * d4);
        this.C = 0.0;
        this.D = -2.0 * d * this.A;
        this.E = -2.0 * d2 * this.B;
        this.F = d * d * this.A + d2 * d2 * this.B - 1.0;
    }

    public void ellipse(double d, double d2, double d3, double d4, double d5) {
        double d6 = d - d3;
        double d7 = d2 - d4;
        double d8 = d * d - d3 * d3;
        double d9 = d2 * d2 - d4 * d4;
        double d10 = d5 * d5;
        this.A = 4.0 * (d6 * d6 - d10);
        this.B = 4.0 * (d7 * d7 - d10);
        this.C = 8.0 * (d2 * d6 - d4 * d6);
        this.D = -4.0 * (d * (d8 + d9 - d10) - d3 * (d8 * d9 + d10));
        this.E = -4.0 * (d2 * (d8 + d9 - d10) - d4 * (d8 * d9 + d10));
        this.F = d8 * d8 + d9 * d9 - 2.0 * d10 * (d * d + d2 * d2 + d3 * d3 + d4 * d4) + 2.0 * (d2 * d2 * d8 - d4 * d4 * d8) + d10 * d10;
    }

    public int solve(ToolAlgebra2DQuadratic toolAlgebra2DQuadratic) {
        int n = 0;
        int n2 = (ToolAlgebra2DQuadratic.compare(this.B) != 0 || ToolAlgebra2DQuadratic.compare(toolAlgebra2DQuadratic.B) != 0) && Math.abs(this.D) + Math.abs(toolAlgebra2DQuadratic.D) <= Math.abs(this.E) + Math.abs(toolAlgebra2DQuadratic.E) ? this.evaluateTwoQuadraticEquations(this.answerX, this.answerY, this.A, this.B, this.C, this.D, this.E, this.F, toolAlgebra2DQuadratic.A, toolAlgebra2DQuadratic.B, toolAlgebra2DQuadratic.C, toolAlgebra2DQuadratic.D, toolAlgebra2DQuadratic.E, toolAlgebra2DQuadratic.F) : ((ToolAlgebra2DQuadratic.compare(this.A) != 0 || ToolAlgebra2DQuadratic.compare(toolAlgebra2DQuadratic.A) != 0) && Math.abs(this.D) + Math.abs(toolAlgebra2DQuadratic.D) > Math.abs(this.E) + Math.abs(toolAlgebra2DQuadratic.E) ? this.evaluateTwoQuadraticEquations(this.answerY, this.answerX, this.B, this.A, this.C, this.E, this.D, this.F, toolAlgebra2DQuadratic.B, toolAlgebra2DQuadratic.A, toolAlgebra2DQuadratic.C, toolAlgebra2DQuadratic.E, toolAlgebra2DQuadratic.D, toolAlgebra2DQuadratic.F) : (ToolAlgebra2DQuadratic.compare(this.C) != 0 || ToolAlgebra2DQuadratic.compare(this.E) != 0 ? this.evaluateTwoQuadraticEquations(this.answerX, this.answerY, this.C, this.D, this.E, this.F, toolAlgebra2DQuadratic.C, toolAlgebra2DQuadratic.D, toolAlgebra2DQuadratic.E, toolAlgebra2DQuadratic.F) : this.evaluateTwoQuadraticEquations(this.answerY, this.answerX, this.C, this.E, this.D, this.F, toolAlgebra2DQuadratic.C, toolAlgebra2DQuadratic.E, toolAlgebra2DQuadratic.D, toolAlgebra2DQuadratic.F)));
        int n3 = 0;
        while (n3 < n2) {
            block5: {
                int n4 = n3 + 1;
                while (n4 < n) {
                    if (ToolAlgebra2DQuadratic.compare(this.answerX[n3], this.answerX[n4]) != 0 || ToolAlgebra2DQuadratic.compare(this.answerY[n3], this.answerY[n4]) != 0) {
                        ++n4;
                        continue;
                    }
                    break block5;
                }
                if (n != n3) {
                    this.answerX[n] = this.answerX[n3];
                    this.answerY[n] = this.answerY[n3];
                }
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            toolAlgebra2DQuadratic.answerX[n3] = this.answerX[n3];
            toolAlgebra2DQuadratic.answerY[n3] = this.answerY[n3];
            ++n3;
        }
        return n;
    }

    public double getSolutionX(int n) {
        return this.answerX[n];
    }

    public double getSolutionY(int n) {
        return this.answerY[n];
    }

    private int evaluateTwoQuadraticEquations(double[] dArray, double[] dArray2, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        ToolAlgebra1D toolAlgebra1D = this.__evaluateTwoQuadraticEquations_ToolAlgebra1D_1;
        ToolAlgebra1D toolAlgebra1D2 = this.__evaluateTwoQuadraticEquations_ToolAlgebra1D_2;
        double d13 = d * d8 - d7 * d2;
        double d14 = d8 * d4 - d2 * d10;
        double d15 = d9 * d5 + d3 * d11;
        double d16 = d8 * d3 - d2 * d9;
        double d17 = d3 * d10 - d9 * d4;
        double d18 = d8 * d6 - d2 * d12;
        double d19 = d * d8 + d7 * d2;
        double d20 = d8 * d4 + d2 * d10;
        double d21 = d9 * d6 - d3 * d12;
        double d22 = d8 * d6 + d2 * d12;
        toolAlgebra1D.set(d13 * d13 + d * d2 * d9 * d9 + d7 * d8 * d3 * d3 - d3 * d9 * d19, 2.0 * d13 * d14 - d19 * d15 + 2.0 * d * d2 * d9 * d11 + 2.0 * d7 * d8 * d3 * d5 + d16 * d17, d14 * d14 - d15 * d20 - d5 * d11 * d19 + d13 * 2.0 * d18 - d16 * d21 + 2.0 * d2 * d9 * d4 * d11 + 2.0 * d8 * d3 * d10 * d5 + d * d2 * d11 * d11 + d7 * d8 * d5 * d5, -d15 * d22 + 2.0 * d14 * d18 - d5 * d11 * d20 + 2.0 * d2 * d9 * d11 * d6 + 2.0 * d8 * d3 * d5 * d12 + d2 * d4 * d11 * d11 + d8 * d10 * d5 * d5, d18 * d18 - d5 * d11 * d22 + d2 * d11 * d11 * d6 + d8 * d5 * d5 * d12);
        int n = toolAlgebra1D.solve();
        double d23 = d - d7;
        double d24 = d2 - d8;
        double d25 = d3 - d9;
        double d26 = d4 - d10;
        double d27 = d5 - d11;
        double d28 = d6 - d12;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            double d29;
            double d30 = toolAlgebra1D.getSolution(n3);
            double d31 = d24;
            double d32 = d25 * d30 + d27;
            double d33 = d23 * d30 * d30 + d26 * d30 + d28;
            if (ToolAlgebra2DQuadratic.compare(d31) == 0 && ToolAlgebra2DQuadratic.compare(d32) == 0 && ToolAlgebra2DQuadratic.compare(d33) == 0) {
                d31 = d2;
                d32 = d3 * d30 + d5;
                d33 = d * d30 * d30 + d4 * d30 + d6;
            }
            toolAlgebra1D2.set(d31, d32, d33);
            int n4 = toolAlgebra1D2.solve();
            if (n4 >= 1 && (ToolAlgebra2DQuadratic.CheckPositionOfPoint(d, d2, d3, d4, d5, d6, d30, d29 = toolAlgebra1D2.getSolution(0), 1) || ToolAlgebra2DQuadratic.CheckPositionOfPoint(d7, d8, d9, d10, d11, d12, d30, d29, 1))) {
                dArray[n2] = d30;
                dArray2[n2] = d29;
                ++n2;
            }
            if (n4 == 2 && (ToolAlgebra2DQuadratic.CheckPositionOfPoint(d, d2, d3, d4, d5, d6, d30, d29 = toolAlgebra1D2.getSolution(1), 1) || ToolAlgebra2DQuadratic.CheckPositionOfPoint(d7, d8, d9, d10, d11, d12, d30, d29, 1))) {
                dArray[n2] = d30;
                dArray2[n2] = d29;
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    private int evaluateTwoQuadraticEquations(double[] dArray, double[] dArray2, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9;
        ToolAlgebra1D toolAlgebra1D = this.__evaluateTwoQuadraticEquations_ToolAlgebra1D_3;
        toolAlgebra1D.set(d2 * d5 - d * d6, d2 * d7 - d6 * d3 + d5 * d4 - d * d8, d7 * d4 - d3 * d8);
        int n = toolAlgebra1D.solve();
        if (n == 1) {
            dArray[0] = toolAlgebra1D.getSolution(0);
            d9 = d * dArray[0] + d3;
            dArray2[0] = ToolAlgebra2DQuadratic.compare(d9) == 0 ? 0.0 : -(d2 * dArray[0] + d4) / d9;
        }
        if (n == 2) {
            dArray[1] = toolAlgebra1D.getSolution(1);
            d9 = d * dArray[1] + d3;
            dArray2[1] = ToolAlgebra2DQuadratic.compare(d9) == 0 ? 0.0 : -(d2 * dArray[1] + d4) / d9;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        ToolAlgebra2DQuadratic.test2();
    }

    public static void test1() {
        ToolAlgebra2DQuadratic toolAlgebra2DQuadratic = new ToolAlgebra2DQuadratic();
        ToolAlgebra2DQuadratic toolAlgebra2DQuadratic2 = new ToolAlgebra2DQuadratic();
        toolAlgebra2DQuadratic.circle(0.0, 0.0, 10.0);
        toolAlgebra2DQuadratic2.circle(15.0, 0.0, 10.0);
        int n = toolAlgebra2DQuadratic.solve(toolAlgebra2DQuadratic2);
        int n2 = 0;
        while (n2 < n) {
            System.out.println("( " + toolAlgebra2DQuadratic.getSolutionX(n2) + ", " + toolAlgebra2DQuadratic.getSolutionY(n2) + " )");
            ++n2;
        }
    }

    public static void test2() {
        ToolAlgebra2DQuadratic toolAlgebra2DQuadratic = new ToolAlgebra2DQuadratic();
        ToolAlgebra2DQuadratic toolAlgebra2DQuadratic2 = new ToolAlgebra2DQuadratic();
        toolAlgebra2DQuadratic.circle(0.0, 0.0, 10.0);
        toolAlgebra2DQuadratic2.ellipse(0.0, 0.0, 20.0, 5.0);
        int n = toolAlgebra2DQuadratic.solve(toolAlgebra2DQuadratic2);
        int n2 = 0;
        while (n2 < n) {
            System.out.println("( " + toolAlgebra2DQuadratic.getSolutionX(n2) + ", " + toolAlgebra2DQuadratic.getSolutionY(n2) + " )");
            ++n2;
        }
    }
}

