/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui.table;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import jp.kitec.richui.table.Cell;
import jp.kitec.richui.table.CellGroup;
import jp.kitec.richui.table.CellType;
import jp.kitec.richui.table.Table;

public class MiddleColumnHeaderTable
extends Table {
    protected CellGroup mMiddleColumnHeaders;
    protected int[] mMiddleColumnHeadersLink;

    public MiddleColumnHeaderTable() {
    }

    public MiddleColumnHeaderTable(int[][] nArray) {
        super(nArray);
    }

    public MiddleColumnHeaderTable(boolean bl) {
        super(bl);
    }

    public void init() {
        if (this.mMiddleColumnHeaders != null) {
            this.mMiddleColumnHeaders.removeAllCells();
        }
        this.mMiddleColumnHeadersLink = null;
        this.mColumnHeaders.removeAllCells();
        this.mCells.clear();
        this.mRowHeaders.removeAllCells();
        this.mTableWidth = 0;
        this.mTableHeight = 0;
        this.mRowHeaderWidth = 0;
        this.mRowHeight = 0;
        this.mFirstRow = 0;
        this.mTotalColumnWidth = 0;
        this.mHScrollValue = 0;
        this.mVScrollValue = 0;
        this.mColumnWidths = null;
        this.mColumnCount = 0;
        this.mRowCount = 0;
        this.mHScrollbarWidth = 0;
        this.mVScrollbarHeight = 0;
        this.mDraggedX = 0;
        this.mDraggedColumn = 0;
        this.mEditorX = 0;
        this.mEditorY = 0;
        this.mEditorWidth = 0;
        this.mSelectedRow = -1;
        this.mSelectedColumn = -1;
        this.mAutoResizeColumnWidth = true;
        this.mIsResized = true;
        this.mColumnAlignments = null;
        this.mIsColumnEditables = null;
        if (this.mSrlHorizontal != null) {
            this.mSrlHorizontal.setValue(0);
        }
        if (this.mSrlVertical != null) {
            this.mSrlVertical.setValue(0);
        }
    }

    public void dispose() {
        this.disposeOffImage();
        if (this.mMiddleColumnHeaders != null) {
            this.mMiddleColumnHeaders.removeAllCells();
        }
        this.mMiddleColumnHeadersLink = null;
        this.mColumnHeaders.removeAllCells();
        this.mColumnHeaders = null;
        this.mCells.clear();
        this.mCells = null;
        this.mRowHeaders.removeAllCells();
        this.mRowHeaders = null;
        this.mColumnWidths = null;
        this.mFontMetrics = null;
        this.mColumnAlignments = null;
        this.mIsColumnEditables = null;
    }

    public void setMiddleColumnHeader(String[] stringArray) {
        this.mMiddleColumnHeaders = new CellGroup(stringArray);
        this.mMiddleColumnHeadersLink = new int[stringArray.length];
        this.mMiddleColumnHeadersLink[0] = 0;
        for (int i = 1; i < stringArray.length; ++i) {
            this.mMiddleColumnHeadersLink[i] = stringArray[i - 1] != null && stringArray[i] != null && stringArray[i - 1].equals(stringArray[i]) ? this.mMiddleColumnHeadersLink[i - 1] : i;
        }
    }

    public String getMiddleColumnHeader(int n) {
        if (this.mMiddleColumnHeaders == null) {
            return null;
        }
        return this.mMiddleColumnHeaders.getCell(n).getValue();
    }

    public void removeColumn(int n) {
        int n2;
        int n3 = this.mSelectedRow;
        if (this.mSelectedRow >= 0) {
            this.clearSelection();
        }
        for (n2 = 0; n2 < this.mColumnCount; ++n2) {
            CellGroup cellGroup = this.getRow(n2);
            cellGroup.removeCell(n);
        }
        this.mColumnHeaders.removeCell(n);
        n2 = 0;
        for (int i = 0; i < this.mColumnCount; ++i) {
            if (this.mMiddleColumnHeadersLink[i] != n) continue;
            ++n2;
        }
        if (n2 == 1) {
            int[] nArray = new int[this.mMiddleColumnHeadersLink.length - 1];
            int n4 = 0;
            for (n2 = 0; n2 < this.mColumnCount; ++n2) {
                if (this.mMiddleColumnHeadersLink[n2] == n) {
                    this.mMiddleColumnHeaders.removeCell(n2);
                    continue;
                }
                nArray[n4++] = this.mMiddleColumnHeadersLink[n2];
            }
            this.mMiddleColumnHeadersLink = nArray;
        }
        int n5 = this.mColumnCount - 1;
        boolean[] blArray = new boolean[n5];
        int[] nArray = new int[n5];
        this.mColumnWidths = new int[n5];
        int n6 = 0;
        for (n5 = 0; n5 < this.mColumnCount; ++n5) {
            if (n5 == n) continue;
            blArray[n6] = this.mIsColumnEditables[n5];
            nArray[n6] = this.mColumnAlignments[n5];
            this.mColumnWidths[n6] = 100;
            ++n6;
        }
        this.mIsColumnEditables = blArray;
        this.mColumnAlignments = this.mColumnWidths;
        --this.mColumnCount;
        this.calculateAllColumnWidths();
        this.adjustScroll();
        this.selectRow(n3);
    }

    protected boolean drawMiddleColumnHeader(Graphics graphics) {
        if (this.mMiddleColumnHeadersLink == null) {
            return false;
        }
        int n = this.mRowHeaderWidth - this.mHScrollValue;
        for (int i = 0; i < this.mColumnCount; ++i) {
            int n2;
            int n3 = this.mColumnWidths[i];
            for (n2 = i + 1; n2 < this.mColumnCount && this.mMiddleColumnHeadersLink[i] == this.mMiddleColumnHeadersLink[n2]; ++n2) {
                n3 += this.mColumnWidths[n2];
                ++i;
            }
            graphics.setColor(COLOR_HEADER_BACKGROUND);
            graphics.fillRect(n + 1, 0, n3 - 2, this.mRowHeight);
            graphics.setColor(COLOR_HEADER_TEXT);
            String string = this.mMiddleColumnHeaders.getCell(i).getValue();
            n2 = n + n3 / 2 - this.mFontMetrics.stringWidth(string) / 2;
            if (n2 < n + 3) {
                n2 = n + 3;
            }
            if (string != null && !string.equals("")) {
                graphics.drawString(string, n2, this.mRowHeight - 4 + 1);
                graphics.setColor(COLOR_TABLE_BORDER);
                graphics.drawLine(n + n3 - 1, 0, n + n3 - 1, this.mRowHeight - 1);
                graphics.setColor(COLOR_HEADER_LTBACKGROUND);
                graphics.drawLine(n + n3, 0, n + n3, this.mRowHeight - 1);
                graphics.drawLine(n, 2, n + n3 - 2, 2);
            }
            n += n3;
        }
        graphics.setColor(COLOR_HEADER_BACKGROUND);
        graphics.fillRect(0, 0, this.mRowHeaderWidth + 1, this.mRowHeight);
        graphics.fillRect(n + 1, 0, this.mTableWidth - n, this.mRowHeight);
        graphics.drawLine(0, 0, 0, this.mRowHeight - 1);
        return true;
    }

    protected void calculateEditotPosition() {
        if (this.mSelectedColumn == -1) {
            return;
        }
        int n = -this.mHScrollValue;
        for (int i = 0; i < this.mSelectedColumn; ++i) {
            int n2 = this.mColumnWidths[i];
            n += n2;
        }
        this.mEditorX = n + this.mRowHeaderWidth;
        this.mEditorY = (this.mSelectedRow - this.mFirstRow + 1 + (this.mMiddleColumnHeadersLink != null ? 1 : 0)) * this.mRowHeight;
        this.mEditorWidth = 0;
        if (this.mColumnWidths != null) {
            this.mEditorWidth = this.mColumnWidths[this.mSelectedColumn];
        }
    }

    protected void drawColumnHeader(Graphics graphics) {
        int n = this.mRowHeaderWidth - this.mHScrollValue;
        int n2 = 0;
        if (this.drawMiddleColumnHeader(graphics)) {
            n2 = this.mRowHeight + 1;
        }
        for (int i = 0; i < this.mColumnCount; ++i) {
            int n3 = this.mColumnWidths[i];
            graphics.setColor(COLOR_HEADER_BACKGROUND);
            graphics.fillRect(n + 1, n2, n3 - 2, this.mRowHeight);
            graphics.setColor(COLOR_HEADER_TEXT);
            String string = this.mColumnHeaders.getCell(i).getValue();
            int n4 = n + n3 / 2 - this.mFontMetrics.stringWidth(string) / 2;
            if (n4 < n + 3) {
                n4 = n + 3;
            }
            graphics.drawString(string, n4, n2 + this.mRowHeight - 4 + 1);
            graphics.setColor(COLOR_TABLE_BORDER);
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + this.mRowHeight - 1);
            graphics.setColor(COLOR_HEADER_LTBACKGROUND);
            graphics.drawLine(n + n3, n2, n + n3, n2 + this.mRowHeight - 1);
            graphics.drawLine(n, n2 + 2, n + n3 - 2, n2 + 2);
            n += n3;
        }
        graphics.setColor(COLOR_HEADER_BACKGROUND);
        graphics.fillRect(0, n2, this.mRowHeaderWidth + 1, this.mRowHeight);
        graphics.fillRect(n + 1, n2, this.mTableWidth - n, this.mRowHeight);
        graphics.drawLine(0, n2, 0, n2 + this.mRowHeight - 1);
    }

    protected void drawRows(Graphics graphics) {
        int n;
        int n2 = 0;
        for (n = this.mRowHeight + 1 - this.mVScrollValue; n < this.mRowHeight + 1; n += this.mRowHeight) {
            ++n2;
        }
        this.mFirstRow = n2;
        if (this.mMiddleColumnHeadersLink != null) {
            n += this.mRowHeight + 1;
        }
        while (n < this.mTableHeight && n2 < this.mRowCount) {
            int n3 = this.mRowHeaderWidth - this.mHScrollValue;
            for (int i = 0; i < this.mColumnCount; ++i) {
                Object object = this.getCell(n2, i);
                object = this.mSelectedRow == n2 ? COLOR_SELECTED_ROW : this.getTableBackgoundColor(((Cell)object).getType());
                graphics.setColor((Color)object);
                int n4 = this.mColumnWidths[i];
                graphics.fillRect(n3, n, n4 - 1, this.mRowHeight - 1);
                graphics.setColor(COLOR_CELL_TEXT);
                String string = this.getValueAt(n2, i);
                int n5 = this.mFontMetrics.stringWidth(string);
                if (n5 + 6 < n4) {
                    switch (this.getAlignment(n2, i)) {
                        case 1: {
                            n5 = n3 + (n4 - n5) / 2;
                            break;
                        }
                        case 2: {
                            n5 = n3 + n4 - n5 - 3;
                            break;
                        }
                        default: {
                            n5 = n3 + 3;
                            break;
                        }
                    }
                } else {
                    n5 = n3 + 3;
                }
                graphics.drawString(string, n5, n + this.mRowHeight - 4);
                graphics.setColor(COLOR_CELL_BORDER);
                graphics.drawLine(n3 + n4 - 1, n, n3 + n4 - 1, n + this.mRowHeight - 1);
                graphics.drawLine(n3, n + this.mRowHeight - 1, n3 + n4 - 1, n + this.mRowHeight - 1);
                n3 += n4;
            }
            this.drawRowHeader(graphics, this.mRowHeaders.getCell(n2).getValue(), n3, n);
            ++n2;
            n += this.mRowHeight;
        }
    }

    public class MouseClickListener
    extends MouseAdapter {
        protected int clickCount = 2;
        private /* synthetic */ MiddleColumnHeaderTable aV;

        protected MouseClickListener(MiddleColumnHeaderTable middleColumnHeaderTable) {
            this.aV = middleColumnHeaderTable;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            int n2;
            int n3 = mouseEvent.getX();
            int n4 = mouseEvent.getY();
            if (this.aV.mRowHeight == 0 || n3 > this.aV.mTableWidth || n4 > this.aV.mTableHeight) {
                this.aV.mSelectedRow = -1;
                this.aV.clearSelection();
                return;
            }
            n3 += this.aV.mHScrollValue - this.aV.mRowHeaderWidth;
            int n5 = -1;
            for (n = 0; n < this.aV.mColumnCount; n3 -= n2, ++n) {
                n2 = this.aV.mColumnWidths[n];
                if (n3 < 0 || n3 > n2) continue;
                n5 = n;
                break;
            }
            if (this.aV.mEditor.isEnabled()) {
                this.aV.select(-1, -1);
            }
            if (n4 < this.aV.mRowHeight) {
                return;
            }
            n = n4 / this.aV.mRowHeight - 1 + this.aV.mFirstRow + (this.aV.mMiddleColumnHeadersLink != null ? -1 : 0);
            if (mouseEvent.getX() < this.aV.mRowHeaderWidth && n4 < this.aV.mRowHeight * (this.aV.mRowCount + 1)) {
                this.aV.selectRow(n);
                return;
            }
            if (n >= 0 && n < this.aV.mRowCount) {
                if (n5 >= 0 && n5 < this.aV.mColumnCount) {
                    Cell cell = this.aV.getCell(n, n5);
                    if (cell.getType() == CellType.BUTTON) {
                        this.aV.select(n, n5);
                        cell.getClickAction().doAction();
                        return;
                    }
                    if (mouseEvent.getClickCount() >= this.clickCount) {
                        this.aV.select(n, n5);
                        return;
                    }
                    this.aV.selectRow(n);
                    return;
                }
                this.aV.select(n, -1);
                return;
            }
            this.aV.mSelectedRow = -1;
            this.aV.clearSelection();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getX() > this.aV.mTableWidth) {
                this.aV.setCursor(new Cursor(0));
            }
        }

        public void setClickCount(int n) {
            this.clickCount = n;
        }
    }
}

