/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.SystemColor;
import jp.kitec.kwt.KFont;

public class GroupBox2
extends Panel {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private String S;
    private int aj = 0;
    private Insets ak = new Insets(2, 2, 2, 2);
    private Color al;
    private Color am;
    private Color an;
    private Color ao;
    private Color ap;

    public GroupBox2(Component component, String string) {
        this.S = string;
        this.setLayout(new BorderLayout());
        this.add(component, "Center");
        this.an = SystemColor.controlLtHighlight;
        this.am = SystemColor.controlShadow;
        this.ao = SystemColor.controlLtHighlight;
        this.ap = SystemColor.controlShadow;
    }

    public GroupBox2(Component component, String string, int n) {
        this(component, string);
        this.aj = n;
    }

    public void setColor(Color color, Color color2) {
        this.al = color;
        this.setForeground(this.al);
        this.an = color2.brighter();
        this.am = color2.darker();
    }

    public void setInsets(Insets insets) {
        if (insets != null) {
            this.ak = insets;
        }
    }

    public Insets getInsets() {
        Graphics graphics = this.getGraphics();
        int n = graphics.getFont().getSize();
        if (n > this.ak.top) {
            this.ak.top = n;
        }
        graphics.dispose();
        return new Insets(this.ak.top, this.ak.left, this.ak.bottom, this.ak.right);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.drawBorder(graphics);
        this.drawTitle(graphics);
    }

    public void drawBorder(Graphics graphics) {
        graphics.setFont(this.getFont());
        Font font = graphics.getFont();
        int n = font.getSize();
        graphics.setColor(this.ao);
        graphics.setColor(this.an);
        graphics.drawRect(1, n / 2 + 1, this.getWidth() - 2, this.getHeight() - 2 - n / 2);
        graphics.drawRect(0, n / 2, this.getWidth() - 2 + 1, this.getHeight() - 2 - n / 2 + 1);
        graphics.setColor(this.ap);
        graphics.setColor(this.am);
        graphics.drawRect(0, n / 2, this.getWidth() - 2, this.getHeight() - 2 - n / 2);
    }

    public void drawTitle(Graphics graphics) {
        int n;
        if (this.S == null || this.S.length() <= 0) {
            return;
        }
        KFont kFont = KFont.getFont((Object)graphics.getFont());
        int n2 = kFont.stringWidth(this.S);
        if (n2 + ((n = kFont.stringWidth("\u3042") / 2) << 1) + 2 > this.getWidth()) {
            return;
        }
        int n3 = n2 + (n << 1);
        switch (this.aj) {
            case 2: {
                n2 = this.getWidth() - n2 - n * 3;
                break;
            }
            case 1: {
                n2 = this.getWidth() / 2 - n2 / 2 - n;
                break;
            }
            default: {
                n2 = n;
            }
        }
        graphics.setColor(this.getBackground());
        graphics.clearRect(n2, 0, n3, kFont.getHeight());
        graphics.setColor(this.getForeground());
        graphics.drawString(this.S, n2 + n, kFont.getAscent() - 2);
    }
}

