/*
 * Decompiled with CFR 0.152.
 */
package com.kt.gui.tree;

import com.kt.gui.event.ActionContainer;
import com.kt.gui.event.ActionItem;
import com.kt.gui.tree.FolderItem;
import com.kt.gui.tree.NodeItem;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import jp.kitec.kwt.KFont;

public class TreeView
extends Panel
implements AdjustmentListener,
FocusListener,
MouseListener {
    protected ActionContainer mActionContainer = null;
    protected Vector mItem;
    private Rectangle a;
    private static int b = 5;
    protected static int mSpace = 2;
    protected static int mTab = 20;
    protected KFont mFont;
    protected Scrollbar mHbar;
    protected Scrollbar mVbar;
    protected Point mScroll;
    private Image mOffImage = null;
    private Graphics c = null;
    private int mWidth = -1;
    private int mHeight = -1;
    private int d = -1;
    private int e = -1;
    protected NodeItem mActiveItem = null;
    protected PopupMenu mPopup;
    protected boolean mDispPop = false;
    protected int mMaxIndex = 0;
    protected boolean mPanintLock = false;
    private Object f;
    protected Object mPresTmp = null;

    public TreeView(KFont kFont, ActionContainer actionContainer) {
        this.setLayout(new BorderLayout());
        this.setActionContainer(actionContainer);
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.mVbar = new Scrollbar(1);
        this.mHbar = new Scrollbar(0);
        this.add((Component)this.mVbar, "East");
        this.add((Component)this.mHbar, "South");
        this.mFont = kFont;
        this.mItem = new Vector();
        this.a = new Rectangle(0, 0, 0, 0);
        this.setFont(kFont.getFontObject());
        this.mScroll = new Point(0, 0);
        this.addMouseListener(this);
        this.mVbar.addAdjustmentListener(this);
        this.mHbar.addAdjustmentListener(this);
        this.updatePos();
        this.addFocusListener(this);
        this.mPopup = new PopupMenu();
        this.add(this.mPopup);
    }

    public void setActionContainer(ActionContainer actionContainer) {
        this.mActionContainer = actionContainer;
    }

    public void openFolder(FolderItem folderItem) {
        if (folderItem == null) {
            for (int i = 0; i < this.mItem.size(); ++i) {
                Object e = this.mItem.elementAt(i);
                if (!(e instanceof FolderItem) || ((FolderItem)e).isOpen()) continue;
                ((FolderItem)e).flipOpen();
            }
        } else if (!folderItem.isOpen()) {
            folderItem.flipOpen();
        }
        this.updatePos();
    }

    public void closeAll() {
        this.close(null);
        this.updatePos();
        this.repaint();
    }

    public void close(FolderItem object) {
        if ((object = object == null ? this.mItem : object.getItems()) != null && ((Vector)object).size() > 0) {
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                NodeItem nodeItem = (NodeItem)((Vector)object).elementAt(i);
                if (!(nodeItem instanceof FolderItem)) continue;
                if ((nodeItem = (FolderItem)nodeItem).isOpen()) {
                    nodeItem.flipOpen();
                }
                this.close((FolderItem)nodeItem);
            }
        }
    }

    public void pickup(String string) {
        for (int i = 0; i < this.mItem.size(); ++i) {
            NodeItem nodeItem = (NodeItem)this.mItem.elementAt(i);
            this.a(nodeItem, string);
        }
        this.mScroll.x = 0;
        this.mScroll.y = 0;
        this.mVbar.setValue(0);
        this.mHbar.setValue(0);
        this.updatePos();
        this.repaint();
    }

    private boolean a(NodeItem nodeItem, String string) {
        boolean bl = false;
        if (string == null) {
            bl = true;
        }
        if (nodeItem instanceof FolderItem) {
            nodeItem = (FolderItem)nodeItem;
            if (string == null) {
                nodeItem.setVisible(true);
            }
            for (int i = 0; i < nodeItem.getItems().size(); ++i) {
                boolean bl2 = this.a((NodeItem)nodeItem.getItems().elementAt(i), string);
                bl |= bl2;
            }
            nodeItem.setVisible(bl);
        } else if (string == null) {
            nodeItem.setVisible(true);
            bl = true;
        } else if (nodeItem.getTitle().indexOf(string) >= 0) {
            nodeItem.setVisible(true);
            bl = true;
        } else {
            nodeItem.setVisible(false);
        }
        return bl;
    }

    public void deleteAll() {
        this.mItem.removeAllElements();
        this.mActiveItem = null;
    }

    public void updatePos() {
        int n;
        this.a.width = b;
        this.a.height = b;
        this.mMaxIndex = 0;
        for (int i = 0; i < this.mItem.size(); ++i) {
            this.a(this.mItem.elementAt(i), this.a.x, this.a.y + this.a.height);
        }
        TreeView treeView = this;
        if (treeView.mVbar.isVisible()) {
            treeView.a.width += treeView.mVbar.getSize().width;
        }
        if (treeView.mHbar.isVisible()) {
            treeView.a.height += treeView.mHbar.getSize().height;
        }
        treeView = this;
        Dimension dimension = treeView.getSize();
        if (treeView.mWidth > 0 && dimension.width < treeView.a.width) {
            n = (int)((float)dimension.width / (float)treeView.a.width * (float)(treeView.a.width - dimension.width));
            treeView.mHbar.setValues(treeView.mScroll.x, n, 0, treeView.a.width - dimension.width + n);
            treeView.mHbar.setUnitIncrement((treeView.a.width - dimension.width) / 5);
            treeView.mHbar.setVisible(true);
        } else {
            treeView.mHbar.setVisible(false);
            treeView.mScroll.x = 0;
        }
        if (treeView.mHeight > 0 && dimension.height < treeView.a.height) {
            n = (int)((float)dimension.height / (float)treeView.a.height * (float)(treeView.a.height - dimension.height));
            treeView.mVbar.setValues(treeView.mScroll.y, n, 0, treeView.a.height - dimension.height + n);
            treeView.mVbar.setUnitIncrement((int)treeView.mFont.getSize());
            treeView.mVbar.setUnitIncrement(5);
            treeView.mVbar.setVisible(true);
        } else {
            treeView.mVbar.setVisible(false);
            treeView.mScroll.y = 0;
        }
        treeView.doLayout();
        if (this.mVbar.isVisible() || this.mHbar.isVisible()) {
            int n2 = this.mHbar.isVisible() ? -this.mScroll.x : 0;
            int n3 = this.mVbar.isVisible() ? -this.mScroll.y : 0;
            for (n = 0; n < this.mItem.size(); ++n) {
                this.setOffset(this.mItem.elementAt(n), n2, n3);
            }
        }
        this.mVbar.setBlockIncrement(this.mVbar.getVisibleAmount());
        this.mHbar.setBlockIncrement(this.mHbar.getVisibleAmount());
    }

    public void folderOpenClose() {
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.mOffImage == null || dimension.width != this.mWidth || dimension.height != this.mHeight) {
            this.mOffImage = this.createImage(dimension.width, dimension.height);
            this.c = this.mOffImage.getGraphics();
            this.mWidth = dimension.width;
            this.mHeight = dimension.height;
            this.updatePos();
        }
        this.c.setColor(this.getBackground());
        this.c.fillRect(0, 0, dimension.width - 1, dimension.height);
        for (int i = 0; i < this.mItem.size(); ++i) {
            NodeItem nodeItem;
            if (this.mItem.elementAt(i) == null || !(nodeItem = (NodeItem)this.mItem.elementAt(i)).isVisible()) continue;
            this.a(this.c, this.mItem.elementAt(i));
        }
        this.c.setColor(Color.lightGray);
        this.c.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        graphics.drawImage(this.mOffImage, 0, 0, this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void a(Object object, int n, int n2) {
        if (object instanceof NodeItem && !((NodeItem)object).isVisible()) {
            ((NodeItem)object).mIndex = -1;
            return;
        }
        NodeItem nodeItem = (NodeItem)object;
        ((NodeItem)object).mIndex = this.mMaxIndex++;
        Rectangle rectangle = ((NodeItem)object).setPosition(n, n2);
        if (this.a.width < rectangle.x + rectangle.width) {
            this.a.width = rectangle.x + rectangle.width;
        }
        if (this.a.height < rectangle.y + rectangle.height) {
            this.a.height = rectangle.y + rectangle.height;
        }
        if (this.isFolder(object) && (object = (FolderItem)object).isOpen()) {
            n += mTab;
            for (int i = 0; i < object.getItems().size(); ++i) {
                this.a(object.getItems().elementAt(i), n, this.a.height);
            }
        }
    }

    protected void setOffset(Object object, int n, int n2) {
        object = (NodeItem)object;
        Rectangle rectangle = object.getPosition();
        rectangle.x += n;
        rectangle.y += n2;
        if (this.isFolder(object) && (object = (FolderItem)object).isOpen()) {
            for (int i = 0; i < object.getItems().size(); ++i) {
                this.setOffset(object.getItems().elementAt(i), n, n2);
            }
        }
    }

    private void a(Graphics graphics, Object object) {
        if (object == null) {
            return;
        }
        graphics.setColor(this.getForeground());
        if (this.isFolder(object)) {
            object = (FolderItem)object;
            this.drawNode(graphics, (NodeItem)object);
            if (object.isOpen() && object.isVisible()) {
                int n = object.getPosition().y + object.getPosition().height;
                int n2 = 0;
                for (int i = 0; i < object.getItems().size(); ++i) {
                    NodeItem nodeItem = (NodeItem)object.getItems().elementAt(i);
                    if (!nodeItem.isVisible()) continue;
                    this.a(graphics, nodeItem);
                    n2 = nodeItem.getPosition().y + nodeItem.getPosition().height / 2;
                    if (this.isFolder(nodeItem)) {
                        TreeView.drawLineX(graphics, object.getPosition().x + mTab / 2 + mSpace + 1 + 4, n2, nodeItem.getPosition().x, Color.black);
                        TreeView.drawLineY(graphics, object.getPosition().x + mTab / 2 + mSpace, n + 4, n2 - 4, Color.black);
                        n = n2;
                        n2 = 8;
                        n2 = 8;
                        int n3 = n - 4;
                        int n4 = object.getPosition().x + mTab / 2 + mSpace - 4;
                        boolean bl = ((FolderItem)nodeItem).isOpen();
                        Graphics graphics2 = graphics;
                        graphics2.drawRect(n4, n3, 8, 8);
                        graphics2.drawLine(n4 + 2, n3 + 4, n4 + 8 - 2, n3 + 4);
                        if (bl) continue;
                        graphics2.drawLine(n4 + 4, n3 + 2, n4 + 4, n3 + 8 - 2);
                        continue;
                    }
                    TreeView.drawLineX(graphics, object.getPosition().x + mTab / 2 + mSpace + 1, n2, nodeItem.getPosition().x, Color.black);
                    TreeView.drawLineY(graphics, object.getPosition().x + mTab / 2 + mSpace, n, n2, Color.black);
                    n = n2;
                }
            }
            return;
        }
        object = (NodeItem)object;
        this.drawNode(graphics, (NodeItem)object);
    }

    protected void drawNode(Graphics graphics, NodeItem nodeItem) {
        if (nodeItem instanceof FolderItem) {
            nodeItem.paint(graphics);
            return;
        }
        if (nodeItem.isVisible()) {
            nodeItem.paint(graphics);
        }
    }

    protected Object isHit(int n, int n2) {
        for (int i = 0; i < this.mItem.size(); ++i) {
            Object object;
            if (this.mItem.elementAt(i) == null || (object = this.b(this.mItem.elementAt(i), n, n2)) == null) continue;
            return object;
        }
        return null;
    }

    private Object b(Object object, int n, int n2) {
        if (!(object = (NodeItem)object).isVisible()) {
            return null;
        }
        Rectangle rectangle = object.getPosition();
        if (rectangle.contains(n, n2)) {
            return object;
        }
        if (this.isFolder(object)) {
            int n3 = rectangle.x - 8;
            int n4 = rectangle.y + rectangle.height / 2;
            if (Math.abs(n - n3) <= 4 && Math.abs(n2 - n4) <= 4) {
                return object;
            }
            if ((object = (FolderItem)object).isOpen()) {
                for (n4 = 0; n4 < object.getItems().size(); ++n4) {
                    Object object2 = this.b(object.getItems().elementAt(n4), n, n2);
                    if (object2 == null) continue;
                    return object2;
                }
            }
        }
        return null;
    }

    protected boolean isFolder(Object object) {
        return object instanceof FolderItem;
    }

    protected static void drawLineX(Graphics graphics, int n, int n2, int n3, Color color) {
        graphics.setColor(color);
        while (n < n3) {
            graphics.drawLine(n, n2, n, n2);
            n += 2;
        }
    }

    protected static void drawLineY(Graphics graphics, int n, int n2, int n3, Color color) {
        graphics.setColor(color);
        while (n2 < n3) {
            graphics.drawLine(n, n2, n, n2);
            n2 += 2;
        }
    }

    public void conv(ObjectFolder objectFolder, Image image, Image image2, Image image3) {
        for (int i = 0; i < objectFolder.getChildlen().size(); ++i) {
            this.a(null, (ObjectNode)objectFolder.getChildlen().elementAt(i), image, image2, image3);
        }
    }

    private NodeItem a(FolderItem folderItem, ObjectNode objectNode, Image image, Image image2, Image image3) {
        if (objectNode instanceof ObjectFolder) {
            folderItem = this.addFolder(folderItem, objectNode.getName(), image2, image);
            for (int i = 0; i < ((ObjectFolder)objectNode).getChildlen().size(); ++i) {
                ObjectNode objectNode2 = (ObjectNode)((ObjectFolder)objectNode).getChildlen().elementAt(i);
                this.a(folderItem, objectNode2, image, image2, image3);
            }
            return folderItem;
        }
        return this.addNode(folderItem, objectNode.getName(), image3);
    }

    public NodeItem addNode(Object object, String string, Image image) {
        string = new NodeItem(object, string, image, mSpace, this.mFont);
        if (object == null) {
            this.mItem.addElement(string);
        } else if (this.isFolder(object)) {
            ((FolderItem)object).addChild((Object)string);
        }
        return string;
    }

    public FolderItem addFolder(Object object, String string, Image image, Image image2) {
        string = new FolderItem(object, string, image, image2, mSpace, this.mFont);
        if (object == null) {
            this.mItem.addElement(string);
        } else if (this.isFolder(object)) {
            ((FolderItem)object).addChild((Object)string);
        }
        return string;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.d > 0) {
            dimension.width = this.d;
        }
        if (this.e > 0) {
            dimension.height = this.e;
        }
        return dimension;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.f != null) {
            this.mActionContainer.actionlostfocus((ActionItem)((NodeItem)this.f));
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mPresTmp = this.isHit(mouseEvent.getX(), mouseEvent.getY());
        if (!this.isFolder(this.mPresTmp)) {
            mouseEvent = (NodeItem)this.mPresTmp;
            if (mouseEvent == null) {
                return;
            }
            if (mouseEvent != this.mActiveItem) {
                if (this.mActiveItem != null) {
                    this.mActiveItem.setActive(false);
                }
                mouseEvent.setActive(true);
                this.mActiveItem = mouseEvent;
                if (!this.mPanintLock) {
                    this.repaint();
                }
            }
        }
    }

    public void mouseReleased(MouseEvent object) {
        if ((object = this.isHit(((MouseEvent)object).getX(), ((MouseEvent)object).getY())) != null && object == this.mPresTmp) {
            if (this.isFolder(this.mPresTmp)) {
                ((FolderItem)this.mPresTmp).flipOpen();
                this.folderOpenClose();
                this.updatePos();
                if (!this.mPanintLock) {
                    this.repaint();
                }
            } else {
                object = (NodeItem)this.mPresTmp;
                if (object != this.mActiveItem) {
                    if (this.mActiveItem != null) {
                        this.mActiveItem.setActive(false);
                    }
                    object.setActive(true);
                    this.mActiveItem = object;
                    if (!this.mPanintLock) {
                        this.repaint();
                    }
                }
                this.mActionContainer.actionperform((ActionItem)object);
            }
        }
        this.mPresTmp = null;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent object) {
        if ((object = this.isHit(((MouseEvent)object).getX(), ((MouseEvent)object).getY())) == this.f) {
            return;
        }
        if (object != this.f && this.f != null) {
            this.mActionContainer.actionlostfocus((ActionItem)((NodeItem)this.f));
        }
        if (object == null || object instanceof FolderItem) {
            this.f = null;
            this.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        this.f = object;
        this.mActionContainer.actionfocus((ActionItem)((NodeItem)this.f));
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.mVbar) {
            this.mScroll.y = adjustmentEvent.getValue();
        } else if (adjustmentEvent.getSource() == this.mHbar) {
            this.mScroll.x = adjustmentEvent.getValue();
        }
        this.updatePos();
        if (!this.mPanintLock) {
            this.repaint();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.mDispPop = false;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.mDispPop = false;
    }

    protected synchronized void goPop(MouseEvent mouseEvent) {
        this.createContext();
        if (this.mPopup.getItemCount() != 0) {
            this.mDispPop = true;
            this.mPopup.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected void createContext() {
    }

    protected NodeItem getNextItem(NodeItem nodeItem) {
        int n = nodeItem.mIndex;
        if (n + 1 >= this.mMaxIndex) {
            return null;
        }
        return this.searchIndex(n + 1);
    }

    protected NodeItem getPrevItem(NodeItem nodeItem) {
        int n = nodeItem.mIndex;
        if (n == 0) {
            return null;
        }
        return this.searchIndex(n - 1);
    }

    protected NodeItem searchIndex(int n) {
        for (int i = 0; i < this.mItem.size(); ++i) {
            NodeItem nodeItem = this.searchIndex(n, (NodeItem)this.mItem.elementAt(i));
            if (nodeItem == null) continue;
            return nodeItem;
        }
        return null;
    }

    protected NodeItem searchIndex(int n, NodeItem nodeItem) {
        if (nodeItem.mIndex == n) {
            return nodeItem;
        }
        if (this.isFolder(nodeItem) && (nodeItem = (FolderItem)nodeItem).isOpen()) {
            for (int i = 0; i < nodeItem.getItems().size(); ++i) {
                NodeItem nodeItem2 = this.searchIndex(n, (NodeItem)nodeItem.getItems().elementAt(i));
                if (nodeItem2 == null) continue;
                return nodeItem2;
            }
        }
        return null;
    }

    protected void updateScrollPos() {
        if (this.mActiveItem != null && this.mVbar.isVisible()) {
            Dimension dimension = this.getSize();
            if (this.mActiveItem.getPosition().y < 0) {
                this.adjustmentValueChanged(new AdjustmentEvent(this.mVbar, 0, 0, this.mScroll.y + this.mActiveItem.getPosition().y));
            } else {
                if (this.mHbar.isVisible()) {
                    dimension.height -= this.mHbar.getHeight();
                }
                if (dimension.height - (this.mActiveItem.getPosition().y + this.mActiveItem.getPosition().height) < 0) {
                    this.adjustmentValueChanged(new AdjustmentEvent(this.mVbar, 0, 0, this.mScroll.y - (dimension.height - (this.mActiveItem.getPosition().y + this.mActiveItem.getPosition().height))));
                }
            }
            this.updatePos();
        }
    }

    protected void setVScrollPos(int n) {
        if (this.mVbar != null && this.mVbar.isVisible()) {
            this.mVbar.setValue(n);
        }
    }

    protected int getVScrollPos() {
        if (this.mVbar != null && this.mVbar.isVisible()) {
            return this.mVbar.getValue();
        }
        return 0;
    }
}

