/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.richui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import jp.kitec.kwt.KFont;

public class KTabItem {
    public static int SPACE = 4;
    int[] xx = new int[4];
    int[] yy = new int[4];
    Polygon p;
    private boolean mActive;
    private String mName;
    private KFont mFont;
    private Rectangle mBound;
    private boolean mTabDir;
    private Color mActiveColor;
    private Color mDeActiveColor;

    public KTabItem(String string, KFont kFont, Color color, Color color2, boolean bl) {
        this.mName = string;
        this.mFont = kFont;
        this.mActiveColor = color;
        this.mDeActiveColor = color2;
        this.mBound = new Rectangle();
        this.mTabDir = bl;
        this.updateBound();
        this.p = new Polygon(this.xx, this.yy, this.xx.length);
    }

    public void updateBound() {
        this.mBound.width = this.mFont.stringWidth(this.mName) + 12;
    }

    public boolean isInner(int n, int n2) {
        return this.mBound.contains(n, n2);
    }

    public boolean isActive() {
        return this.mActive;
    }

    public void setActive(boolean bl) {
        this.mActive = bl;
    }

    public Rectangle getBound() {
        return this.mBound;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String string) {
        this.mName = string;
        this.updateBound();
    }

    public void paint(Graphics graphics) {
        int n = this.mBound.x;
        int n2 = this.mBound.y;
        int n3 = this.mBound.width;
        int n4 = this.mBound.height;
        if (this.mTabDir) {
            this.p.xpoints[0] = n + n3 + SPACE;
            this.p.xpoints[1] = n + n3 - 1;
            this.p.xpoints[2] = n + 1;
            this.p.xpoints[3] = n - SPACE;
            this.p.ypoints[0] = this.p.ypoints[3] = n2 + n4 + 0;
            this.p.ypoints[1] = this.p.ypoints[2] = n2 + 0;
        } else {
            this.p.xpoints[0] = n - SPACE;
            this.p.xpoints[1] = n + 1;
            this.p.xpoints[2] = n + n3 - 1;
            this.p.xpoints[3] = n + n3 + SPACE;
            this.p.ypoints[0] = this.p.ypoints[3] = n2;
            this.p.ypoints[1] = this.p.ypoints[2] = n2 + n4;
        }
        if (this.mActive) {
            graphics.setFont(this.mFont.getFontObject());
            graphics.setColor(this.mActiveColor);
            graphics.fillPolygon(this.p);
            graphics.setColor(Color.gray);
            int n5 = 0;
            while (n5 < this.xx.length - 1) {
                graphics.drawLine(this.p.xpoints[n5], this.p.ypoints[n5], this.p.xpoints[n5 + 1], this.p.ypoints[n5 + 1]);
                ++n5;
            }
        } else {
            n2 = 1;
            graphics.setFont(this.mFont.getFontObject());
            graphics.setColor(this.mDeActiveColor);
            graphics.fillPolygon(this.p);
            graphics.setColor(Color.gray);
            int n6 = 0;
            while (n6 < this.xx.length - 1) {
                graphics.drawLine(this.p.xpoints[n6], this.p.ypoints[n6], this.p.xpoints[n6 + 1], this.p.ypoints[n6 + 1]);
                ++n6;
            }
        }
        graphics.setColor(Color.black);
        graphics.drawString(this.mName, n + 6, n4 - (n4 - this.mFont.getHeight()) / 2 - (this.mActive ? 0 : 1));
    }
}

