/*
 * Decompiled with CFR 0.152.
 */
package com.kt.util;

import com.kt.util.CharChecker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;

public class StringUtil {
    public static char[] WHITE_SPACES = new char[]{' ', '\u3000', '\t'};

    protected StringUtil() {
    }

    public static String emptyToZeroString(String string) {
        return StringUtil.emptyToDefault(string, "");
    }

    public static String emptyToDefault(String string, String string2) {
        return StringUtil.isEmpty(string) ? string2 : string;
    }

    public static String emptyToNull(String string) {
        return StringUtil.emptyToDefault(string, null);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.equals("");
    }

    public static boolean isTrimEmpty(String string) {
        return StringUtil.isEmpty(StringUtil.trim(string));
    }

    public static String trim(String string) {
        return StringUtil.trim(string, WHITE_SPACES);
    }

    public static String trim(String string, char c) {
        if (string == null) {
            return null;
        }
        return StringUtil.rightTrim(StringUtil.leftTrim(string, c), c);
    }

    public static String trim(String string, char[] cArray) {
        if (string == null) {
            return null;
        }
        if (cArray == null) {
            return null;
        }
        return StringUtil.rightTrim(StringUtil.leftTrim(string, cArray), cArray);
    }

    public static String leftTrim(String string) {
        return StringUtil.leftTrim(string, WHITE_SPACES);
    }

    public static String leftTrim(String string, char c) {
        return StringUtil.leftTrim(string, new char[]{c});
    }

    public static String leftTrim(String string, char[] cArray) {
        if (string == null) {
            return null;
        }
        if (cArray == null) {
            return string;
        }
        int n = 0;
        for (n = 0; n < string.length(); ++n) {
            boolean bl = false;
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (string.charAt(n) != c) continue;
                bl = true;
                break;
            }
            if (!bl) break;
        }
        return string.substring(n);
    }

    public static String rightTrim(String string) {
        return StringUtil.rightTrim(string, WHITE_SPACES);
    }

    public static String rightTrim(String string, char c) {
        if (string == null) {
            return null;
        }
        int n = 0;
        for (n = string.length() - 1; n >= 0 && string.charAt(n) == c; --n) {
        }
        return string.substring(0, n + 1);
    }

    public static String rightTrim(String string, char[] cArray) {
        if (string == null) {
            return null;
        }
        if (cArray == null) {
            return string;
        }
        int n = 0;
        for (n = string.length() - 1; n >= 0; --n) {
            boolean bl = false;
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (string.charAt(n) != c) continue;
                bl = true;
                break;
            }
            if (!bl) break;
        }
        return string.substring(0, n + 1);
    }

    public static String leftPad(long l, int n, char c) {
        return StringUtil.leftPad(Long.toString(l), n, c);
    }

    public static String leftPad(String string, int n, char c) {
        if (string == null) {
            return null;
        }
        int n2 = StringUtil.getByteLength(string);
        if (n2 >= n) {
            return string;
        }
        n -= n2;
        int n3 = StringUtil.getByteLength(new Character(c).toString());
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; i += n3) {
            stringBuffer.append(c);
        }
        return stringBuffer.append(string).toString();
    }

    public static String rightPad(long l, int n, char c) {
        return StringUtil.rightPad(Long.toString(l), n, c);
    }

    public static String rightPad(String string, int n, char c) {
        if (string == null) {
            return null;
        }
        int n2 = StringUtil.getByteLength(string);
        if (n2 >= n) {
            return string;
        }
        n -= n2;
        int n3 = StringUtil.getByteLength(new Character(c).toString());
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < n; i += n3) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static int countCharacter(String string, char c) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }

    public static int getByteLength(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            n += CharChecker.isAscii(string.substring(i, i + 1)) ? 1 : 2;
        }
        return n;
    }

    public static String getLimitString(String string, int n) {
        char c;
        int n2;
        int n3;
        if (string == null) {
            return null;
        }
        int n4 = 0;
        for (n3 = 0; n3 < string.length() && (n4 += (n2 = StringUtil.getByteLength(String.valueOf(c = string.charAt(n3))))) <= n; ++n3) {
        }
        return string.substring(0, n3);
    }

    public static String concat(String[] stringArray) {
        return StringUtil.concat(stringArray, null);
    }

    public static String concat(Collection collection) {
        return StringUtil.concat(collection, null);
    }

    public static String concat(String[] stringArray, String string) {
        return StringUtil.concat(Arrays.asList(stringArray), string);
    }

    public static String concat(Collection collection, String string) {
        if (collection == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (Object e : collection) {
            String string2 = e == null ? null : e.toString();
            stringBuffer.append(string2);
            if (n == collection.size() - 1) break;
            if (string != null) {
                stringBuffer.append(string);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String unquate(String string) {
        String string2 = null;
        string2 = StringUtil.unquate(string, '\"');
        if (!string.equals(string2)) {
            return string2;
        }
        string2 = StringUtil.unquate(string, '\'');
        return string2;
    }

    public static String unquate(String string, char c) {
        if (string.charAt(0) != c || string.charAt(string.length() - 1) != c) {
            return string;
        }
        return string.substring(1, string.length() - 1);
    }

    public static String[] split(String string, String string2, String string3) throws NoSuchElementException {
        Object object;
        int n = string.indexOf(string3);
        int n2 = string.lastIndexOf(string3);
        if (n < 0 || n >= n2) {
            return string.split(string2);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        while (n3 < n5) {
            int n6 = string.indexOf(string2, n3);
            int n7 = string.indexOf(string3, n3);
            if (n4 == 1) {
                if (n7 < 0) {
                    throw new NoSuchElementException("illegal quotation [" + string + "]");
                }
                arrayList.add(string.substring(n3, n7));
                n3 = n7 + 1;
                n4 = 2;
                continue;
            }
            if (n6 < 0 && n7 < 0) {
                object = string.substring(n3, n5).trim();
                if (((String)object).length() <= 0) break;
                if (n4 == 2) {
                    throw new NoSuchElementException("illegal quotation [" + string + "]");
                }
                if (n3 >= n5) break;
                arrayList.add(object);
                break;
            }
            if (n6 >= 0 && (n7 < 0 || n6 < n7)) {
                if (n4 == 2) {
                    n4 = 0;
                } else {
                    arrayList.add(string.substring(n3, n6).trim());
                }
                n3 = n6 + 1;
                continue;
            }
            if (n7 < 0) continue;
            n3 = n7 + 1;
            n4 = 1;
        }
        object = new String[arrayList.size()];
        for (int i = 0; i < ((String[])object).length; ++i) {
            object[i] = (String)arrayList.get(i);
        }
        return object;
    }
}

