/*
 * Decompiled with CFR 0.152.
 */
package com.kt.io;

import com.kt.io.DirectoryNotMadeRuntimeException;
import com.kt.io.FileIOUtil;
import com.kt.io.FileNotFoundRuntimeException;
import com.kt.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUtil {
    private static final Log A = LogFactory.getLog(FileUtil.class);

    protected FileUtil() {
    }

    public static boolean exists(String string) {
        boolean bl = false;
        try {
            File file = new File(string);
            bl = file.exists();
        }
        catch (Exception exception) {
            A.error((Object)exception.toString());
        }
        return bl;
    }

    public static boolean deleteAll(File file) {
        if (file.delete()) {
            return true;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return true;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            FileUtil.deleteAll(file2);
        }
        return file.delete();
    }

    public static String getFileName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf("\\");
        if (n > -1) {
            return string.substring(n + 1);
        }
        n = string.lastIndexOf("/");
        if (n > -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String getFileExt(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1);
    }

    public static boolean isExtMatch(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().toLowerCase();
            if (!string2.toLowerCase().equals(string3)) continue;
            return true;
        }
        return false;
    }

    public static String concatPath(String string, String string2) {
        if (string == null && string2 == null) {
            return "";
        }
        if (string == null || string.equals("")) {
            return string2;
        }
        if (string2 == null || string2.equals("")) {
            return string;
        }
        if (string.equals("") && string2.equals("")) {
            return "";
        }
        String string3 = string + "/" + string2;
        while (string3.indexOf("//") > -1) {
            string3 = string3.replaceAll("//", "/");
        }
        while (string3.indexOf("\\\\") > -1) {
            string3 = string3.replaceAll("\\\\", "/");
        }
        return string3;
    }

    public static String concatPath(String[] stringArray) {
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            string = FileUtil.concatPath(string, string2);
        }
        return string;
    }

    public static int findFile(File file) {
        int n = 0;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                n += FileUtil.findFile(file2);
            }
        } else {
            ++n;
        }
        return n;
    }

    public static File createTempDir(String string) {
        return FileUtil.createTempDir(string, null);
    }

    public static File createTempDir(String string, File file) {
        if (string == null || string.length() < 3) {
            throw new IllegalArgumentException("length of the prefix is not 3 character or more.");
        }
        String string2 = System.getProperty("java.io.tmpdir");
        if (file != null) {
            try {
                string2 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        String string3 = null;
        do {
            string3 = string2 + string + RandomStringUtils.randomAlphanumeric((int)8);
            A.debug((Object)("newTmpDirPath[" + string3 + "]"));
        } while (new File(string3).exists());
        File file2 = new File(string3);
        return file2.mkdirs() ? file2 : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File file, File file2) {
        if (!file.isFile()) {
            return false;
        }
        boolean bl = false;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            FileIOUtil.write(file2, (InputStream)bufferedInputStream);
            bl = true;
        }
        catch (Exception exception) {
            try {
                A.error((Object)"", (Throwable)exception);
            }
            catch (Throwable throwable) {
                FileIOUtil.close(bufferedInputStream);
                throw throwable;
            }
            FileIOUtil.close(bufferedInputStream);
        }
        FileIOUtil.close(bufferedInputStream);
        return bl;
    }

    public static boolean copyDir(File file, File file2) {
        if (!file.exists()) {
            throw new FileNotFoundRuntimeException(file);
        }
        if (!file.isDirectory()) {
            throw new FileNotFoundRuntimeException(file);
        }
        if (file2.isFile()) {
            throw new FileNotFoundRuntimeException(file2);
        }
        File file3 = null;
        file3 = file2.exists() ? new File(file2, file.getName()) : file2;
        if (!file3.mkdirs()) {
            throw new DirectoryNotMadeRuntimeException(file3);
        }
        boolean bl = true;
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file4 = fileArray[i];
            if (file4.isDirectory()) {
                bl = FileUtil.copyDir(file4, file3);
            } else {
                File file5 = new File(file3, file4.getName());
                bl = FileUtil.copy(file4, file5);
            }
            if (!bl) break;
        }
        return bl;
    }

    public static String createHierarchyDirName(long l, int n, int n2) {
        if (n < n2) {
            n = n2;
        }
        if (n % n2 != 0) {
            n = n2 - n % n2;
        }
        String string = StringUtil.leftPad(l, n, '0');
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n2; i <= n; i += n2) {
            String string2 = string.substring(0, i);
            stringBuilder.append('/');
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }
}

