/*
 * Decompiled with CFR 0.152.
 */
package com.kt.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileIOUtil {
    private static final Log A = LogFactory.getLog(FileIOUtil.class);

    protected FileIOUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(File file, String string) {
        String string2 = null;
        BufferedReader bufferedReader = null;
        try {
            char[] cArray;
            int n;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = ((Reader)bufferedReader).read(cArray = new char[81920], 0, 81920)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
            string2 = stringBuffer.toString();
            FileIOUtil.close(bufferedReader);
        }
        catch (Exception exception) {
            A.error((Object)"", (Throwable)exception);
        }
        finally {
            FileIOUtil.close(bufferedReader);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeText(File file, String string, String string2) {
        boolean bl = false;
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string2));
            bufferedWriter.write(string);
            ((Writer)bufferedWriter).flush();
            bl = true;
            FileIOUtil.close(bufferedWriter);
        }
        catch (Exception exception) {
            A.error((Object)"", (Throwable)exception);
        }
        finally {
            FileIOUtil.close(bufferedWriter);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean read(File file, OutputStream outputStream) {
        boolean bl = false;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            bl = FileIOUtil.write(outputStream, (InputStream)bufferedInputStream);
        }
        catch (Exception exception) {
            try {
                A.error((Object)"", (Throwable)exception);
            }
            catch (Throwable throwable) {
                FileIOUtil.close(bufferedInputStream);
                throw throwable;
            }
            FileIOUtil.close(bufferedInputStream);
        }
        FileIOUtil.close(bufferedInputStream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean write(File file, InputStream inputStream) {
        boolean bl = false;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            bl = FileIOUtil.write(bufferedOutputStream, inputStream);
        }
        catch (Exception exception) {
            try {
                A.error((Object)"", (Throwable)exception);
            }
            catch (Throwable throwable) {
                FileIOUtil.close(bufferedOutputStream);
                throw throwable;
            }
            FileIOUtil.close(bufferedOutputStream);
        }
        FileIOUtil.close(bufferedOutputStream);
        return bl;
    }

    public static boolean write(OutputStream outputStream, InputStream inputStream) {
        boolean bl = false;
        try {
            int n = 0;
            byte[] byArray = new byte[81920];
            while ((n = inputStream.read(byArray, 0, 81920)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
            bl = true;
        }
        catch (Exception exception) {
            A.error((Object)"", (Throwable)exception);
        }
        return bl;
    }

    public static byte[] fileToBytes(File file) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileIOUtil.read(file, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void bytesToFile(File file, byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        FileIOUtil.write(file, (InputStream)byteArrayInputStream);
    }

    public static boolean close(InputStream inputStream) {
        boolean bl = true;
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                bl = false;
                A.error((Object)"", (Throwable)iOException);
            }
            inputStream = null;
        }
        return bl;
    }

    public static boolean close(OutputStream outputStream) {
        boolean bl = true;
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                bl = false;
                A.error((Object)"", (Throwable)iOException);
            }
            outputStream = null;
        }
        return bl;
    }

    public static boolean close(Reader reader) {
        boolean bl = true;
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                bl = false;
                A.error((Object)"", (Throwable)iOException);
            }
            reader = null;
        }
        return bl;
    }

    public static boolean close(Writer writer) {
        boolean bl = true;
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                bl = false;
                A.error((Object)"", (Throwable)iOException);
            }
            writer = null;
        }
        return bl;
    }
}

