/*
 * Decompiled with CFR 0.152.
 */
package com.kt.dao;

import com.kt.io.AbstFile;
import com.kt.io.FileIOUtil;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import com.kt.util.xml.XMLManager;
import com.kt.util.xml.XMLWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ObjectFolderDao {
    protected static final String DEFAULT_HEADER_ENCODING = "Shift_JIS";
    protected static final String DEFAULT_OUTPUT_ENCODING = "MS932";
    protected AbstFile mInputAbstFile = null;
    protected OutputStream mOutputStream = null;
    protected AbstFile mOutputAbstFile = null;

    public ObjectFolder load() {
        return this.load(null);
    }

    public ObjectFolder load(String string) {
        XMLManager xMLManager = new XMLManager();
        xMLManager.load(this.mInputAbstFile, string);
        return xMLManager.getTree();
    }

    public void save(ObjectFolder objectFolder) {
        this.save(objectFolder, DEFAULT_HEADER_ENCODING, DEFAULT_OUTPUT_ENCODING);
    }

    public void save(ObjectFolder objectFolder, String string) {
        this.save(objectFolder, string, string);
    }

    public void save(ObjectFolder objectFolder, String string, String string2) {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(this.mOutputAbstFile.getOutpuStreamToBuffer(), false, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            printStream = new PrintStream(this.mOutputAbstFile.getOutpuStreamToBuffer());
        }
        printStream.println("<?xml version='1.0' encoding='" + string + "'?>");
        XMLWriter.write((ObjectNode)objectFolder, "", printStream, string2);
        this.mOutputAbstFile.closeNewFileToBuffer();
        this.mOutputAbstFile.BufferToOutputStream(this.mOutputStream);
        FileIOUtil.close(printStream);
        FileIOUtil.close(this.mOutputStream);
    }

    public void setInput(File file) {
        InputStream inputStream = null;
        try {
            inputStream = new GZIPInputStream(new FileInputStream(file));
        }
        catch (Exception exception) {
            try {
                inputStream = new FileInputStream(file);
            }
            catch (Exception exception2) {
                throw new RuntimeException(exception);
            }
        }
        this.setInput(inputStream);
    }

    public void setInput(InputStream inputStream) {
        AbstFile abstFile = new AbstFile();
        abstFile.inputStreamToBuffer(inputStream, "");
        this.setInput(abstFile);
    }

    public void setInput(AbstFile abstFile) {
        this.mInputAbstFile = abstFile;
    }

    public void setOutput(File file) {
        this.setOutput(file, false);
    }

    public void setOutput(File file, boolean bl) {
        OutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            if (bl) {
                outputStream = new GZIPOutputStream(outputStream);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.setOutput(outputStream);
    }

    public void setOutput(OutputStream outputStream) {
        this.mOutputStream = outputStream;
        AbstFile abstFile = new AbstFile();
        abstFile.openNewFileToBuffer("");
        this.setOutput(abstFile);
    }

    public void setOutput(AbstFile abstFile) {
        this.mOutputAbstFile = abstFile;
    }
}

