/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.inject;

import java.util.HashMap;
import java.util.Map;
import option.gad.core.inject.GdInjector;
import option.gad.core.inject.GdScopeType;
import option.gad.core.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdInstanceFactory {
    protected static GdInstanceFactory mInstance = new GdInstanceFactory();
    protected Map<Class<?>, Object> mInstanceMap = new HashMap();
    protected Map<Class<?>, GdScopeType> mScopeTypeMap = new HashMap();

    protected GdInstanceFactory() {
    }

    public static GdInstanceFactory getInstance() {
        return mInstance;
    }

    public <T> T getInstance(Class<T> clazz, Object ... objectArray) {
        T t = null;
        GdScopeType gdScopeType = this.mScopeTypeMap.get(clazz);
        if (gdScopeType == null) {
            gdScopeType = GdScopeType.SINGLETON;
        }
        switch (gdScopeType) {
            case SINGLETON: {
                t = this.getSingletonInstance(clazz, objectArray);
                break;
            }
            case PROTOTYPE: {
                t = this.getPrototypeInstance(clazz, objectArray);
            }
        }
        return t;
    }

    public synchronized <T> T getSingletonInstance(Class<T> clazz, Object ... objectArray) {
        Object object = this.mInstanceMap.get(clazz);
        if (object == null) {
            object = ReflectUtil.newInstance(clazz, objectArray);
            this.mInstanceMap.put(clazz, object);
            GdInjector.getInstance().clear();
            GdInjector.getInstance().inject(object);
        }
        return (T)object;
    }

    public <T> T getPrototypeInstance(Class<T> clazz, Object ... objectArray) {
        clazz = ReflectUtil.newInstance(clazz, objectArray);
        GdInjector.getInstance().clear();
        GdInjector.getInstance().inject(clazz);
        return (T)clazz;
    }

    public void addScope(Class<?> clazz, GdScopeType gdScopeType) {
        this.mScopeTypeMap.put(clazz, gdScopeType);
    }

    public void clear() {
        this.mInstanceMap.clear();
        this.mScopeTypeMap.clear();
    }
}

