/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.dxo;

import com.kt.util.StringUtil;
import java.awt.Color;
import java.lang.reflect.Array;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import option.gad.core.dxo.GdTypeConvertable;
import option.gad.core.util.ClassInfoManager;
import option.gad.core.util.ListNotNullDecorator;
import option.gad.core.util.ReflectUtil;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeConvertUtil {
    private static final Log b = LogFactory.getLog(TypeConvertUtil.class);

    protected TypeConvertUtil() {
    }

    public static <T, U> U convert(Class<U> objectArray, T object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            objectArray = ClassInfoManager.getInstance().getClassInfo((Class<?>)objectArray);
            objectArray = objectArray.getArrayType();
            object = (Object[])object;
            ListNotNullDecorator<T> listNotNullDecorator = new ListNotNullDecorator<T>(new ArrayList());
            Object object2 = object;
            int n = ((T)object2).length;
            int n2 = 0;
            while (n2 < n) {
                object = object2[n2];
                listNotNullDecorator.add(TypeConvertUtil.convertObject(objectArray, TypeConvertUtil.convertString(object)));
                ++n2;
            }
            objectArray = listNotNullDecorator.toArray((Object[])Array.newInstance(objectArray, listNotNullDecorator.size()));
        } else {
            objectArray = TypeConvertUtil.convertObject(objectArray, TypeConvertUtil.convertString(object));
        }
        return (U)objectArray;
    }

    public static String convertString(Object object) {
        if (object == null) {
            return null;
        }
        String string = null;
        try {
            if (object.getClass() == Boolean.TYPE) {
                string = TypeConvertUtil.convertString((Boolean)object);
            } else if (object.getClass() == Byte.TYPE) {
                string = TypeConvertUtil.convertString(object);
            } else if (object.getClass() == Integer.TYPE) {
                string = TypeConvertUtil.convertString((Integer)object);
            } else if (object.getClass() == Long.TYPE) {
                string = TypeConvertUtil.convertString(object);
            } else if (object.getClass() == Float.TYPE) {
                string = TypeConvertUtil.convertString((Float)object);
            } else if (object.getClass() == Double.TYPE) {
                string = TypeConvertUtil.convertString(object);
            } else if (Boolean.class.isAssignableFrom(object.getClass())) {
                string = TypeConvertUtil.convertString((Boolean)object);
            } else if (Byte.class.isAssignableFrom(object.getClass())) {
                string = TypeConvertUtil.convertString(object);
            } else if (Integer.class.isAssignableFrom(object.getClass())) {
                string = TypeConvertUtil.convertString((Integer)object);
            } else if (Long.class.isAssignableFrom(object.getClass())) {
                string = TypeConvertUtil.convertString(object);
            } else if (Float.class.isAssignableFrom(object.getClass())) {
                string = TypeConvertUtil.convertString((Float)object);
            } else if (Double.class.isAssignableFrom(object.getClass())) {
                string = TypeConvertUtil.convertString(object);
            } else if (Color.class.isAssignableFrom(object.getClass())) {
                string = TypeConvertUtil.convertString((Color)object);
            } else if (Timestamp.class.isAssignableFrom(object.getClass())) {
                string = TypeConvertUtil.convertString((Timestamp)object);
            } else if (String.class.isAssignableFrom(object.getClass())) {
                string = TypeConvertUtil.convertString((String)object);
            } else if (object.getClass().isEnum()) {
                string = TypeConvertUtil.convertString((Enum)object);
            } else if (object instanceof GdTypeConvertable) {
                string = TypeConvertUtil.convertString((GdTypeConvertable)object);
            } else {
                b.debug((Object)("src[" + object + "] class[" + object.getClass() + "]"));
            }
        }
        catch (Exception exception) {
            b.info((Object)"", (Throwable)exception);
        }
        return string;
    }

    public static String convertString(Boolean bl) {
        if (bl == null) {
            return null;
        }
        return String.valueOf(bl);
    }

    public static String convertString(Float f) {
        if (f == null) {
            return null;
        }
        String string = String.valueOf(f);
        char c = string.charAt(string.length() - 1);
        if (c == '0') {
            return String.valueOf(f.intValue());
        }
        return string;
    }

    public static String convertString(Integer n) {
        if (n == null) {
            return null;
        }
        return String.valueOf(n);
    }

    public static String convertString(Color color) {
        if (color == null) {
            return null;
        }
        return String.valueOf(color.getRGB());
    }

    public static String convertString(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return String.valueOf(timestamp.getTime());
    }

    public static String convertString(Enum<?> enum_) {
        if (enum_ == null) {
            return null;
        }
        return enum_.name();
    }

    public static <T extends Enum<T>> String convertString(Collection<T> object) {
        if (object == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<T> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (Enum)iterator.next();
            arrayList.add(TypeConvertUtil.convertString(object));
        }
        return StringUtil.concat(arrayList, (String)",");
    }

    public static String convertString(String string) {
        if (string == null) {
            return null;
        }
        return string;
    }

    public static String convertString(GdTypeConvertable<?> gdTypeConvertable) {
        if (gdTypeConvertable == null) {
            return null;
        }
        return gdTypeConvertable.toString();
    }

    public static <T> T convertObject(Class<T> clazz, String string) {
        if (StringUtil.isEmpty((String)string)) {
            return null;
        }
        Object object = null;
        try {
            if (clazz == Boolean.TYPE) {
                object = TypeConvertUtil.convertBoolean(string);
            } else if (clazz == Byte.TYPE) {
                object = TypeConvertUtil.convertByte(string);
            } else if (clazz == Integer.TYPE) {
                object = TypeConvertUtil.convertInteger(string);
            } else if (clazz == Long.TYPE) {
                object = TypeConvertUtil.convertLong(string);
            } else if (clazz == Float.TYPE) {
                object = TypeConvertUtil.convertFloat(string);
            } else if (clazz == Double.TYPE) {
                object = TypeConvertUtil.convertDouble(string);
            } else if (Boolean.class.isAssignableFrom(clazz)) {
                object = TypeConvertUtil.convertBoolean(string);
            } else if (Byte.class.isAssignableFrom(clazz)) {
                object = TypeConvertUtil.convertByte(string);
            } else if (Integer.class.isAssignableFrom(clazz)) {
                object = TypeConvertUtil.convertInteger(string);
            } else if (Long.class.isAssignableFrom(clazz)) {
                object = TypeConvertUtil.convertLong(string);
            } else if (Float.class.isAssignableFrom(clazz)) {
                object = TypeConvertUtil.convertFloat(string);
            } else if (Double.class.isAssignableFrom(clazz)) {
                object = TypeConvertUtil.convertDouble(string);
            } else if (Color.class.isAssignableFrom(clazz)) {
                object = TypeConvertUtil.convertColor(string);
            } else if (Timestamp.class.isAssignableFrom(clazz)) {
                object = TypeConvertUtil.convertTimestamp(string);
            } else if (String.class.isAssignableFrom(clazz)) {
                object = TypeConvertUtil.convertString(string);
            } else if (clazz.isEnum()) {
                object = TypeConvertUtil.convertEnum(clazz, string);
            } else if (GdTypeConvertable.class.isAssignableFrom(clazz)) {
                object = TypeConvertUtil.convertTypeConvertable(clazz, string);
            } else {
                b.debug((Object)("src[" + string + "] srcClass[" + string.getClass() + "] toClass[" + clazz + "]"));
            }
        }
        catch (Exception exception) {
            b.info((Object)"", (Throwable)exception);
        }
        return (T)object;
    }

    public static Boolean convertBoolean(String string) {
        Boolean bl = null;
        if (NumberUtils.isNumber((String)string)) {
            int n = NumberUtils.toInt((String)string);
            if (n == 0) {
                bl = false;
            }
            if (n == 1) {
                bl = true;
            }
        } else {
            if (string.equalsIgnoreCase("false")) {
                bl = false;
            }
            if (string.equalsIgnoreCase("true")) {
                bl = true;
            }
        }
        return bl;
    }

    public static Byte convertByte(String string) {
        Byte by = null;
        if (NumberUtils.isNumber((String)string)) {
            by = Byte.parseByte(string);
        }
        return by;
    }

    public static Integer convertInteger(String string) {
        Integer n = null;
        if (NumberUtils.isNumber((String)string)) {
            n = Integer.parseInt(string);
        }
        return n;
    }

    public static Long convertLong(String string) {
        Long l = null;
        if (NumberUtils.isNumber((String)string)) {
            l = Long.parseLong(string);
        }
        return l;
    }

    public static Float convertFloat(String string) {
        Float f = null;
        if (NumberUtils.isNumber((String)string)) {
            f = Float.valueOf(Float.parseFloat(string));
        }
        return f;
    }

    public static Double convertDouble(String string) {
        Double d = null;
        if (NumberUtils.isNumber((String)string)) {
            d = Double.parseDouble(string);
        }
        return d;
    }

    public static Color convertColor(String string) {
        Color color = null;
        try {
            color = new Color(Integer.parseInt(string, 16));
        }
        catch (NumberFormatException numberFormatException) {}
        return color;
    }

    public static Timestamp convertTimestamp(String string) {
        return new Timestamp(Long.parseLong(string));
    }

    public static Object convertEnum(Class<?> clazz, String string) {
        if (StringUtil.isEmpty((String)string)) {
            return null;
        }
        Object var2_3 = null;
        try {
            var2_3 = Enum.valueOf(clazz, string);
        }
        catch (Exception exception) {
            b.warn((Object)"", (Throwable)exception);
        }
        return var2_3;
    }

    public static Object convertTypeConvertable(Class<?> object, String string) {
        if (StringUtil.isEmpty((String)string)) {
            return null;
        }
        Object var2_3 = null;
        try {
            object = (GdTypeConvertable)ReflectUtil.newInstance(object, new Object[0]);
            var2_3 = object.toType(string);
        }
        catch (Exception exception) {
            b.warn((Object)"", (Throwable)exception);
        }
        return var2_3;
    }
}

