/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.util.csv;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import option.gad.core.dxo.TypeConvertUtil;
import option.gad.core.io.FileIOUtil;
import option.gad.core.util.NameUtil;
import option.gad.core.util.ReflectUtil;
import option.gad.core.util.csv.Csv;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvBuilder {
    protected static final String DEFAULT_CHARCTER_ENCODING = "MS932";
    private static final Log b = LogFactory.getLog(CsvBuilder.class);

    public Csv build(String string, boolean bl) {
        return this.build(string, bl, DEFAULT_CHARCTER_ENCODING);
    }

    public Csv build(String string, boolean bl, String string2) {
        return this.build(new ByteArrayInputStream(string.getBytes()), bl, string2);
    }

    public Csv build(File file, boolean bl) {
        return this.build(file, bl, DEFAULT_CHARCTER_ENCODING);
    }

    public Csv build(File file, boolean bl, String string) {
        Csv csv = null;
        try {
            csv = this.build(FileIOUtil.openInReadingMode(file), bl, string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            b.info((Object)"", (Throwable)fileNotFoundException);
        }
        return csv;
    }

    public Csv build(InputStream inputStream, boolean bl) {
        return this.build(inputStream, bl, DEFAULT_CHARCTER_ENCODING);
    }

    public Csv build(InputStream inputStream, boolean bl, String string) {
        return this.build(inputStream, bl, false, string);
    }

    public Csv build(InputStream inputStream, boolean bl, boolean bl2, String string) {
        Csv csv = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                String string2;
                csv = new Csv();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
                while ((string2 = bufferedReader.readLine()) != null) {
                    Object object;
                    if (string2.startsWith("#")) continue;
                    Object object2 = string2.split(",", -1);
                    if (bl) {
                        String[] stringArray = object2;
                        int n = ((String[])object2).length;
                        int n2 = 0;
                        while (n2 < n) {
                            object = stringArray[n2];
                            if (object != null) {
                                object = ((String)object).trim();
                                if (bl2) {
                                    object = NameUtil.convCamelCase((String)object);
                                }
                            }
                            csv.mColNameList.add((String)object);
                            ++n2;
                        }
                        bl = false;
                        continue;
                    }
                    if (csv.mColNameList.isEmpty()) {
                        int n = 0;
                        while (n < ((String[])object2).length) {
                            csv.mColNameList.add(Integer.toString(n));
                            ++n;
                        }
                    }
                    object = new ArrayList();
                    String[] stringArray = object2;
                    int n = ((String[])object2).length;
                    int n3 = 0;
                    while (n3 < n) {
                        object2 = stringArray[n3];
                        if (object2 != null) {
                            object2 = ((String)object2).trim();
                        }
                        if (0 >= csv.mColNameList.size()) {
                            b.info((Object)(String.valueOf(string2) + " : " + csv.mColNameList.size() + " != " + 0));
                        } else {
                            object.add(object2);
                        }
                        ++n3;
                    }
                    csv.mRowList.add((List<String>)object);
                }
            }
            catch (IOException iOException) {
                b.info((Object)"", (Throwable)iOException);
                throw new RuntimeException(iOException);
            }
        }
        catch (Throwable throwable) {
            FileIOUtil.close(bufferedReader);
            throw throwable;
        }
        FileIOUtil.close(bufferedReader);
        return csv;
    }

    public Csv build(List<?> list22) {
        Csv csv = new Csv();
        Collection<Field> collection = null;
        for (List<?> list22 : list22) {
            if (csv.mRowList.isEmpty()) {
                collection = ReflectUtil.getFields(list22);
                for (Field field : collection) {
                    String string = NameUtil.removePrefix(field.getName());
                    csv.mColNameList.add(string);
                }
            }
            ArrayList<String> object2 = new ArrayList<String>();
            for (Field field : collection) {
                Object object = ReflectUtil.getFieldValue(list22, field);
                String string = TypeConvertUtil.convertString(object);
                object2.add(string);
            }
            csv.mRowList.add(object2);
        }
        return csv;
    }
}

