/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.util;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberUtil {
    private NumberUtil() {
    }

    public static <T> T emptyToDefault(T t, T t2) {
        if (t == null) {
            return t2;
        }
        return t;
    }

    public static Integer emptyToNull(Integer n) {
        if (n == null) {
            return null;
        }
        return n;
    }

    public static String formComma(int n) {
        return NumberUtil.formComma(Integer.toString(n));
    }

    public static String formComma(long l) {
        return NumberUtil.formComma(Long.toString(l));
    }

    public static String formComma(float f) {
        return NumberUtil.formComma(Float.toString(f));
    }

    public static String formComma(double d) {
        return NumberUtil.formComma(Double.toString(d));
    }

    public static String formComma(String string) {
        if (string.indexOf(".") == -1) {
            DecimalFormat decimalFormat = new DecimalFormat(",##0");
            string = decimalFormat.format(Long.parseLong(string));
        } else {
            DecimalFormat decimalFormat = new DecimalFormat(",##0.00");
            string = decimalFormat.format(Double.parseDouble(string));
        }
        return string;
    }

    public static String formYen(int n) {
        return NumberUtil.formYen(Integer.toString(n));
    }

    public static String formYen(long l) {
        return NumberUtil.formYen(Long.toString(l));
    }

    public static String formYen(String string) {
        DecimalFormat decimalFormat = string.indexOf(".") == -1 ? new DecimalFormat("\\,##0") : new DecimalFormat("\\,##0.00");
        return decimalFormat.format(Float.parseFloat(string));
    }

    public static boolean isInteger(String string) {
        boolean bl = true;
        return bl;
    }

    public static boolean isDecimal(String string) {
        boolean bl = true;
        return bl;
    }

    public static boolean isDecimal(double d) {
        return d != (double)Math.round(d);
    }

    public static double round(double d, int n) {
        double d2 = 0.0;
        long l = 1L;
        if (n > 0) {
            l = NumberUtil.calcInvokution(10, n);
        } else if (n < -1) {
            l = NumberUtil.calcInvokution(10, Math.abs(n) - 1);
        }
        if (n > 0) {
            double d3 = d / (double)l;
            double d4 = Math.round(d3);
            d2 = d4 * (double)l;
        } else if (n < 0) {
            double d5 = d * (double)l;
            double d6 = Math.round(d5);
            d2 = d6 / (double)l;
        }
        return d2;
    }

    public static long calcInvokution(int n, int n2) {
        long l = n;
        int n3 = 0;
        while (n3 < n2 - 1) {
            l *= (long)n;
            ++n3;
        }
        return l;
    }

    public static Integer parseInteger(String object, Integer n) {
        try {
            object = new Integer((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            object = n;
        }
        return object;
    }

    public static Integer parseInteger(String string, int n) {
        return NumberUtil.parseInteger(string, new Integer(n));
    }

    public static String toString(Integer n, String string) {
        if (n == null) {
            return string;
        }
        return n.toString();
    }

    public static int toInt(boolean bl) {
        if (bl) {
            return 1;
        }
        return 0;
    }

    public static int toInt(Number number) {
        Integer n = null;
        if (number instanceof Integer) {
            n = (Integer)number;
        } else if (number instanceof Float) {
            n = ((Float)number).intValue();
        }
        return n;
    }

    public static String toBase62String(long l) {
        long l2 = l;
        StringBuilder stringBuilder = new StringBuilder(7);
        while (l2 > 0L) {
            int n = (int)(l2 % 62L);
            if (n < 10) {
                stringBuilder.append(n);
            } else if (n < 36) {
                stringBuilder.append((char)(n += 87));
            } else {
                stringBuilder.append((char)(n += 29));
            }
            l2 /= 62L;
        }
        return new String(stringBuilder.reverse());
    }

    public static double max(Collection<Number> object) {
        double d = Double.MIN_VALUE;
        Iterator<Number> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            d = Math.max(((Number)object).doubleValue(), d);
        }
        return d;
    }

    public static float max(float[] fArray) {
        float f = Float.MIN_VALUE;
        float[] fArray2 = fArray;
        int n = fArray.length;
        int n2 = 0;
        while (n2 < n) {
            float f2 = fArray2[n2];
            f = Math.max(f2, f);
            ++n2;
        }
        return f;
    }

    public static double max(double[] dArray) {
        double d = Double.MIN_VALUE;
        double[] dArray2 = dArray;
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double d2 = dArray2[n2];
            d = Math.max(d2, d);
            ++n2;
        }
        return d;
    }

    public static final boolean matchOR(Number number, Number ... object) {
        if (number == null) {
            return false;
        }
        if (object == null) {
            return false;
        }
        if (((Number[])object).length == 0) {
            return false;
        }
        Number[] numberArray = object;
        int n = ((Number[])object).length;
        int n2 = 0;
        while (n2 < n) {
            object = numberArray[n2];
            if (object.equals(number)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final boolean matchAND(Number number, Number ... object) {
        if (number == null) {
            return false;
        }
        if (object == null) {
            return false;
        }
        if (((Number[])object).length == 0) {
            return false;
        }
        boolean bl = true;
        Number[] numberArray = object;
        int n = ((Number[])object).length;
        int n2 = 0;
        while (n2 < n) {
            object = numberArray[n2];
            bl &= object.equals(number);
            ++n2;
        }
        return bl;
    }
}

