/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.util.csv;

import com.kt.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import option.gad.core.util.csv.Csv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvUtil {
    public static Map<Class<?>, Comparator<String>> comparatorMap = new HashMap();

    static {
        comparatorMap.put(StringComparator.class, new StringComparator());
        comparatorMap.put(BitFieldComparator.class, new BitFieldComparator());
        comparatorMap.put(GreaterThanComparator.class, new GreaterThanComparator());
        comparatorMap.put(GreaterEqualComparator.class, new GreaterEqualComparator());
        comparatorMap.put(LessThanComparator.class, new LessThanComparator());
        comparatorMap.put(LessEqualComparator.class, new LessEqualComparator());
    }

    protected CsvUtil() {
    }

    public static Csv select(Csv csv, Collection<String> collection, boolean ... blArray) {
        return CsvUtil.select(csv, collection, null, blArray);
    }

    public static Csv select(Csv csv, Collection<String> collection, Map<String, Comparator<String>> map, boolean ... blArray) {
        if (collection.size() != csv.mColNameList.size()) {
            throw new IllegalArgumentException("keyList.size[" + collection.size() + "] colNameList.size[" + csv.mColNameList.size() + "]");
        }
        Csv csv2 = new Csv();
        for (List<String> list : csv.mRowList) {
            if (!CsvUtil.a(csv.mColNameList, collection, list, map, blArray)) continue;
            csv2.mRowList.add(new ArrayList<String>(list));
        }
        return csv2;
    }

    private static boolean a(Collection<String> object, Collection<String> object2, Collection<String> object3, Map<String, Comparator<String>> map, boolean ... blArray) {
        if (blArray.length > 2) {
            throw new IllegalArgumentException();
        }
        boolean bl = blArray.length > 0 ? blArray[0] : false;
        boolean bl2 = blArray.length >= 2 ? blArray[1] : false;
        object = object.iterator();
        object2 = object2.iterator();
        object3 = object3.iterator();
        while (object2.hasNext()) {
            String string = (String)object.next();
            String string2 = (String)object2.next();
            String string3 = (String)object3.next();
            if (bl2 && !StringUtil.isEmpty((String)string3) && string3.charAt(0) == '#') {
                return false;
            }
            if (string2 == null || bl && (string3 == null || string3.length() == 0)) continue;
            Comparator<String> comparator = null;
            if (map != null) {
                comparator = map.get(string);
            }
            if (comparator == null) {
                comparator = comparatorMap.get(StringComparator.class);
            }
            if (comparator.compare(string2, string3) == 0) continue;
            return false;
        }
        return true;
    }

    public static String[] split(String string) throws NoSuchElementException {
        return CsvUtil.split(string, ",", "\"");
    }

    public static String[] split(String string, String object, String string2) throws NoSuchElementException {
        int n = string.indexOf(string2);
        int n2 = string.lastIndexOf(string2);
        if (n < 0 || n >= n2) {
            return string.split((String)object);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        while (n2 < n4) {
            int n5 = string.indexOf((String)object, n2);
            int n6 = string.indexOf(string2, n2);
            if (n3 == 1) {
                if (n6 < 0) {
                    throw new NoSuchElementException("illegal quotation [" + string + "]");
                }
                arrayList.add(string.substring(n2, n6));
                n2 = n6 + 1;
                n3 = 2;
                continue;
            }
            if (n5 < 0 && n6 < 0) {
                object = string.substring(n2, n4).trim();
                if (object.length() <= 0) break;
                if (n3 == 2) {
                    throw new NoSuchElementException("illegal quotation [" + string + "]");
                }
                if (n2 >= n4) break;
                arrayList.add(object);
                break;
            }
            if (n5 >= 0 && (n6 < 0 || n5 < n6)) {
                if (n3 == 2) {
                    n3 = 0;
                } else {
                    arrayList.add(string.substring(n2, n5).trim());
                }
                n2 = n5 + 1;
                continue;
            }
            if (n6 < 0) continue;
            n2 = n6 + 1;
            n3 = 1;
        }
        object = new String[arrayList.size()];
        int n7 = 0;
        while (n7 < ((String[])object).length) {
            object[n7] = (String)arrayList.get(n7);
            ++n7;
        }
        return object;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BitFieldComparator
    implements Comparator<String> {
        @Override
        public int compare(String object, String object2) {
            object = Integer.parseInt((String)object);
            object2 = Integer.parseInt((String)object2);
            if (((Integer)object & (Integer)object2) != 0) {
                return 0;
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GreaterEqualComparator
    implements Comparator<String> {
        @Override
        public int compare(String object, String object2) {
            object = Double.parseDouble((String)object);
            object2 = Double.parseDouble((String)object2);
            if ((Double)object >= (Double)object2) {
                return 0;
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GreaterThanComparator
    implements Comparator<String> {
        @Override
        public int compare(String object, String object2) {
            object = Double.parseDouble((String)object);
            object2 = Double.parseDouble((String)object2);
            if ((Double)object > (Double)object2) {
                return 0;
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LessEqualComparator
    implements Comparator<String> {
        @Override
        public int compare(String object, String object2) {
            object = Double.parseDouble((String)object);
            object2 = Double.parseDouble((String)object2);
            if ((Double)object <= (Double)object2) {
                return 0;
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LessThanComparator
    implements Comparator<String> {
        @Override
        public int compare(String object, String object2) {
            object = Double.parseDouble((String)object);
            object2 = Double.parseDouble((String)object2);
            if ((Double)object < (Double)object2) {
                return 0;
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringComparator
    implements Comparator<String> {
        @Override
        public int compare(String string, String string2) {
            if (string.equals(string2)) {
                return 0;
            }
            return -1;
        }
    }
}

