/*
 * Decompiled with CFR 0.152.
 */
package option.gad.core.util.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import option.gad.core.io.FileIOUtil;
import option.gad.core.util.csv.Csv;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CsvManager {
    private static final Log a = LogFactory.getLog(CsvManager.class);
    protected LinkedHashMap<String, Csv> mCsvMap = new LinkedHashMap();
    protected String mCharacterEncoding = "MS932";

    public Csv build(File file, boolean bl) {
        return this.build(file, bl, this.mCharacterEncoding);
    }

    public Csv build(File file, boolean bl, String string) {
        Csv csv = null;
        try {
            csv = this.build(FileIOUtil.readOpen(file), bl, string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            a.info((Object)"", (Throwable)fileNotFoundException);
        }
        return csv;
    }

    public Csv build(InputStream inputStream, boolean bl) {
        return this.build(inputStream, bl, this.mCharacterEncoding);
    }

    public Csv build(InputStream inputStream, boolean bl, String string) {
        Csv csv = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                String string2;
                csv = new Csv();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
                while ((string2 = bufferedReader.readLine()) != null) {
                    Object object;
                    if (string2.startsWith("#")) continue;
                    Object object2 = string2.split(",", -1);
                    if (bl) {
                        String[] stringArray = object2;
                        int n = ((String[])object2).length;
                        int n2 = 0;
                        while (n2 < n) {
                            object = stringArray[n2];
                            if (object != null) {
                                object = ((String)object).trim();
                            }
                            csv.mColNameList.add((String)object);
                            ++n2;
                        }
                        bl = false;
                        continue;
                    }
                    if (csv.mColNameList.isEmpty()) {
                        int n = 0;
                        while (n < ((String[])object2).length) {
                            csv.mColNameList.add(Integer.toString(n));
                            ++n;
                        }
                    }
                    object = new ArrayList();
                    String[] stringArray = object2;
                    int n = ((String[])object2).length;
                    int n3 = 0;
                    while (n3 < n) {
                        object2 = stringArray[n3];
                        if (object2 != null) {
                            object2 = ((String)object2).trim();
                        }
                        if (0 >= csv.mColNameList.size()) {
                            a.info((Object)(String.valueOf(string2) + " : " + csv.mColNameList.size() + " != " + 0));
                        } else {
                            object.add(object2);
                        }
                        ++n3;
                    }
                    csv.mRowList.add((List<String>)object);
                }
            }
            catch (IOException iOException) {
                a.info((Object)"", (Throwable)iOException);
                throw new RuntimeException(iOException);
            }
        }
        catch (Throwable throwable) {
            FileIOUtil.close(bufferedReader);
            throw throwable;
        }
        FileIOUtil.close(bufferedReader);
        return csv;
    }

    public void regist(String string, Csv csv) {
        if (string != null && csv != null) {
            this.mCsvMap.put(string, csv);
        }
    }

    public Csv getCsv(String string) {
        return this.mCsvMap.get(string);
    }

    public void setCharacterEncoding(String string) {
        this.mCharacterEncoding = string;
    }
}

